/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.farm.discovery.wadi;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.geronimo.clustering.wadi.BasicWADISessionManager;
import org.apache.geronimo.clustering.wadi.BasicWADISessionManagerHolder;
import org.apache.geronimo.farm.discovery.DiscoveryAgent;
import org.apache.geronimo.farm.discovery.DiscoveryListener;
import org.apache.geronimo.farm.service.NodeServiceTracker;
import org.apache.geronimo.farm.service.NodeServiceTrackerListener;
import org.apache.geronimo.farm.service.NodeServiceVitals;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.codehaus.wadi.servicespace.InvocationMetaData;
import org.codehaus.wadi.servicespace.ServiceProxy;
import org.codehaus.wadi.servicespace.ServiceProxyFactory;
import org.codehaus.wadi.servicespace.ServiceRegistry;
import org.codehaus.wadi.servicespace.ServiceSpace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GBean(name="WADIDiscoveryAgent", j2eeType="GBean")
public class WADIDiscoveryAgent
implements DiscoveryAgent,
GBeanLifecycle {
    static final Logger log = LoggerFactory.getLogger(WADIDiscoveryAgent.class);
    private final BasicWADISessionManager WADISessionManager;
    private NodeServiceTracker localTracker;
    private NodeServiceTracker clusterNodeServiceTrackerProxy;
    private AtomicBoolean started = new AtomicBoolean(false);
    private int maxMissedHeartbeats = 10;
    private long heartRate = 500L;
    private final NodeServiceHandlerThread listener;
    private final String localNodeName;

    public WADIDiscoveryAgent(@ParamReference(name="BasicWADISessionManagerHolder") BasicWADISessionManagerHolder WADISessionManagerHolder, @ParamAttribute(name="heartRate") long heartRate, @ParamAttribute(name="maxMissedHeartbeats") int maxMissedHeartbeats) {
        this.WADISessionManager = WADISessionManagerHolder.getBasicWADISessionManager();
        this.heartRate = heartRate;
        this.maxMissedHeartbeats = maxMissedHeartbeats;
        this.localNodeName = this.WADISessionManager.getNode().getName();
        this.listener = new NodeServiceHandlerThread();
    }

    public String getName() {
        return "WADI disovery Agent";
    }

    public void setDiscoveryListener(final DiscoveryListener listener) {
        this.localTracker.addNodeServiceTrackerListener(new NodeServiceTrackerListener(){

            public void serviceAdded(URI service) {
                listener.serviceAdded(service);
            }

            public void serviceRemoved(URI service) {
                listener.serviceRemoved(service);
            }
        });
    }

    public void registerService(URI serviceUri) throws IOException {
        this.localTracker.registerLocalNodeService(serviceUri);
        this.clusterNodeServiceTrackerProxy.registerNodeService(this.localNodeName, serviceUri);
    }

    public void unregisterService(URI serviceUri) throws IOException {
        this.localTracker.unregisterNodeService(this.localNodeName, serviceUri);
        this.clusterNodeServiceTrackerProxy.unregisterNodeService(this.localNodeName, serviceUri);
    }

    public void reportFailed(URI serviceUri) throws IOException {
        Map<String, NodeServiceVitals> localServices = this.localTracker.getLocalNodeServices();
        NodeServiceVitals vitals = localServices.get(serviceUri);
        if (vitals != null && !vitals.isDead()) {
            localServices.remove(vitals.getService().getUriString());
        }
    }

    public void doStart() throws Exception {
        this.clusterNodeServiceTrackerProxy = this.getClusterNodeServiceTrackerProxy();
        this.localTracker = this.getLocalNodeServiceTracker();
        NodeServiceHandlerThread nodeServiceHandlerThread = new NodeServiceHandlerThread();
        Timer timer = new Timer("WADIDiscoveryAgent: checkRemoteService", true);
        timer.scheduleAtFixedRate((TimerTask)nodeServiceHandlerThread, 0L, this.heartRate);
        if (this.started.compareAndSet(false, true)) {
            Thread listenerThread = new Thread(this.listener);
            listenerThread.setName("WADIDiscoveryAgent: ListenerThread");
            listenerThread.setDaemon(true);
            listenerThread.start();
        }
    }

    public void doStop() throws Exception {
        if (this.started.compareAndSet(true, false)) {
            // empty if block
        }
    }

    public void doFail() {
        try {
            this.doStop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private NodeServiceTracker getClusterNodeServiceTrackerProxy() {
        ServiceSpace serviceSpace = this.WADISessionManager.getServiceSpace();
        ServiceProxyFactory proxyFactory = serviceSpace.getServiceProxyFactory(NodeServiceTracker.NAME, new Class[]{NodeServiceTracker.class});
        InvocationMetaData invocationMetaData = proxyFactory.getInvocationMetaData();
        invocationMetaData.setOneWay(true);
        ServiceProxy proxy = proxyFactory.getProxy();
        return (NodeServiceTracker)proxy;
    }

    private NodeServiceTracker getLocalNodeServiceTracker() {
        ServiceSpace serviceSpace = this.WADISessionManager.getServiceSpace();
        ServiceRegistry serviceRegistry = serviceSpace.getServiceRegistry();
        try {
            return (NodeServiceTracker)serviceRegistry.getStartedService(NodeServiceTracker.NAME);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private void logAllRemoteServices(boolean isVerbose, Map<String, Map<String, NodeServiceVitals>> results) {
        log.info("*" + this.localNodeName + " service registry:");
        Set<String> NodeNameSet = results.keySet();
        int i = 0;
        for (String nodeName : NodeNameSet) {
            log.info("    No." + ++i + ": " + nodeName);
            Map<String, NodeServiceVitals> services_in_node = results.get(nodeName);
            Set<String> serviceURIs = services_in_node.keySet();
            for (String serviceURI : serviceURIs) {
                log.info("");
                log.info("        Service:" + serviceURI);
                if (!isVerbose) continue;
                log.info("        " + services_in_node.get(serviceURI));
            }
        }
        log.info("");
        log.info("");
    }

    class NodeServiceHandlerThread
    extends TimerTask {
        NodeServiceHandlerThread() {
        }

        public void run() {
            this.checkRemoteServices();
            this.broadCastLocalServicesToRemotePeers();
        }

        private void checkRemoteServices() {
            Map<String, Map<String, NodeServiceVitals>> remoteServices = WADIDiscoveryAgent.this.localTracker.getAllRemoteNodeServices();
            long expireTime = System.currentTimeMillis() - WADIDiscoveryAgent.this.heartRate * (long)WADIDiscoveryAgent.this.maxMissedHeartbeats;
            if (remoteServices == null || remoteServices.size() == 0) {
                return;
            }
            for (String nodeName : remoteServices.keySet()) {
                Map<String, NodeServiceVitals> services = remoteServices.get(nodeName);
                for (NodeServiceVitals serviceVitals : services.values()) {
                    NodeServiceVitals vitals;
                    if (serviceVitals.getLastHeartbeat() >= expireTime || (vitals = services.remove(serviceVitals.getService().getUri())) == null || vitals.isDead()) continue;
                    WADIDiscoveryAgent.this.localTracker.unregisterNodeService(nodeName, vitals.getService().getUri());
                }
            }
        }

        private void broadCastLocalServicesToRemotePeers() {
            WADIDiscoveryAgent.this.clusterNodeServiceTrackerProxy.registerNodeServices(WADIDiscoveryAgent.this.localNodeName, WADIDiscoveryAgent.this.localTracker.getLocalNodeServices());
        }
    }
}

