/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.directory;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.directory.ServerStartupConfiguration;
import org.apache.kerberos.protocol.KerberosProtocolProvider;
import org.apache.kerberos.sam.SamSubsystem;
import org.apache.kerberos.service.KdcConfiguration;
import org.apache.kerberos.store.JndiPrincipalStoreImpl;
import org.apache.kerberos.store.PrincipalStore;
import org.apache.ldap.common.exception.LdapConfigurationException;
import org.apache.ldap.common.name.LdapName;
import org.apache.ldap.common.util.NamespaceTools;
import org.apache.ldap.common.util.PropertiesUtils;
import org.apache.ldap.server.jndi.ContextFactoryService;
import org.apache.ldap.server.jndi.CoreContextFactory;
import org.apache.ldap.server.protocol.LdapProtocolProvider;
import org.apache.mina.common.TransportType;
import org.apache.mina.protocol.ProtocolProvider;
import org.apache.mina.registry.Service;
import org.apache.mina.registry.ServiceRegistry;

public class ServerContextFactory
extends CoreContextFactory {
    private static final Log log = LogFactory.getLog((Class)ServerContextFactory.class);
    private static Service ldapService;
    private static Service kerberosService;
    private static ServiceRegistry minaRegistry;

    protected ServiceRegistry getMinaRegistry() {
        return minaRegistry;
    }

    public void afterShutdown(ContextFactoryService service) {
        if (minaRegistry != null) {
            if (ldapService != null) {
                minaRegistry.unbind(ldapService);
                log.debug((Object)("Unbind of LDAP Service complete: " + ldapService));
                ldapService = null;
            }
            if (kerberosService != null) {
                minaRegistry.unbind(kerberosService);
                log.debug((Object)("Unbind of KRB5 Service complete: " + kerberosService));
                kerberosService = null;
            }
        }
    }

    public void afterStartup(ContextFactoryService service) throws NamingException {
        ServerStartupConfiguration cfg = (ServerStartupConfiguration)service.getConfiguration().getStartupConfiguration();
        Hashtable env = service.getConfiguration().getEnvironment();
        if (cfg.isEnableNetworking()) {
            this.setupRegistry(cfg);
            this.startLdapProtocol(cfg, env);
            if (cfg.isEnableKerberos()) {
                this.startKerberosProtocol(env);
            }
        }
    }

    private void setupRegistry(ServerStartupConfiguration cfg) {
        minaRegistry = cfg.getMinaServiceRegistry();
    }

    private void startKerberosProtocol(Hashtable env) throws NamingException {
        Properties props = new Properties();
        Iterator list = env.keySet().iterator();
        while (list.hasNext()) {
            String key = (String)list.next();
            if (!(env.get(key) instanceof String)) continue;
            props.setProperty(key, (String)env.get(key));
        }
        KdcConfiguration config = new KdcConfiguration(props);
        int port = PropertiesUtils.get((Hashtable)env, (Object)"kdc.default.port", (int)88);
        Service service = new Service("kerberos", TransportType.DATAGRAM, (SocketAddress)new InetSocketAddress(port));
        LdapContext ctx = this.getBaseRealmContext(config, env);
        JndiPrincipalStoreImpl store = new JndiPrincipalStoreImpl(ctx, (Name)new LdapName("ou=Users"));
        SamSubsystem.getInstance().setUserContext((DirContext)ctx, "ou=Users");
        try {
            minaRegistry.bind(service, (ProtocolProvider)new KerberosProtocolProvider(config, (PrincipalStore)store));
            kerberosService = service;
            log.debug((Object)("Successful bind of KRB5 Service completed: " + kerberosService));
        }
        catch (IOException e) {
            log.error((Object)"Could not start the kerberos service on port 88", (Throwable)e);
        }
    }

    private LdapContext getBaseRealmContext(KdcConfiguration config, Hashtable env) throws NamingException {
        Hashtable cloned = (Hashtable)env.clone();
        String dn = NamespaceTools.inferLdapName((String)config.getPrimaryRealm());
        cloned.put("java.naming.provider.url", dn);
        log.debug((Object)("Getting initial context for realm base at " + dn + " for " + config.getPrimaryRealm()));
        return new InitialLdapContext(cloned, new Control[0]);
    }

    private void startLdapProtocol(ServerStartupConfiguration cfg, Hashtable env) throws NamingException {
        int port = cfg.getLdapPort();
        InetAddress host = cfg.getHost();
        Service service = new Service("ldap", TransportType.SOCKET, (SocketAddress)new InetSocketAddress(host, port));
        try {
            minaRegistry.bind(service, (ProtocolProvider)new LdapProtocolProvider((Hashtable)env.clone()));
            ldapService = service;
            log.debug((Object)("Successful bind of LDAP Service completed: " + ldapService));
        }
        catch (IOException e) {
            String msg = "Failed to bind the LDAP protocol service to the service registry: " + service;
            LdapConfigurationException lce = new LdapConfigurationException(msg);
            lce.setRootCause((Throwable)e);
            log.error((Object)msg, (Throwable)e);
            throw lce;
        }
    }
}

