/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.directory;

import java.io.File;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.Properties;
import javax.naming.directory.InitialDirContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.directory.DirectoryConfigurator;
import org.apache.geronimo.directory.MutableServerStartupConfiguration;
import org.apache.geronimo.directory.ServerContextFactory;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.system.serverinfo.ServerInfo;
import org.apache.ldap.server.configuration.ShutdownConfiguration;
import org.apache.ldap.server.jndi.CoreContextFactory;

public class DirectoryGBean
implements GBeanLifecycle {
    private static final Log log = LogFactory.getLog((Class)DirectoryGBean.class);
    private final ServerInfo serverInfo;
    private final String workingDir;
    private final boolean anonymousAccess;
    private String providerURL;
    private String securityPrincipal;
    private String securityCredentials;
    private String securityAuthentication;
    private int port = 389;
    private InetAddress host = null;
    private boolean enableNetworking;
    private final String configFile;
    private ClassLoader classLoader;
    public static final GBeanInfo GBEAN_INFO;

    public DirectoryGBean(ClassLoader classLoader, String workingDir, boolean anonymousAccess, String configFile, ServerInfo serverInfo) {
        if (serverInfo == null) {
            throw new IllegalArgumentException("Must have a ServerInfo value in initParams.");
        }
        this.workingDir = workingDir == null ? "var/ldap" : workingDir;
        this.classLoader = classLoader;
        this.anonymousAccess = anonymousAccess;
        this.configFile = configFile;
        this.serverInfo = serverInfo;
        this.setHost("0.0.0.0");
    }

    public String getProviderURL() {
        return this.providerURL;
    }

    public void setProviderURL(String providerURL) {
        this.providerURL = providerURL;
    }

    public String getSecurityAuthentication() {
        return this.securityAuthentication;
    }

    public void setSecurityAuthentication(String securityAuthentication) {
        this.securityAuthentication = securityAuthentication;
    }

    public String getSecurityCredentials() {
        return this.securityCredentials;
    }

    public void setSecurityCredentials(String securityCredentials) {
        this.securityCredentials = securityCredentials;
    }

    public String getSecurityPrincipal() {
        return this.securityPrincipal;
    }

    public void setSecurityPrincipal(String securityPrincipal) {
        this.securityPrincipal = securityPrincipal;
    }

    public boolean isEnableNetworking() {
        return this.enableNetworking;
    }

    public void setEnableNetworking(boolean enableNetworking) {
        this.enableNetworking = enableNetworking;
    }

    public String getHost() {
        if (this.host == null) {
            return "0.0.0.0";
        }
        return this.host.getHostAddress();
    }

    public void setHost(String host) {
        try {
            if (host == null) {
                this.host = null;
                return;
            }
            String strHost = host.trim();
            if (strHost.equals("0.0.0.0")) {
                this.host = null;
                return;
            }
            this.host = InetAddress.getByName(strHost);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void doFail() {
        log.warn((Object)"Service failed");
    }

    public InetSocketAddress getListenAddress() {
        return new InetSocketAddress(this.getHost(), this.getPort());
    }

    private void setEnvironment(Properties env) {
        if (this.providerURL != null) {
            env.put("java.naming.provider.url", this.providerURL);
        }
        if (this.securityAuthentication != null) {
            env.put("java.naming.security.authentication", this.securityAuthentication);
        }
        if (this.securityPrincipal != null) {
            env.put("java.naming.security.principal", this.securityPrincipal);
        }
        if (this.securityCredentials != null) {
            env.put("java.naming.security.credentials", this.securityCredentials);
        }
    }

    public void doStart() throws Exception {
        log.debug((Object)"Starting LDAP Directory service");
        MutableServerStartupConfiguration startup = new MutableServerStartupConfiguration();
        startup.setWorkingDirectory(this.serverInfo.resolveServer(this.workingDir));
        startup.setAllowAnonymousAccess(this.anonymousAccess);
        startup.setLdapPort(this.port);
        startup.setEnableNetworking(this.enableNetworking);
        startup.setHost(this.host);
        if (this.configFile != null) {
            File f = this.serverInfo.resolve(this.configFile);
            DirectoryConfigurator dc = new DirectoryConfigurator();
            dc.configure(this.classLoader, startup, f);
        }
        Properties env = new Properties();
        env.putAll((Map<?, ?>)startup.toJndiEnvironment());
        env.put("java.naming.factory.initial", ServerContextFactory.class.getName());
        this.setEnvironment(env);
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.classLoader);
        new InitialDirContext(env);
        Thread.currentThread().setContextClassLoader(oldCL);
        log.debug((Object)"LDAP Directory service started.");
    }

    public void doStop() throws Exception {
        log.debug((Object)"Stopping LDAP Directory service");
        Properties env = new Properties();
        env.putAll((Map<?, ?>)new ShutdownConfiguration().toJndiEnvironment());
        env.put("java.naming.factory.initial", CoreContextFactory.class.getName());
        this.setEnvironment(env);
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.classLoader);
        new InitialDirContext(env);
        Thread.currentThread().setContextClassLoader(oldCL);
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic((String)"Apache Directory LDAP", (Class)DirectoryGBean.class);
        infoFactory.addAttribute("classLoader", ClassLoader.class, false);
        infoFactory.addAttribute("providerURL", String.class, true, true);
        infoFactory.addAttribute("securityAuthentication", String.class, true, true);
        infoFactory.addAttribute("securityPrincipal", String.class, true, true);
        infoFactory.addAttribute("securityCredentials", String.class, true, true);
        infoFactory.addAttribute("port", Integer.TYPE, true, true);
        infoFactory.addAttribute("host", String.class, true, true);
        infoFactory.addAttribute("listenAddress", InetSocketAddress.class, false, false);
        infoFactory.addAttribute("enableNetworking", Boolean.TYPE, true, true);
        infoFactory.addAttribute("workingDir", String.class, true);
        infoFactory.addAttribute("anonymousAccess", Boolean.TYPE, true);
        infoFactory.addAttribute("configFile", String.class, true);
        infoFactory.addReference("ServerInfo", ServerInfo.class, "GBean");
        infoFactory.setConstructor(new String[]{"classLoader", "workingDir", "anonymousAccess", "configFile", "ServerInfo"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

