/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.xml;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.xml.resolver.Catalog;
import org.apache.xml.resolver.CatalogEntry;
import org.apache.xml.resolver.CatalogException;
import org.apache.xml.resolver.CatalogManager;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class LocalEntityResolver
implements EntityResolver {
    private static final Log log = LogFactory.getLog((Class)LocalEntityResolver.class);
    private final CatalogManager manager = new CatalogManager();
    private Catalog catalog = null;
    private URI catalogFileURI = null;
    private URI localRepositoryURI = null;
    private boolean failOnUnresolvable = false;
    public static final GBeanInfo GBEAN_INFO;

    public LocalEntityResolver(URI catalogFileURI, URI localRepositoryURI, boolean failOnUnresolvable) {
        this.catalogFileURI = catalogFileURI;
        this.setLocalRepositoryURI(localRepositoryURI);
        this.setFailOnUnresolvable(failOnUnresolvable);
        this.init();
    }

    public void setFailOnUnresolvable(boolean b) {
        this.failOnUnresolvable = b;
    }

    public boolean isFailOnUnresolvable() {
        return this.failOnUnresolvable;
    }

    public void setCatalogFileURI(URI catalogFileURI) {
        this.catalogFileURI = catalogFileURI;
        this.init();
    }

    public URI getCatalogFileURI() {
        return this.catalogFileURI;
    }

    public URI getLocalRepositoryURI() {
        return this.localRepositoryURI;
    }

    public void setLocalRepositoryURI(URI string) {
        this.localRepositoryURI = string;
    }

    public void addPublicMapping(String publicId, String uri) {
        Vector<String> args = new Vector<String>();
        args.add(publicId);
        args.add(uri);
        this.addEntry("PUBLIC", args);
    }

    public void addSystemMapping(String systemId, String uri) {
        Vector<String> args = new Vector<String>();
        args.add(systemId);
        args.add(uri);
        this.addEntry("SYSTEM", args);
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        InputSource source;
        if (log.isTraceEnabled()) {
            log.trace((Object)("start resolving for " + this.entityMessageString(publicId, systemId)));
        }
        if ((source = this.resolveWithCatalog(publicId, systemId)) != null) {
            return source;
        }
        source = this.resolveWithRepository(publicId, systemId);
        if (source != null) {
            return source;
        }
        source = this.resolveWithClasspath(publicId, systemId);
        if (source != null) {
            return source;
        }
        String message = "could not resolve " + this.entityMessageString(publicId, systemId);
        if (this.failOnUnresolvable) {
            throw new SAXException(message);
        }
        log.debug((Object)message);
        return null;
    }

    InputSource resolveWithCatalog(String publicId, String systemId) throws MalformedURLException, IOException {
        if (this.catalogFileURI == null) {
            return null;
        }
        String resolvedSystemId = this.catalog.resolvePublic(this.guaranteeNotNull(publicId), systemId);
        if (resolvedSystemId != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("resolved " + this.entityMessageString(publicId, systemId) + " using the catalog file. result: " + resolvedSystemId));
            }
            return new InputSource(resolvedSystemId);
        }
        return null;
    }

    InputSource resolveWithRepository(String publicId, String systemId) {
        URI resolvedSystemIDURI;
        if (this.localRepositoryURI == null) {
            return null;
        }
        String fileName = this.getSystemIdFileName(systemId);
        if (fileName == null) {
            return null;
        }
        InputStream inputStream = null;
        try {
            resolvedSystemIDURI = this.localRepositoryURI.resolve(fileName);
            inputStream = resolvedSystemIDURI.toURL().openStream();
        }
        catch (IOException e) {
            return null;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        if (inputStream != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("resolved " + this.entityMessageString(publicId, systemId) + "with file relative to " + this.localRepositoryURI + resolvedSystemIDURI));
            }
            return new InputSource(inputStream);
        }
        return null;
    }

    InputSource resolveWithClasspath(String publicId, String systemId) {
        String fileName = this.getSystemIdFileName(systemId);
        if (fileName == null) {
            return null;
        }
        InputStream in = this.getClass().getClassLoader().getResourceAsStream(fileName);
        if (in != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("resolved " + this.entityMessageString(publicId, systemId) + " via file found file on classpath: " + fileName));
            }
            InputSource is = new InputSource(new BufferedInputStream(in));
            is.setSystemId(systemId);
            return is;
        }
        return null;
    }

    private String guaranteeNotNull(String string) {
        return string != null ? string : "";
    }

    private String getSystemIdFileName(String systemId) {
        if (systemId == null) {
            return null;
        }
        int indexBackSlash = systemId.lastIndexOf("\\");
        int indexSlash = systemId.lastIndexOf("/");
        int index = Math.max(indexBackSlash, indexSlash);
        String fileName = systemId.substring(index + 1);
        return fileName;
    }

    private String entityMessageString(String publicId, String systemId) {
        StringBuffer buffer = new StringBuffer("entity with publicId '");
        buffer.append(publicId);
        buffer.append("' and systemId '");
        buffer.append(systemId);
        buffer.append("'");
        return buffer.toString();
    }

    private void addEntry(String type, Vector args) {
        try {
            CatalogEntry entry = new CatalogEntry(type, args);
            this.catalog.addEntry(entry);
        }
        catch (CatalogException e) {
            throw new RuntimeException(e);
        }
    }

    private void init() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("init catalog file " + this.catalogFileURI));
        }
        this.manager.setUseStaticCatalog(false);
        this.manager.setCatalogFiles(this.catalogFileURI.toString());
        this.manager.setIgnoreMissingProperties(true);
        this.catalog = this.manager.getCatalog();
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic((String)"configurable local entity resolver", (Class)LocalEntityResolver.class);
        infoFactory.addAttribute("catalogFileURI", URI.class, true);
        infoFactory.addAttribute("localRepositoryURI", URI.class, true);
        infoFactory.addAttribute("failOnUnresolvable", Boolean.TYPE, true);
        infoFactory.addOperation("resolveEntity", new Class[]{String.class, String.class});
        infoFactory.addOperation("addPublicMapping", new Class[]{String.class, String.class});
        infoFactory.addOperation("addSystemMapping", new Class[]{String.class, String.class});
        infoFactory.setConstructor(new String[]{"catalogFileURI", "localRepositoryURI", "failOnUnresolvable"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

