/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment;

import [Ljava.lang.String;;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.ConfigurationBuilder;
import org.apache.geronimo.deployment.ModuleIDBuilder;
import org.apache.geronimo.deployment.util.DeploymentUtil;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.kernel.config.ConfigurationData;
import org.apache.geronimo.kernel.config.ConfigurationInfo;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationStore;
import org.apache.geronimo.kernel.config.NoSuchConfigException;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.ArtifactResolver;
import org.apache.geronimo.kernel.repository.Version;
import org.apache.geronimo.system.serverinfo.ServerInfo;

public class SingleFileHotDeployer {
    private static final Log log = LogFactory.getLog((Class)SingleFileHotDeployer.class);
    private static final String LINE_SEP = System.getProperty("line.separator");
    private final File dir;
    private final String[] watchPaths;
    private final Collection builders;
    private final ConfigurationStore store;
    private final ConfigurationManager configurationManager;
    private final boolean forceDeploy;
    private final Artifact configurationId;
    private boolean wasDeployed;
    public static final GBeanInfo GBEAN_INFO;

    public SingleFileHotDeployer(String path, ServerInfo serverInfo, String[] watchPaths, Collection builders, ConfigurationStore store, ConfigurationManager configurationManager, boolean forceDeploy) throws DeploymentException {
        this(serverInfo.resolve(path), watchPaths, builders, store, configurationManager, forceDeploy);
    }

    public SingleFileHotDeployer(File dir, String[] watchPaths, Collection builders, ConfigurationStore store, ConfigurationManager configurationManager, boolean forceDeploy) throws DeploymentException {
        this.dir = dir;
        this.watchPaths = watchPaths;
        this.builders = builders;
        this.store = store;
        this.configurationManager = configurationManager;
        this.forceDeploy = forceDeploy;
        this.configurationId = this.start(dir);
    }

    private Artifact start(File dir) throws DeploymentException {
        Artifact existingConfigurationId;
        if (!dir.exists()) {
            throw new IllegalArgumentException("Directory does not exist " + dir.getAbsolutePath());
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("Directory is not a directory " + dir.getAbsolutePath());
        }
        if (dir.list().length == 0) {
            return null;
        }
        ConfigurationInfo existingConfiguration = null;
        List list = this.configurationManager.listConfigurations();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ConfigurationInfo configurationInfo = (ConfigurationInfo)iterator.next();
            if (!dir.equals(configurationInfo.getInPlaceLocation())) continue;
            existingConfiguration = configurationInfo;
        }
        Artifact artifact = existingConfigurationId = existingConfiguration == null ? null : existingConfiguration.getConfigID();
        if (!this.forceDeploy && existingConfiguration != null && !this.isModifiedSince(existingConfiguration.getCreated())) {
            try {
                this.configurationManager.loadConfiguration(existingConfigurationId);
                this.configurationManager.startConfiguration(existingConfigurationId);
            }
            catch (Exception e) {
                throw new DeploymentException("Unable to load and start " + dir, (Throwable)e);
            }
            return existingConfigurationId;
        }
        if (existingConfigurationId != null && this.configurationManager.isLoaded(existingConfigurationId)) {
            try {
                this.configurationManager.unloadConfiguration(existingConfigurationId);
            }
            catch (NoSuchConfigException e) {
                throw new DeploymentException("Unable to unload existing configuration " + existingConfigurationId);
            }
        }
        ModuleIDBuilder idBuilder = new ModuleIDBuilder();
        JarFile module = null;
        try {
            module = DeploymentUtil.createJarFile(dir);
        }
        catch (IOException e) {
            throw new DeploymentException("Cound not open module file: " + dir.getAbsolutePath(), (Throwable)e);
        }
        try {
            Object plan = null;
            ConfigurationBuilder builder = null;
            Iterator i = this.builders.iterator();
            while (i.hasNext()) {
                ConfigurationBuilder candidate = (ConfigurationBuilder)i.next();
                plan = candidate.getDeploymentPlan(null, module, idBuilder);
                if (plan == null) continue;
                builder = candidate;
                break;
            }
            if (builder == null) {
                throw new DeploymentException("Cannot deploy the requested application module because no builder is able to handle it (dir=" + dir.getAbsolutePath() + ")");
            }
            Artifact configurationId = builder.getConfigurationID(plan, module, idBuilder);
            if (!configurationId.isResolved()) {
                configurationId = this.resolve(configurationId);
            }
            if (existingConfigurationId == null && this.configurationManager.isInstalled(configurationId)) {
                log.info((Object)"Existing Module found by moduleId");
                existingConfigurationId = configurationId;
            }
            if (configurationId.equals((Object)existingConfigurationId)) {
                log.info((Object)("Undeploying " + existingConfigurationId));
                this.configurationManager.uninstallConfiguration(existingConfigurationId);
            }
            this.deployConfiguration(builder, this.store, configurationId, plan, module, Arrays.asList(this.configurationManager.getStores()), this.configurationManager.getArtifactResolver());
            this.wasDeployed = true;
            this.configurationManager.loadConfiguration(configurationId);
            this.configurationManager.startConfiguration(configurationId);
            log.info((Object)("Successfully deployed and started " + configurationId + " in location " + dir));
            Artifact artifact2 = configurationId;
            return artifact2;
        }
        catch (Exception e) {
            throw new DeploymentException("Unable to deploy " + dir, (Throwable)e);
        }
        finally {
            DeploymentUtil.close(module);
        }
    }

    private boolean isModifiedSince(long created) {
        for (int i = 0; i < this.watchPaths.length; ++i) {
            String path = this.watchPaths[i];
            File file = new File(this.dir, path);
            if (!file.exists()) {
                log.warn((Object)("Watched file does not exist " + file));
            }
            if (!file.isFile() || file.lastModified() <= created) continue;
            log.info((Object)("Redeploying " + this.dir + " because file " + file + " was modified;"));
            return true;
        }
        return false;
    }

    private Artifact resolve(Artifact configID) throws DeploymentException {
        String type;
        String artifactId;
        String group = configID.getGroupId();
        if (group == null) {
            group = "default";
        }
        if ((artifactId = configID.getArtifactId()) == null) {
            throw new DeploymentException("Every configuration to deploy must have a ConfigID with an ArtifactID (not " + configID + ")");
        }
        Version version = configID.getVersion();
        if (version == null) {
            version = new Version(Long.toString(System.currentTimeMillis()));
        }
        if ((type = configID.getType()) == null) {
            type = "car";
        }
        return new Artifact(group, artifactId, version, type);
    }

    /*
     * Exception decompiling
     */
    private List deployConfiguration(ConfigurationBuilder builder, ConfigurationStore store, Artifact configurationId, Object plan, JarFile module, Collection stores, ArtifactResolver artifactResolver) throws DeploymentException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void cleanupConfigurations(List configurations) {
        LinkedList cannotBeDeletedList = new LinkedList();
        Iterator iterator = configurations.iterator();
        while (iterator.hasNext()) {
            ConfigurationData configurationData = (ConfigurationData)iterator.next();
            File dir = configurationData.getConfigurationDir();
            cannotBeDeletedList.clear();
            if (DeploymentUtil.recursiveDelete(dir, cannotBeDeletedList)) continue;
            log.warn((Object)("Unable to delete " + cannotBeDeletedList.size() + " files while recursively deleting directory " + dir + LINE_SEP + "The first file that could not be deleted was:" + LINE_SEP + "  " + (!cannotBeDeletedList.isEmpty() ? cannotBeDeletedList.getFirst() : "")));
        }
    }

    public File getDir() {
        return this.dir;
    }

    public Artifact getConfigurationId() {
        return this.configurationId;
    }

    public boolean isForceDeploy() {
        return this.forceDeploy;
    }

    public boolean wasDeployed() {
        return this.wasDeployed;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic((Class)SingleFileHotDeployer.class);
        infoFactory.addAttribute("path", String.class, true);
        infoFactory.addReference("ServerInfo", ServerInfo.class);
        infoFactory.addAttribute("watchPaths", String;.class, true);
        infoFactory.addReference("Builders", ConfigurationBuilder.class);
        infoFactory.addReference("Store", ConfigurationStore.class);
        infoFactory.addReference("ConfigurationManager", ConfigurationManager.class);
        infoFactory.addAttribute("forceDeploy", Boolean.TYPE, true);
        infoFactory.setConstructor(new String[]{"path", "ServerInfo", "watchPaths", "Builders", "Store", "ConfigurationManager", "forceDeploy"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

