/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.plugin.remote;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.deployment.plugin.local.AbstractDeployCommand;
import org.apache.geronimo.util.encoders.Base64;

public class RemoteDeployUtil {
    private static final Log log = LogFactory.getLog(RemoteDeployUtil.class);
    public static final int REMOTE_DEPLOY_REQUEST_VER_0 = 0;
    public static final int REMOTE_DEPLOY_RESPONSE_VER_0 = 0;
    public static final int REMOTE_DEPLOY_REQUEST_VER = 0;
    public static final int REMOTE_DEPLOY_RESPONSE_VER = 0;

    public static void uploadFilesToServer(File[] files, AbstractDeployCommand progress) {
        if (files == null) {
            return;
        }
        LinkedList<Integer> valid = new LinkedList<Integer>();
        for (int i = 0; i < files.length; ++i) {
            File file;
            if (files[i] == null || !(file = files[i]).exists() || !file.canRead()) continue;
            valid.add(new Integer(i));
        }
        if (valid.size() > 0) {
            progress.updateStatus("Uploading " + valid.size() + " file(s) to server");
            if (log.isDebugEnabled()) {
                log.debug((Object)("Uploading " + valid.size() + " file(s) to server"));
            }
            try {
                URL url = progress.getRemoteDeployUploadURL();
                URLConnection con = RemoteDeployUtil.connectToServer(url, progress.getCommandContext().getUsername(), progress.getCommandContext().getPassword());
                DataOutputStream out = new DataOutputStream(new BufferedOutputStream(con.getOutputStream()));
                out.writeInt(0);
                out.writeInt(valid.size());
                byte[] buf = new byte[1024];
                for (Integer index : valid) {
                    int size;
                    long threshold;
                    File file = files[index];
                    out.writeUTF(file.getName().trim());
                    long length = file.length();
                    out.writeLong(length);
                    long next = threshold = Math.max(length / 100L, 10240L);
                    BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Uploading " + file.getName()));
                    }
                    long total = 0L;
                    while ((size = in.read(buf)) > -1) {
                        out.write(buf, 0, size);
                        if ((total += (long)size) <= next) continue;
                        progress.updateStatus("Uploading " + file.getName() + ": " + total / 1024L + " KB");
                        while (total > next) {
                            next += threshold;
                        }
                    }
                    in.close();
                }
                out.flush();
                out.close();
                DataInputStream in = new DataInputStream(new BufferedInputStream(con.getInputStream()));
                int rspVer = in.readInt();
                if (rspVer >= 0 && rspVer <= 0) {
                    int count;
                    String status = in.readUTF();
                    if (!status.equals("OK")) {
                        progress.fail("Unable to upload files to server.  Server returned status=" + status);
                        log.error((Object)("Unable to upload files to server.  Server returned status=" + status));
                        return;
                    }
                    progress.updateStatus("File upload complete (Server status=" + status + ")");
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("File upload complete (Server status=" + status + ")"));
                    }
                    if ((count = in.readInt()) != valid.size()) {
                        progress.fail("Server only received " + count + " of " + valid.size() + " files");
                        log.warn((Object)("Server only received " + count + " of " + valid.size() + " files"));
                    }
                    for (Integer index : valid) {
                        String serverFileName = in.readUTF();
                        if (serverFileName != null) {
                            files[index.intValue()] = new File(serverFileName);
                        } else {
                            log.error((Object)"Received an invalid filename from the server");
                            files[index.intValue()] = null;
                        }
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("Server created file=" + serverFileName));
                    }
                    if (rspVer > 0 && rspVer > 0) {
                        log.warn((Object)("Received a newer server response (" + rspVer + ") than expected (" + 0 + ").  Ignoring any additional server response data."));
                    }
                } else {
                    progress.fail("Received unknown server response version=" + rspVer);
                    log.warn((Object)("Received unknown server response version=" + rspVer));
                }
                in.close();
                progress.updateStatus("File(s) transferred to server.  Resuming deployment operation.");
            }
            catch (Exception e) {
                progress.doFail(e);
            }
        }
    }

    private static URLConnection connectToServer(URL url, String username, String password) throws IOException {
        URLConnection con = url.openConnection();
        String auth = username + ":" + password;
        byte[] data = auth.getBytes();
        String s = new String(Base64.encode((byte[])data));
        while (s.length() % 4 != 0) {
            s = s + "=";
        }
        con.setRequestProperty("Authorization", "Basic " + s);
        con.setDoInput(true);
        con.setDoOutput(true);
        con.connect();
        return con;
    }
}

