/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.cxf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.Principal;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.Binding;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.security.SecurityContext;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.transport.Session;
import org.apache.cxf.transport.http.AbstractHTTPDestination;
import org.apache.cxf.transport.http.HTTPSession;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.geronimo.cxf.CXFEndpoint;
import org.apache.geronimo.webservices.WebServiceContainer;

public class GeronimoDestination
extends AbstractHTTPDestination
implements Serializable {
    private MessageObserver messageObserver;
    private boolean passSecurityContext = false;
    private CXFEndpoint endpoint;

    public GeronimoDestination(Bus bus, ConduitInitiator conduitInitiator, EndpointInfo endpointInfo) throws IOException {
        super(bus, conduitInitiator, endpointInfo, false);
        this.endpoint = (CXFEndpoint)bus.getExtension(CXFEndpoint.class);
    }

    private Binding getBinding() {
        return this.endpoint.getEndpoint().getBinding();
    }

    public void setPassSecurityContext(boolean passSecurityContext) {
        this.passSecurityContext = passSecurityContext;
    }

    public boolean getPassSecurityContext() {
        return this.passSecurityContext;
    }

    public EndpointInfo getEndpointInfo() {
        return this.endpointInfo;
    }

    public void invoke(WebServiceContainer.Request request, WebServiceContainer.Response response) throws Exception {
        MessageImpl message = new MessageImpl();
        message.setContent(InputStream.class, (Object)request.getInputStream());
        message.setDestination((Destination)this);
        message.put(WebServiceContainer.Request.class, (Object)request);
        message.put(WebServiceContainer.Response.class, (Object)response);
        final HttpServletRequest servletRequest = (HttpServletRequest)request.getAttribute(WebServiceContainer.SERVLET_REQUEST);
        message.put((Object)"HTTP.REQUEST", (Object)servletRequest);
        HttpServletResponse servletResponse = (HttpServletResponse)request.getAttribute(WebServiceContainer.SERVLET_RESPONSE);
        message.put((Object)"HTTP.RESPONSE", (Object)servletResponse);
        ServletContext servletContext = (ServletContext)request.getAttribute(WebServiceContainer.SERVLET_CONTEXT);
        message.put((Object)"HTTP.CONTEXT", (Object)servletContext);
        if (this.passSecurityContext) {
            message.put(SecurityContext.class, (Object)new SecurityContext(){

                public Principal getUserPrincipal() {
                    return servletRequest.getUserPrincipal();
                }

                public boolean isUserInRole(String role) {
                    return servletRequest.isUserInRole(role);
                }
            });
        }
        this.setHeaders((Message)message);
        message.put((Object)Message.HTTP_REQUEST_METHOD, (Object)servletRequest.getMethod());
        message.put((Object)Message.PATH_INFO, (Object)servletRequest.getPathInfo());
        message.put((Object)Message.QUERY_STRING, (Object)servletRequest.getQueryString());
        message.put((Object)"Content-Type", (Object)servletRequest.getContentType());
        message.put((Object)Message.ENCODING, (Object)GeronimoDestination.getCharacterEncoding(servletRequest.getCharacterEncoding()));
        ExchangeImpl exchange = new ExchangeImpl();
        exchange.setInMessage(this.getBinding().createMessage((Message)message));
        exchange.setSession((Session)new HTTPSession(servletRequest));
        this.messageObserver.onMessage((Message)message);
    }

    private static String getCharacterEncoding(String encoding) {
        if (encoding != null && (encoding = encoding.trim()).endsWith("\"")) {
            encoding = encoding.substring(0, encoding.length() - 1);
        }
        return encoding;
    }

    public Logger getLogger() {
        return Logger.getLogger(GeronimoDestination.class.getName());
    }

    public Conduit getInbuiltBackChannel(Message inMessage) {
        return new BackChannelConduit(null, inMessage);
    }

    public Conduit getBackChannel(Message inMessage, Message partialResponse, EndpointReferenceType address) throws IOException {
        BackChannelConduit backChannel = null;
        if (address == null) {
            backChannel = new BackChannelConduit(address, inMessage);
        } else if (partialResponse != null) {
            partialResponse.put((Object)Message.RESPONSE_CODE, (Object)202);
            backChannel = new BackChannelConduit(address, inMessage);
        } else {
            backChannel = this.conduitInitiator.getConduit(this.endpointInfo, address);
            backChannel.setMessageObserver(new MessageObserver(){

                public void onMessage(Message m) {
                    if (m.getContentFormats().contains(InputStream.class)) {
                        InputStream is = (InputStream)m.getContent(InputStream.class);
                        try {
                            is.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            });
        }
        return backChannel;
    }

    public void shutdown() {
    }

    public void setMessageObserver(MessageObserver messageObserver) {
        this.messageObserver = messageObserver;
    }

    private String getHeaderValue(List<String> values) {
        Iterator<String> iter = values.iterator();
        StringBuilder buf = new StringBuilder();
        while (iter.hasNext()) {
            buf.append((Object)iter.next());
            if (!iter.hasNext()) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    protected void setContentType(Message message, WebServiceContainer.Response response) {
        Map protocolHeaders = (Map)message.get((Object)Message.PROTOCOL_HEADERS);
        if (protocolHeaders == null || !protocolHeaders.containsKey("Content-Type")) {
            String ct = (String)message.get((Object)"Content-Type");
            String enc = (String)message.get((Object)Message.ENCODING);
            if (null != ct) {
                if (enc != null && ct.indexOf("charset=") == -1) {
                    ct = ct + "; charset=" + enc;
                }
                response.setContentType(ct);
            } else if (enc != null) {
                response.setContentType("text/xml; charset=" + enc);
            }
        }
    }

    private class WrappedOutputStream
    extends OutputStream {
        private Message message;
        private WebServiceContainer.Response response;
        private OutputStream rawOutputStream;

        WrappedOutputStream(Message message, WebServiceContainer.Response response) {
            this.message = message;
            this.response = response;
        }

        @Override
        public void write(int b) throws IOException {
            this.flushHeaders();
            this.rawOutputStream.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.flushHeaders();
            this.rawOutputStream.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.flushHeaders();
            this.rawOutputStream.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.flushHeaders();
            this.rawOutputStream.flush();
        }

        @Override
        public void close() throws IOException {
            this.flushHeaders();
            this.rawOutputStream.close();
        }

        protected void flushHeaders() throws IOException {
            if (this.rawOutputStream != null) {
                return;
            }
            Integer i = (Integer)this.message.get((Object)Message.RESPONSE_CODE);
            if (i != null) {
                this.response.setStatusCode(i.intValue());
            }
            GeronimoDestination.this.setContentType(this.message, this.response);
            this.rawOutputStream = this.response.getOutputStream();
        }
    }

    protected class BackChannelConduit
    implements Conduit {
        protected Message request;
        protected EndpointReferenceType target;

        BackChannelConduit(EndpointReferenceType target, Message request) {
            this.target = target;
            this.request = request;
        }

        public void close(Message msg) throws IOException {
            ((OutputStream)msg.getContent(OutputStream.class)).close();
        }

        public void setMessageObserver(MessageObserver observer) {
        }

        public void prepare(Message message) throws IOException {
            this.send(message);
        }

        public void send(Message message) throws IOException {
            WebServiceContainer.Response response = (WebServiceContainer.Response)this.request.get(WebServiceContainer.Response.class);
            GeronimoDestination.this.updateResponseHeaders(message);
            Map protocolHeaders = (Map)message.get((Object)Message.PROTOCOL_HEADERS);
            for (Map.Entry entry : protocolHeaders.entrySet()) {
                String headerName = (String)entry.getKey();
                String headerValue = GeronimoDestination.this.getHeaderValue((List)entry.getValue());
                response.setHeader(headerName, headerValue);
            }
            message.setContent(OutputStream.class, (Object)new WrappedOutputStream(message, response));
        }

        public EndpointReferenceType getTarget() {
            return this.target;
        }

        public Destination getBackChannel() {
            return null;
        }

        public void close() {
        }
    }
}

