/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.cxf.ejb;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.interceptor.InvocationContext;
import javax.xml.ws.handler.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.Bus;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxws.context.WebServiceContextImpl;
import org.apache.cxf.jaxws.support.ContextPropertiesMapping;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.FaultMode;
import org.apache.cxf.service.invoker.AbstractInvoker;
import org.apache.geronimo.cxf.ejb.EJBEndpoint;
import org.apache.geronimo.cxf.ejb.EJBInterceptor;
import org.apache.openejb.DeploymentInfo;
import org.apache.openejb.RpcContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJBMethodInvoker
extends AbstractInvoker {
    private static final Log LOG = LogFactory.getLog(EJBMethodInvoker.class);
    private DeploymentInfo deploymentInfo;
    private Bus bus;
    private EJBEndpoint endpoint;

    public EJBMethodInvoker(EJBEndpoint endpoint, Bus bus, DeploymentInfo deploymentInfo) {
        this.endpoint = endpoint;
        this.bus = bus;
        this.deploymentInfo = deploymentInfo;
    }

    public Object getServiceObject(Exchange context) {
        return null;
    }

    protected Object invoke(Exchange exchange, Object serviceObject, Method m, List<Object> params) {
        Object result = null;
        InvocationContext invContext = (InvocationContext)exchange.get(InvocationContext.class);
        if (invContext == null) {
            LOG.debug((Object)"PreEJBInvoke");
            result = this.preEjbInvoke(exchange, serviceObject, m, params);
        } else {
            LOG.debug((Object)"EJBInvoke");
            result = this.ejbInvoke(exchange, serviceObject, m, params);
        }
        return result;
    }

    private Object preEjbInvoke(Exchange exchange, Object serviceObject, Method method, List<Object> params) {
        MessageContext ctx = ContextPropertiesMapping.createWebServiceContext((Exchange)exchange);
        WebServiceContextImpl.setMessageContext((MessageContext)ctx);
        try {
            EJBInterceptor interceptor = new EJBInterceptor(params, method, this.endpoint, this.bus, exchange);
            Object[] arguments = new Object[]{ctx, interceptor};
            RpcContainer container = (RpcContainer)this.deploymentInfo.getContainer();
            Class callInterface = this.deploymentInfo.getServiceEndpointInterface();
            method = EJBMethodInvoker.getMostSpecificMethod((Method)method, (Class)callInterface);
            Object res = container.invoke(this.deploymentInfo.getDeploymentID(), callInterface, method, arguments, null);
            if (exchange.isOneWay()) {
                Object var11_12 = null;
                return var11_12;
            }
            ArrayList<Object> retList = new ArrayList<Object>(1);
            if (!method.getReturnType().getName().equals("void")) {
                retList.add(res);
            }
            ArrayList<Object> arrayList = retList;
            return arrayList;
        }
        catch (Exception e) {
            exchange.getInMessage().put(FaultMode.class, (Object)FaultMode.UNCHECKED_APPLICATION_FAULT);
            throw new Fault((Throwable)e);
        }
        finally {
            WebServiceContextImpl.clear();
        }
    }

    private Object ejbInvoke(Exchange exchange, Object serviceObject, Method m, List<Object> params) {
        try {
            Object res = this.directEjbInvoke(exchange, m, params);
            if (exchange.isOneWay()) {
                return null;
            }
            ArrayList<Object> retList = new ArrayList<Object>(1);
            if (!m.getReturnType().getName().equals("void")) {
                retList.add(res);
            }
            return retList;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause();
            if (t == null) {
                t = e;
            }
            exchange.getInMessage().put(FaultMode.class, (Object)FaultMode.CHECKED_APPLICATION_FAULT);
            throw new Fault(t);
        }
        catch (Exception e) {
            exchange.getInMessage().put(FaultMode.class, (Object)FaultMode.UNCHECKED_APPLICATION_FAULT);
            throw new Fault((Throwable)e);
        }
    }

    public Object directEjbInvoke(Exchange exchange, Method m, List<Object> params) throws Exception {
        InvocationContext invContext = (InvocationContext)exchange.get(InvocationContext.class);
        Object[] paramArray = params != null ? params.toArray() : new Object[]{};
        invContext.setParameters(paramArray);
        Object res = invContext.proceed();
        ContextPropertiesMapping.updateWebServiceContext((Exchange)exchange, (MessageContext)((MessageContext)invContext.getContextData()));
        return res;
    }
}

