/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.cxf.builder;

import java.net.URI;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.cxf.client.CXFServiceReference;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.jaxws.builder.EndpointInfoBuilder;
import org.apache.geronimo.jaxws.builder.JAXWSBuilderUtils;
import org.apache.geronimo.jaxws.builder.JAXWSServiceRefBuilder;
import org.apache.geronimo.jaxws.info.HandlerChainsInfo;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.naming.deployment.ServiceRefBuilder;
import org.apache.geronimo.naming.reference.JndiReference;
import org.apache.geronimo.xbeans.geronimo.naming.GerServiceRefType;
import org.apache.openejb.jee.PortComponentRef;
import org.apache.openejb.jee.ServiceRef;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CXFServiceRefBuilder
extends JAXWSServiceRefBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(CXFServiceRefBuilder.class);
    public static final GBeanInfo GBEAN_INFO;

    public CXFServiceRefBuilder(Environment defaultEnvironment, String[] eeNamespaces) {
        super(defaultEnvironment, eeNamespaces);
    }

    public Object createService(ServiceRef serviceRef, GerServiceRefType gerServiceRef, Module module, Bundle bundle, Class serviceInterface, QName serviceQName, URI wsdlURI, Class serviceReference, Map<Class<?>, PortComponentRef> portComponentRefMap) throws DeploymentException {
        if (serviceRef.getLookupName() != null && !serviceRef.getLookupName().isEmpty()) {
            return new JndiReference(serviceRef.getLookupName());
        }
        EndpointInfoBuilder builder = new EndpointInfoBuilder(serviceInterface, gerServiceRef, portComponentRefMap, module, bundle, wsdlURI, serviceQName);
        builder.build();
        wsdlURI = builder.getWsdlURI();
        wsdlURI = JAXWSBuilderUtils.normalizeWsdlPath((Module)module, (URI)wsdlURI);
        serviceQName = builder.getServiceQName();
        Map seiInfoMap = builder.getEndpointInfo();
        HandlerChainsInfo handlerChainsInfo = null;
        if (serviceRef.getHandlerChains() != null) {
            handlerChainsInfo = this.handlerChainsInfoBuilder.build(serviceRef.getHandlerChains());
        }
        String serviceReferenceName = serviceReference == null ? null : serviceReference.getName();
        return new CXFServiceReference(serviceInterface.getName(), serviceReferenceName, wsdlURI, serviceQName, module.getModuleName(), handlerChainsInfo, seiInfoMap);
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic(CXFServiceRefBuilder.class, (String)"ModuleBuilder");
        infoBuilder.addInterface(ServiceRefBuilder.class);
        infoBuilder.addAttribute("defaultEnvironment", Environment.class, true, true);
        infoBuilder.addAttribute("eeNamespaces", String[].class, true, true);
        infoBuilder.setConstructor(new String[]{"defaultEnvironment", "eeNamespaces"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

