/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.cxf.builder;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarFile;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.jaxws.javaee.HandlerChainsType;
import org.apache.cxf.jaxws.javaee.PortComponentType;
import org.apache.cxf.jaxws.javaee.ServiceImplBeanType;
import org.apache.cxf.jaxws.javaee.WebserviceDescriptionType;
import org.apache.cxf.jaxws.javaee.WebservicesType;
import org.apache.cxf.jaxws.support.JaxWsImplementorInfo;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.cxf.client.CXFServiceReference;
import org.apache.geronimo.cxf.pojo.POJOWebServiceContainerFactoryGBean;
import org.apache.geronimo.deployment.DeploymentContext;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.WebServiceBuilder;
import org.apache.geronimo.jaxws.JAXWSUtils;
import org.apache.geronimo.jaxws.PortInfo;
import org.apache.geronimo.jaxws.builder.EndpointInfoBuilder;
import org.apache.geronimo.jaxws.builder.JAXWSServiceBuilder;
import org.apache.geronimo.jaxws.builder.WsdlGenerator;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.xbeans.geronimo.naming.GerServiceRefType;
import org.apache.geronimo.xbeans.javaee.PortComponentRefType;
import org.apache.geronimo.xbeans.javaee.ServiceRefHandlerChainsType;
import org.apache.xmlbeans.XmlOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CXFBuilder
extends JAXWSServiceBuilder {
    private static final Log LOG = LogFactory.getLog(CXFBuilder.class);
    private static final String USE_WSGEN_PROPERTY = "org.apache.geronimo.cxf.use.wsgen";
    public static final GBeanInfo GBEAN_INFO;

    public CXFBuilder() {
        this(null);
    }

    public CXFBuilder(Environment defaultEnvironment) {
        super(defaultEnvironment);
    }

    protected GBeanInfo getContainerFactoryGBeanInfo() {
        return POJOWebServiceContainerFactoryGBean.GBEAN_INFO;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Map<String, PortInfo> parseWebServiceDescriptor(InputStream in, URL wsDDUrl, JarFile moduleFile, boolean isEJB, Map correctedPortLocations) throws DeploymentException {
        LOG.debug((Object)("Parsing descriptor " + wsDDUrl));
        HashMap<String, PortInfo> map = null;
        try {
            JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{WebservicesType.class});
            Unmarshaller unmarshaller = ctx.createUnmarshaller();
            Object obj = unmarshaller.unmarshal((Source)new StreamSource(in), WebservicesType.class);
            if (obj instanceof JAXBElement) {
                obj = obj.getValue();
            }
            if (!(obj instanceof WebservicesType)) {
                HashMap<String, PortInfo> hashMap2 = map;
                return hashMap2;
            }
            WebservicesType wst = (WebservicesType)obj;
            for (WebserviceDescriptionType desc : wst.getWebserviceDescription()) {
                String wsdlFile = null;
                if (desc.getWsdlFile() != null) {
                    wsdlFile = CXFBuilder.getString(desc.getWsdlFile().getValue());
                }
                String serviceName = desc.getWebserviceDescriptionName().getValue();
                for (PortComponentType port : desc.getPortComponent()) {
                    PortInfo portInfo = new PortInfo();
                    String serviceLink = null;
                    ServiceImplBeanType beanType = port.getServiceImplBean();
                    if (beanType.getEjbLink() != null) {
                        serviceLink = beanType.getEjbLink().getValue();
                    } else if (beanType.getServletLink().getValue() != null) {
                        serviceLink = beanType.getServletLink().getValue();
                    }
                    portInfo.setServiceLink(serviceLink);
                    if (port.getServiceEndpointInterface() != null) {
                        String sei = port.getServiceEndpointInterface().getValue();
                        portInfo.setServiceEndpointInterfaceName(sei);
                    }
                    String portName = port.getPortComponentName().getValue();
                    portInfo.setPortName(portName);
                    portInfo.setProtocolBinding(port.getProtocolBinding());
                    portInfo.setServiceName(serviceName);
                    portInfo.setWsdlFile(wsdlFile);
                    if (port.getEnableMtom() != null) {
                        portInfo.setEnableMTOM(port.getEnableMtom().isValue());
                    }
                    portInfo.setHandlers(HandlerChainsType.class, (Object)port.getHandlerChains());
                    if (port.getWsdlPort() != null) {
                        portInfo.setWsdlPort(port.getWsdlPort().getValue());
                    }
                    if (port.getWsdlService() != null) {
                        portInfo.setWsdlService(port.getWsdlService().getValue());
                    }
                    String location = (String)correctedPortLocations.get(serviceLink);
                    portInfo.setLocation(location);
                    if (map == null) {
                        map = new HashMap<String, PortInfo>();
                    }
                    map.put(serviceLink, portInfo);
                }
            }
            HashMap<String, PortInfo> hashMap = map;
            return hashMap;
        }
        catch (FileNotFoundException e) {
            Map<String, PortInfo> map2 = Collections.emptyMap();
            return map2;
        }
        catch (IOException ex) {
            throw new DeploymentException("Unable to read " + wsDDUrl, (Throwable)ex);
        }
        catch (JAXBException ex) {
            throw new DeploymentException("Unable to parse " + wsDDUrl, (Throwable)ex);
        }
        catch (Exception ex) {
            throw new DeploymentException("Unknown deployment error", (Throwable)ex);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {}
        }
    }

    public Object createService(Class serviceInterface, Class serviceReference, URI wsdlURI, QName serviceQName, Map<Class, PortComponentRefType> portComponentRefMap, ServiceRefHandlerChainsType handlerChains, GerServiceRefType serviceRefType, Module module, ClassLoader cl) throws DeploymentException {
        EndpointInfoBuilder builder = new EndpointInfoBuilder(serviceInterface, serviceRefType, portComponentRefMap, module.getModuleFile(), wsdlURI, serviceQName);
        builder.build();
        wsdlURI = builder.getWsdlURI();
        serviceQName = builder.getServiceQName();
        Map seiInfoMap = builder.getEndpointInfo();
        String handlerChainsXML = null;
        try {
            handlerChainsXML = CXFBuilder.getHandlerChainAsString(handlerChains);
        }
        catch (IOException e) {
            LOG.warn((Object)"Failed to serialize handler chains", (Throwable)e);
        }
        String serviceReferenceName = serviceReference == null ? null : serviceReference.getName();
        return new CXFServiceReference(serviceInterface.getName(), serviceReferenceName, wsdlURI, serviceQName, module.getModuleName(), handlerChainsXML, seiInfoMap);
    }

    private static String getHandlerChainAsString(ServiceRefHandlerChainsType handlerChains) throws IOException {
        String xml = null;
        if (handlerChains != null) {
            StringWriter w = new StringWriter();
            XmlOptions options = new XmlOptions();
            options.setSaveSyntheticDocumentElement(new QName("http://java.sun.com/xml/ns/javaee", "handler-chains"));
            handlerChains.save((Writer)w, options);
            xml = w.toString();
        }
        return xml;
    }

    private static String getString(String in) {
        if (in != null && (in = in.trim()).length() == 0) {
            return null;
        }
        return in;
    }

    protected void initialize(GBeanData targetGBean, Class serviceClass, PortInfo portInfo, Module module) throws DeploymentException {
        if (Boolean.getBoolean(USE_WSGEN_PROPERTY)) {
            this.generateWSDL(serviceClass, portInfo, module);
        }
    }

    private void generateWSDL(Class serviceClass, PortInfo portInfo, Module module) throws DeploymentException {
        if (this.isWsdlSet(portInfo, serviceClass)) {
            LOG.debug((Object)("Service " + portInfo.getServiceName() + " has WSDL."));
            return;
        }
        LOG.debug((Object)("Service " + portInfo.getServiceName() + " does not have WSDL. Generating WSDL..."));
        WsdlGenerator generator = new WsdlGenerator();
        generator.setSunSAAJ();
        JaxWsImplementorInfo serviceInfo = new JaxWsImplementorInfo(serviceClass);
        if (portInfo.getWsdlService() == null) {
            generator.setWsdlService(serviceInfo.getServiceName());
        } else {
            generator.setWsdlService(portInfo.getWsdlService());
        }
        if (portInfo.getWsdlPort() != null) {
            generator.setWsdlPort(portInfo.getWsdlPort());
        }
        String wsdlFile = generator.generateWsdl(module, serviceClass.getName(), (DeploymentContext)module.getEarContext(), portInfo);
        portInfo.setWsdlFile(wsdlFile);
        LOG.debug((Object)("Generated " + wsdlFile + " for service " + portInfo.getServiceName()));
    }

    private boolean isWsdlSet(PortInfo portInfo, Class serviceClass) {
        return portInfo.getWsdlFile() != null && !portInfo.getWsdlFile().trim().equals("") || JAXWSUtils.containsWsdlLocation((Class)serviceClass, (ClassLoader)serviceClass.getClassLoader());
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic(CXFBuilder.class, (String)"ModuleBuilder");
        infoBuilder.addInterface(WebServiceBuilder.class);
        infoBuilder.addAttribute("defaultEnvironment", Environment.class, true, true);
        infoBuilder.setConstructor(new String[]{"defaultEnvironment"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

