/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector.work.pool;

import edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.LinkedBlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadPoolExecutor;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.connector.work.pool.NullWorkExecutorPool;
import org.apache.geronimo.connector.work.pool.WorkExecutorPool;

public class WorkExecutorPoolImpl
implements WorkExecutorPool {
    private ThreadPoolExecutor pooledExecutor;
    private static Log log = LogFactory.getLog((Class)WorkExecutorPoolImpl.class);

    public WorkExecutorPoolImpl(int maxSize) {
        this.pooledExecutor = new ThreadPoolExecutor(1, maxSize, 1L, TimeUnit.MINUTES, (BlockingQueue)new LinkedBlockingQueue());
    }

    public void execute(Runnable work) {
        if (this.pooledExecutor.getPoolSize() == this.pooledExecutor.getMaximumPoolSize()) {
            log.warn((Object)("Maximum Pool size has been exceeded.  Current Pool Size = " + this.pooledExecutor.getMaximumPoolSize()));
        }
        this.pooledExecutor.execute(work);
    }

    public int getPoolSize() {
        return this.pooledExecutor.getPoolSize();
    }

    public int getMaximumPoolSize() {
        return this.pooledExecutor.getMaximumPoolSize();
    }

    public void setMaximumPoolSize(int maxSize) {
        this.pooledExecutor.setMaximumPoolSize(maxSize);
    }

    public WorkExecutorPool start() {
        throw new IllegalStateException("This pooled executor is already started");
    }

    public WorkExecutorPool stop() {
        int maxSize = this.getMaximumPoolSize();
        this.pooledExecutor.shutdown();
        return new NullWorkExecutorPool(maxSize);
    }
}

