/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector.work;

import edu.emory.mathcs.backport.java.util.concurrent.Executor;
import javax.resource.spi.work.ExecutionContext;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkCompletedException;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import javax.resource.spi.work.WorkManager;
import org.apache.geronimo.connector.work.WorkerContext;
import org.apache.geronimo.connector.work.pool.ScheduleWorkExecutor;
import org.apache.geronimo.connector.work.pool.StartWorkExecutor;
import org.apache.geronimo.connector.work.pool.SyncWorkExecutor;
import org.apache.geronimo.connector.work.pool.WorkExecutor;
import org.apache.geronimo.transaction.manager.XAWork;

public class GeronimoWorkManager
implements WorkManager {
    private Executor syncWorkExecutorPool;
    private Executor startWorkExecutorPool;
    private Executor scheduledWorkExecutorPool;
    private final XAWork transactionManager;
    private final WorkExecutor scheduleWorkExecutor = new ScheduleWorkExecutor();
    private final WorkExecutor startWorkExecutor = new StartWorkExecutor();
    private final WorkExecutor syncWorkExecutor = new SyncWorkExecutor();

    public GeronimoWorkManager() {
        this(null, null, null, null);
    }

    public GeronimoWorkManager(Executor sync, Executor start, Executor sched, XAWork xaWork) {
        this.syncWorkExecutorPool = sync;
        this.startWorkExecutorPool = start;
        this.scheduledWorkExecutorPool = sched;
        this.transactionManager = xaWork;
    }

    public void doStart() throws Exception {
    }

    public void doStop() throws Exception {
    }

    public void doFail() {
        try {
            this.doStop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Executor getSyncWorkExecutorPool() {
        return this.syncWorkExecutorPool;
    }

    public Executor getStartWorkExecutorPool() {
        return this.startWorkExecutorPool;
    }

    public Executor getScheduledWorkExecutorPool() {
        return this.scheduledWorkExecutorPool;
    }

    public void doWork(Work work) throws WorkException {
        this.executeWork(new WorkerContext(work, this.transactionManager), this.syncWorkExecutor, this.syncWorkExecutorPool);
    }

    public void doWork(Work work, long startTimeout, ExecutionContext execContext, WorkListener workListener) throws WorkException {
        WorkerContext workWrapper = new WorkerContext(work, startTimeout, execContext, this.transactionManager, workListener);
        workWrapper.setThreadPriority(Thread.currentThread().getPriority());
        this.executeWork(workWrapper, this.syncWorkExecutor, this.syncWorkExecutorPool);
    }

    public long startWork(Work work) throws WorkException {
        WorkerContext workWrapper = new WorkerContext(work, this.transactionManager);
        workWrapper.setThreadPriority(Thread.currentThread().getPriority());
        this.executeWork(workWrapper, this.startWorkExecutor, this.startWorkExecutorPool);
        return System.currentTimeMillis() - workWrapper.getAcceptedTime();
    }

    public long startWork(Work work, long startTimeout, ExecutionContext execContext, WorkListener workListener) throws WorkException {
        WorkerContext workWrapper = new WorkerContext(work, startTimeout, execContext, this.transactionManager, workListener);
        workWrapper.setThreadPriority(Thread.currentThread().getPriority());
        this.executeWork(workWrapper, this.startWorkExecutor, this.startWorkExecutorPool);
        return System.currentTimeMillis() - workWrapper.getAcceptedTime();
    }

    public void scheduleWork(Work work) throws WorkException {
        WorkerContext workWrapper = new WorkerContext(work, this.transactionManager);
        workWrapper.setThreadPriority(Thread.currentThread().getPriority());
        this.executeWork(workWrapper, this.scheduleWorkExecutor, this.scheduledWorkExecutorPool);
    }

    public void scheduleWork(Work work, long startTimeout, ExecutionContext execContext, WorkListener workListener) throws WorkException {
        WorkerContext workWrapper = new WorkerContext(work, startTimeout, execContext, this.transactionManager, workListener);
        workWrapper.setThreadPriority(Thread.currentThread().getPriority());
        this.executeWork(workWrapper, this.scheduleWorkExecutor, this.scheduledWorkExecutorPool);
    }

    private void executeWork(WorkerContext work, WorkExecutor workExecutor, Executor pooledExecutor) throws WorkException {
        work.workAccepted(this);
        try {
            workExecutor.doExecute(work, pooledExecutor);
            WorkException exception = work.getWorkException();
            if (null != exception) {
                throw exception;
            }
        }
        catch (InterruptedException e) {
            WorkCompletedException wcj = new WorkCompletedException("The execution has been interrupted.", (Throwable)e);
            wcj.setErrorCode("-1");
            throw wcj;
        }
    }
}

