/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector.outbound.connectionmanagerconfig;

import javax.transaction.TransactionManager;
import org.apache.geronimo.connector.outbound.ConnectionInterceptor;
import org.apache.geronimo.connector.outbound.ThreadLocalCachingConnectionInterceptor;
import org.apache.geronimo.connector.outbound.TransactionCachingInterceptor;
import org.apache.geronimo.connector.outbound.TransactionEnlistingInterceptor;
import org.apache.geronimo.connector.outbound.XAResourceInsertionInterceptor;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.TransactionSupport;

public class XATransactions
extends TransactionSupport {
    private boolean useTransactionCaching;
    private boolean useThreadCaching;

    public XATransactions(boolean useTransactionCaching, boolean useThreadCaching) {
        this.useTransactionCaching = useTransactionCaching;
        this.useThreadCaching = useThreadCaching;
    }

    public boolean isUseTransactionCaching() {
        return this.useTransactionCaching;
    }

    public void setUseTransactionCaching(boolean useTransactionCaching) {
        this.useTransactionCaching = useTransactionCaching;
    }

    public boolean isUseThreadCaching() {
        return this.useThreadCaching;
    }

    public void setUseThreadCaching(boolean useThreadCaching) {
        this.useThreadCaching = useThreadCaching;
    }

    public ConnectionInterceptor addXAResourceInsertionInterceptor(ConnectionInterceptor stack, String name) {
        return new XAResourceInsertionInterceptor(stack, name);
    }

    public ConnectionInterceptor addTransactionInterceptors(ConnectionInterceptor stack, TransactionManager transactionManager) {
        if (this.isUseThreadCaching()) {
            stack = new ThreadLocalCachingConnectionInterceptor(stack, false);
        }
        stack = new TransactionEnlistingInterceptor(stack, transactionManager);
        if (this.isUseTransactionCaching()) {
            stack = new TransactionCachingInterceptor(stack, transactionManager);
        }
        return stack;
    }
}

