/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector.outbound;

import edu.emory.mathcs.backport.java.util.concurrent.Semaphore;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.locks.ReadWriteLock;
import edu.emory.mathcs.backport.java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.connector.outbound.ConnectionInfo;
import org.apache.geronimo.connector.outbound.ConnectionInterceptor;
import org.apache.geronimo.connector.outbound.ConnectionReturnAction;
import org.apache.geronimo.connector.outbound.ManagedConnectionInfo;
import org.apache.geronimo.connector.outbound.PoolIdleReleaserTimer;
import org.apache.geronimo.connector.outbound.PoolingAttributes;

public abstract class AbstractSinglePoolConnectionInterceptor
implements ConnectionInterceptor,
PoolingAttributes {
    protected static Log log = LogFactory.getLog((String)AbstractSinglePoolConnectionInterceptor.class.getName());
    protected final ConnectionInterceptor next;
    private final ReadWriteLock resizeLock = new ReentrantReadWriteLock();
    protected Semaphore permits;
    protected int blockingTimeoutMilliseconds;
    protected int connectionCount = 0;
    private long idleTimeoutMilliseconds;
    private IdleReleaser idleReleaser;
    protected Timer timer = PoolIdleReleaserTimer.getTimer();
    protected int maxSize = 0;
    protected int minSize = 0;
    protected int shrinkLater = 0;
    protected volatile boolean destroyed = false;

    public AbstractSinglePoolConnectionInterceptor(ConnectionInterceptor next, int maxSize, int minSize, int blockingTimeoutMilliseconds, int idleTimeoutMinutes) {
        this.next = next;
        this.maxSize = maxSize;
        this.minSize = minSize;
        this.blockingTimeoutMilliseconds = blockingTimeoutMilliseconds;
        this.setIdleTimeoutMinutes(idleTimeoutMinutes);
        this.permits = new Semaphore(maxSize, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getConnection(ConnectionInfo connectionInfo) throws ResourceException {
        block8: {
            if (connectionInfo.getManagedConnectionInfo().getManagedConnection() != null) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("using already assigned connection " + connectionInfo.getConnectionHandle() + " for managed connection " + connectionInfo.getManagedConnectionInfo().getManagedConnection() + " to pool " + this));
                }
                return;
            }
            try {
                this.resizeLock.readLock().lock();
                try {
                    if (this.permits.tryAcquire((long)this.blockingTimeoutMilliseconds, TimeUnit.MILLISECONDS)) {
                        this.internalGetConnection(connectionInfo);
                        break block8;
                    }
                    throw new ResourceException("No ManagedConnections available within configured blocking timeout ( " + this.blockingTimeoutMilliseconds + " [ms] ) for pool " + this);
                }
                finally {
                    this.resizeLock.readLock().unlock();
                }
            }
            catch (InterruptedException ie) {
                throw new ResourceException("Interrupted while requesting permit!");
            }
        }
    }

    protected abstract void internalGetConnection(ConnectionInfo var1) throws ResourceException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnConnection(ConnectionInfo connectionInfo, ConnectionReturnAction connectionReturnAction) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("returning connection " + connectionInfo.getConnectionHandle() + " for MCI " + connectionInfo.getManagedConnectionInfo() + " and MC " + connectionInfo.getManagedConnectionInfo().getManagedConnection() + " to pool " + this));
        }
        if (this.destroyed) {
            try {
                connectionInfo.getManagedConnectionInfo().getManagedConnection().destroy();
            }
            catch (ResourceException re) {
                // empty catch block
            }
            return;
        }
        this.resizeLock.readLock().lock();
        try {
            ManagedConnectionInfo mci = connectionInfo.getManagedConnectionInfo();
            if (connectionReturnAction == ConnectionReturnAction.RETURN_HANDLE && mci.hasConnectionHandles()) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Return request at pool with connection handles! " + connectionInfo.getConnectionHandle() + " for MCI " + connectionInfo.getManagedConnectionInfo() + " and MC " + connectionInfo.getManagedConnectionInfo().getManagedConnection() + " to pool " + this), (Throwable)new Exception("Stack trace"));
                }
                return;
            }
            boolean wasInPool = this.internalReturn(connectionInfo, connectionReturnAction);
            if (!wasInPool) {
                this.permits.release();
            }
        }
        finally {
            this.resizeLock.readLock().unlock();
        }
    }

    protected abstract boolean internalReturn(ConnectionInfo var1, ConnectionReturnAction var2);

    protected abstract void internalDestroy();

    public void destroy() {
        this.destroyed = true;
        if (this.idleReleaser != null) {
            this.idleReleaser.cancel();
        }
        this.internalDestroy();
        this.next.destroy();
    }

    public int getPartitionCount() {
        return 1;
    }

    public abstract int getPartitionMaxSize();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPartitionMaxSize(int newMaxSize) throws InterruptedException {
        if (newMaxSize <= 0) {
            throw new IllegalArgumentException("Max size must be positive, not " + newMaxSize);
        }
        if (newMaxSize != this.getPartitionMaxSize()) {
            this.resizeLock.writeLock().lock();
            try {
                ResizeInfo resizeInfo = new ResizeInfo(this.minSize, this.permits.availablePermits(), this.connectionCount, newMaxSize);
                this.shrinkLater = resizeInfo.getShrinkLater();
                this.permits = new Semaphore(newMaxSize, true);
                for (int i = 0; i < resizeInfo.getTransferCheckedOut(); ++i) {
                    this.permits.acquire();
                }
                this.transferConnections(newMaxSize, resizeInfo.getShrinkNow());
                this.minSize = resizeInfo.getNewMinSize();
            }
            finally {
                this.resizeLock.writeLock().unlock();
            }
        }
    }

    protected abstract void transferConnections(int var1, int var2);

    public abstract int getIdleConnectionCount();

    public int getConnectionCount() {
        return this.connectionCount;
    }

    public int getPartitionMinSize() {
        return this.minSize;
    }

    public void setPartitionMinSize(int minSize) {
        this.minSize = minSize;
    }

    public int getBlockingTimeoutMilliseconds() {
        return this.blockingTimeoutMilliseconds;
    }

    public void setBlockingTimeoutMilliseconds(int blockingTimeoutMilliseconds) {
        if (blockingTimeoutMilliseconds < 0) {
            throw new IllegalArgumentException("blockingTimeoutMilliseconds must be positive or 0, not " + blockingTimeoutMilliseconds);
        }
        this.blockingTimeoutMilliseconds = blockingTimeoutMilliseconds == 0 ? Integer.MAX_VALUE : blockingTimeoutMilliseconds;
    }

    public int getIdleTimeoutMinutes() {
        return (int)this.idleTimeoutMilliseconds / 60000;
    }

    public void setIdleTimeoutMinutes(int idleTimeoutMinutes) {
        if (idleTimeoutMinutes < 0) {
            throw new IllegalArgumentException("idleTimeoutMinutes must be positive or 0, not " + idleTimeoutMinutes);
        }
        if (this.idleReleaser != null) {
            this.idleReleaser.cancel();
        }
        if (idleTimeoutMinutes > 0) {
            this.idleTimeoutMilliseconds = idleTimeoutMinutes * 60 * 1000;
            this.idleReleaser = new IdleReleaser(this);
            this.timer.schedule((TimerTask)this.idleReleaser, this.idleTimeoutMilliseconds, this.idleTimeoutMilliseconds);
        }
    }

    protected abstract void getExpiredManagedConnectionInfos(long var1, ArrayList var3);

    protected abstract boolean addToPool(ManagedConnectionInfo var1);

    protected class FillTask
    extends TimerTask {
        private final ManagedConnectionFactory managedConnectionFactory;
        private final Subject subject;
        private final ConnectionRequestInfo cri;

        public FillTask(ConnectionInfo connectionInfo) {
            this.managedConnectionFactory = connectionInfo.getManagedConnectionInfo().getManagedConnectionFactory();
            this.subject = connectionInfo.getManagedConnectionInfo().getSubject();
            this.cri = connectionInfo.getManagedConnectionInfo().getConnectionRequestInfo();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            AbstractSinglePoolConnectionInterceptor.this.resizeLock.readLock().lock();
            try {
                while (AbstractSinglePoolConnectionInterceptor.this.connectionCount < AbstractSinglePoolConnectionInterceptor.this.minSize) {
                    ManagedConnectionInfo mci = new ManagedConnectionInfo(this.managedConnectionFactory, this.cri);
                    mci.setSubject(this.subject);
                    ConnectionInfo ci = new ConnectionInfo(mci);
                    try {
                        AbstractSinglePoolConnectionInterceptor.this.next.getConnection(ci);
                    }
                    catch (ResourceException e) {
                        AbstractSinglePoolConnectionInterceptor.this.resizeLock.readLock().unlock();
                        return;
                    }
                    boolean added = AbstractSinglePoolConnectionInterceptor.this.addToPool(mci);
                    if (added) continue;
                    AbstractSinglePoolConnectionInterceptor.this.internalReturn(ci, ConnectionReturnAction.DESTROY);
                    return;
                }
            }
            finally {
                AbstractSinglePoolConnectionInterceptor.this.resizeLock.readLock().unlock();
            }
        }
    }

    private static class IdleReleaser
    extends TimerTask {
        private AbstractSinglePoolConnectionInterceptor parent;

        private IdleReleaser(AbstractSinglePoolConnectionInterceptor parent) {
            this.parent = parent;
        }

        public boolean cancel() {
            this.parent = null;
            return super.cancel();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            AbstractSinglePoolConnectionInterceptor interceptor = this.parent;
            if (interceptor == null) {
                return;
            }
            interceptor.resizeLock.readLock().lock();
            try {
                long threshold = System.currentTimeMillis() - interceptor.idleTimeoutMilliseconds;
                ArrayList killList = new ArrayList(interceptor.getPartitionMaxSize());
                interceptor.getExpiredManagedConnectionInfos(threshold, killList);
                Iterator i = killList.iterator();
                while (i.hasNext()) {
                    ManagedConnectionInfo managedConnectionInfo = (ManagedConnectionInfo)i.next();
                    ConnectionInfo killInfo = new ConnectionInfo(managedConnectionInfo);
                    interceptor.internalReturn(killInfo, ConnectionReturnAction.DESTROY);
                }
                interceptor.permits.release(killList.size());
            }
            finally {
                interceptor.resizeLock.readLock().unlock();
            }
        }
    }

    static final class ResizeInfo {
        private final int newMinSize;
        private final int shrinkNow;
        private final int shrinkLater;
        private final int transferCheckedOut;

        ResizeInfo(int oldMinSize, int oldPermitsAvailable, int oldConnectionCount, int newMaxSize) {
            int checkedOut = oldConnectionCount - oldPermitsAvailable;
            int shrinkLater = checkedOut - newMaxSize;
            if (shrinkLater < 0) {
                shrinkLater = 0;
            }
            this.shrinkLater = shrinkLater;
            int shrinkNow = oldConnectionCount - newMaxSize - shrinkLater;
            if (shrinkNow < 0) {
                shrinkNow = 0;
            }
            this.shrinkNow = shrinkNow;
            this.newMinSize = newMaxSize >= oldMinSize ? oldMinSize : newMaxSize;
            this.transferCheckedOut = checkedOut - shrinkLater;
        }

        public int getNewMinSize() {
            return this.newMinSize;
        }

        public int getShrinkNow() {
            return this.shrinkNow;
        }

        public int getShrinkLater() {
            return this.shrinkLater;
        }

        public int getTransferCheckedOut() {
            return this.transferCheckedOut;
        }
    }
}

