/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.apache.geronimo.connector.ConnectionReleaser;
import org.apache.geronimo.connector.outbound.TransactionCachingInterceptor;

public class ConnectorTransactionContext {
    private static final ConcurrentHashMap DATA_INDEX = new ConcurrentHashMap();
    private Map managedConnections;

    public static ConnectorTransactionContext get(Transaction transaction) {
        if (transaction == null) {
            throw new NullPointerException("transaction is null");
        }
        ConnectorTransactionContext ctx = (ConnectorTransactionContext)DATA_INDEX.get((Object)transaction);
        if (ctx == null) {
            ctx = new ConnectorTransactionContext();
            try {
                if (transaction.getStatus() == 0) {
                    transaction.registerSynchronization((Synchronization)new ConnectorSynchronization(ctx, transaction));
                    DATA_INDEX.putIfAbsent((Object)transaction, (Object)ctx);
                }
            }
            catch (RollbackException e) {
                throw (IllegalStateException)new IllegalStateException("Transaction is already rolled back").initCause(e);
            }
            catch (SystemException e) {
                throw new RuntimeException("Unable to register ejb transaction synchronization callback", e);
            }
        }
        return ctx;
    }

    public static TransactionCachingInterceptor.ManagedConnectionInfos get(Transaction transaction, ConnectionReleaser key) {
        ConnectorTransactionContext ctx = ConnectorTransactionContext.get(transaction);
        TransactionCachingInterceptor.ManagedConnectionInfos infos = ctx.getManagedConnectionInfo(key);
        if (infos == null) {
            infos = new TransactionCachingInterceptor.ManagedConnectionInfos();
            ctx.setManagedConnectionInfo(key, infos);
        }
        return infos;
    }

    private static void remove(Transaction transaction) {
        DATA_INDEX.remove((Object)transaction);
    }

    private synchronized TransactionCachingInterceptor.ManagedConnectionInfos getManagedConnectionInfo(ConnectionReleaser key) {
        if (this.managedConnections == null) {
            return null;
        }
        return (TransactionCachingInterceptor.ManagedConnectionInfos)this.managedConnections.get(key);
    }

    private synchronized void setManagedConnectionInfo(ConnectionReleaser key, TransactionCachingInterceptor.ManagedConnectionInfos info) {
        if (this.managedConnections == null) {
            this.managedConnections = new HashMap();
        }
        this.managedConnections.put(key, info);
    }

    private static class ConnectorSynchronization
    implements Synchronization {
        private final ConnectorTransactionContext ctx;
        private final Transaction transaction;

        public ConnectorSynchronization(ConnectorTransactionContext ctx, Transaction transaction) {
            this.ctx = ctx;
            this.transaction = transaction;
        }

        public void beforeCompletion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterCompletion(int status) {
            try {
                ConnectorTransactionContext connectorTransactionContext = this.ctx;
                synchronized (connectorTransactionContext) {
                    if (this.ctx.managedConnections != null) {
                        Iterator entries = this.ctx.managedConnections.entrySet().iterator();
                        while (entries.hasNext()) {
                            Map.Entry entry = entries.next();
                            ConnectionReleaser key = (ConnectionReleaser)entry.getKey();
                            key.afterCompletion(entry.getValue());
                        }
                        this.ctx.managedConnections.clear();
                    }
                }
            }
            finally {
                ConnectorTransactionContext.remove(this.transaction);
            }
        }
    }
}

