/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector.deployment.dconfigbean;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.model.XpathEvent;
import javax.enterprise.deploy.model.XpathListener;
import org.apache.geronimo.connector.deployment.dconfigbean.ConfigPropertySettingDConfigBean;
import org.apache.geronimo.connector.deployment.dconfigbean.ConfigPropertySettings;
import org.apache.geronimo.xbeans.geronimo.GerConfigPropertySettingType;

public class ConfigPropertiesHelper {
    public static void initializeConfigSettings(DDBean ddBean, ConfigPropertiesSource configPropertiesSource, Map configPropertiesMap, String configPropertyXPath, String configPropertyNameXPath) {
        DDBean[] configProperties = ddBean.getChildBean(configPropertyXPath);
        GerConfigPropertySettingType[] configPropertySettings = configPropertiesSource.getConfigPropertySettingArray();
        if (configPropertySettings.length == 0) {
            for (int i = 0; i < configProperties.length; ++i) {
                DDBean configProperty = configProperties[i];
                GerConfigPropertySettingType configPropertySetting = configPropertiesSource.addNewConfigPropertySetting();
                String name = configProperty.getText(configPropertyNameXPath)[0];
                ConfigPropertySettingDConfigBean configPropertySettingDConfigBean = new ConfigPropertySettingDConfigBean(configProperty, configPropertySetting);
                configPropertiesMap.put(name, configPropertySettingDConfigBean);
            }
        } else {
            assert (configProperties.length == configPropertySettings.length);
            for (int i = 0; i < configProperties.length; ++i) {
                DDBean configProperty = configProperties[i];
                GerConfigPropertySettingType configPropertySetting = configPropertySettings[i];
                String name = configProperty.getText(configPropertyNameXPath)[0];
                assert (name.equals(configPropertySetting.getName()));
                ConfigPropertySettingDConfigBean configPropertySettingDConfigBean = new ConfigPropertySettingDConfigBean(configProperty, configPropertySetting);
                configPropertiesMap.put(name, configPropertySettingDConfigBean);
            }
        }
    }

    public static XpathListener initialize(DDBean parentDDBean, final ConfigPropertiesSource configPropertiesSource, String configPropertyXPath, String configPropertyNameXPath) {
        DDBean[] beans = parentDDBean.getChildBean(configPropertyXPath);
        ConfigPropertySettings[] configs = new ConfigPropertySettings[beans.length];
        HashSet<GerConfigPropertySettingType> xmlBeans = new HashSet<GerConfigPropertySettingType>(Arrays.asList(configPropertiesSource.getConfigPropertySettingArray()));
        for (int i = 0; i < beans.length; ++i) {
            DDBean bean = beans[i];
            String[] names = bean.getText(configPropertyNameXPath);
            String name = names.length == 1 ? names[0] : "";
            GerConfigPropertySettingType target = null;
            for (GerConfigPropertySettingType setting : xmlBeans) {
                if (!setting.getName().equals(name)) continue;
                target = setting;
                xmlBeans.remove(target);
                break;
            }
            if (target == null) {
                target = configPropertiesSource.addNewConfigPropertySetting();
            }
            configs[i] = new ConfigPropertySettings();
            configs[i].initialize(target, bean);
        }
        block2: for (GerConfigPropertySettingType target : xmlBeans) {
            GerConfigPropertySettingType[] xmlConfigs = configPropertiesSource.getConfigPropertySettingArray();
            for (int i = 0; i < xmlConfigs.length; ++i) {
                if (xmlConfigs[i] != target) continue;
                configPropertiesSource.removeConfigPropertySetting(i);
                continue block2;
            }
        }
        configPropertiesSource.setConfigPropertySettings(configs);
        XpathListener configListener = new XpathListener(){

            public void fireXpathEvent(XpathEvent xpe) {
                ConfigPropertySettings[] configs = configPropertiesSource.getConfigPropertySettings();
                if (xpe.isAddEvent()) {
                    ConfigPropertySettings[] bigger = new ConfigPropertySettings[configs.length + 1];
                    System.arraycopy(configs, 0, bigger, 0, configs.length);
                    bigger[configs.length] = new ConfigPropertySettings();
                    bigger[configs.length].initialize(configPropertiesSource.addNewConfigPropertySetting(), xpe.getBean());
                    configPropertiesSource.setConfigPropertySettings(bigger);
                } else if (xpe.isRemoveEvent()) {
                    int index = -1;
                    for (int i = 0; i < configs.length; ++i) {
                        if (!configs[i].matches(xpe.getBean())) continue;
                        GerConfigPropertySettingType[] xmlConfigs = configPropertiesSource.getConfigPropertySettingArray();
                        for (int j = 0; j < xmlConfigs.length; ++j) {
                            GerConfigPropertySettingType test = xmlConfigs[j];
                            if (test != configs[i].getConfigPropertySetting()) continue;
                            configPropertiesSource.removeConfigPropertySetting(j);
                            break;
                        }
                        configs[i].dispose();
                        index = i;
                        break;
                    }
                    if (index > -1) {
                        ConfigPropertySettings[] smaller = new ConfigPropertySettings[configs.length - 1];
                        System.arraycopy(configs, 0, smaller, 0, index);
                        System.arraycopy(configs, index + 1, smaller, index, smaller.length - index);
                        configPropertiesSource.setConfigPropertySettings(smaller);
                    }
                }
            }
        };
        parentDDBean.addXpathListener(configPropertyXPath, configListener);
        return configListener;
    }

    public static interface ConfigPropertiesSource {
        public GerConfigPropertySettingType[] getConfigPropertySettingArray();

        public GerConfigPropertySettingType addNewConfigPropertySetting();

        public void removeConfigPropertySetting(int var1);

        public ConfigPropertySettings[] getConfigPropertySettings();

        public void setConfigPropertySettings(ConfigPropertySettings[] var1);
    }
}

