/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector.deployment.jsr88;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.model.XpathEvent;
import javax.enterprise.deploy.model.XpathListener;
import javax.enterprise.deploy.spi.DConfigBean;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import org.apache.geronimo.connector.deployment.jsr88.AdminObjectDCB;
import org.apache.geronimo.connector.deployment.jsr88.Connector15DCBRoot;
import org.apache.geronimo.connector.deployment.jsr88.ResourceAdapter;
import org.apache.geronimo.deployment.plugin.DConfigBeanSupport;
import org.apache.geronimo.deployment.service.jsr88.EnvironmentData;
import org.apache.geronimo.xbeans.geronimo.GerAdminobjectInstanceType;
import org.apache.geronimo.xbeans.geronimo.GerAdminobjectType;
import org.apache.geronimo.xbeans.geronimo.GerConnectorType;
import org.apache.geronimo.xbeans.geronimo.GerResourceadapterType;
import org.apache.xmlbeans.SchemaTypeLoader;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;

public class ConnectorDCB
extends DConfigBeanSupport {
    private DDBean resourceAdapterDDBean;
    private ResourceAdapter[] resourceAdapter = new ResourceAdapter[0];
    private AdminObjectDCB[] adminobjects = new AdminObjectDCB[0];
    private EnvironmentData environment;

    public ConnectorDCB(DDBean connectorDDBean, GerConnectorType connector) {
        super(connectorDDBean, (XmlObject)connector);
        DDBean[] list = connectorDDBean.getChildBean("resourceadapter");
        if (list.length > 0) {
            this.resourceAdapterDDBean = list[0];
        }
        this.loadExistingData(connector);
        connectorDDBean.addXpathListener("resourceadapter", new XpathListener(){

            public void fireXpathEvent(XpathEvent event) {
                if (event.isRemoveEvent()) {
                    ConnectorDCB.this.resourceAdapterDDBean = null;
                } else if (event.isAddEvent()) {
                    ConnectorDCB.this.resourceAdapterDDBean = event.getBean();
                } else {
                    System.out.println("Detected change to J2EE DD /connector/resourceadapter property " + event.getChangeEvent().getPropertyName());
                }
            }
        });
    }

    public String[] getXpaths() {
        return this.getXPathsForJ2ee_1_4(new String[][]{{"resourceadapter", "adminobject"}});
    }

    public DConfigBean getDConfigBean(DDBean bean) throws ConfigurationException {
        if (this.getXpaths()[0].equals(bean.getXpath())) {
            String aoInterface = bean.getText("adminobject-interface")[0];
            String aoClass = bean.getText("adminobject-class")[0];
            for (int i = 0; i < this.adminobjects.length; ++i) {
                if (!this.adminobjects[i].getAdminObjectClass().equals(aoClass) || !this.adminobjects[i].getAdminObjectInterface().equals(aoInterface)) continue;
                return this.adminobjects[i];
            }
            GerAdminobjectType ao = this.getConnector().addNewAdminobject();
            AdminObjectDCB dcb = new AdminObjectDCB(bean, ao);
            AdminObjectDCB[] list = new AdminObjectDCB[this.adminobjects.length + 1];
            System.arraycopy(this.adminobjects, 0, list, 0, this.adminobjects.length);
            list[this.adminobjects.length] = dcb;
            return dcb;
        }
        throw new ConfigurationException("No DConfigBean matching DDBean " + bean.getXpath());
    }

    private void loadExistingData(GerConnectorType connector) {
        int i;
        GerResourceadapterType[] adapters = connector.getResourceadapterArray();
        if (adapters == null || adapters.length == 0) {
            if (this.resourceAdapterDDBean != null) {
                this.resourceAdapter = new ResourceAdapter[1];
                this.resourceAdapter[0] = new ResourceAdapter(this.resourceAdapterDDBean, connector.addNewResourceadapter());
            }
        } else {
            this.resourceAdapter = new ResourceAdapter[adapters.length];
            for (int i2 = 0; i2 < adapters.length; ++i2) {
                GerResourceadapterType adapter = adapters[i2];
                this.resourceAdapter[i2] = new ResourceAdapter(this.resourceAdapterDDBean, adapter);
            }
        }
        GerAdminobjectType[] admins = connector.getAdminobjectArray();
        DDBean[] data = this.getDDBean().getChildBean(this.getXpaths()[0]);
        List<Object> ddBeans = data == null ? Collections.EMPTY_LIST : new ArrayList<DDBean>(Arrays.asList(data));
        LinkedHashMap<String, AdminObjectDCB> dcbs = new LinkedHashMap<String, AdminObjectDCB>();
        if (admins == null) {
            this.adminobjects = new AdminObjectDCB[0];
        } else {
            for (i = 0; i < admins.length; ++i) {
                GerAdminobjectType admin = admins[i];
                String aoClass = admin.getAdminobjectClass();
                String aoIface = admin.getAdminobjectInterface();
                AdminObjectDCB dcb = (AdminObjectDCB)((Object)dcbs.get("class " + aoClass + " iface " + aoIface));
                if (dcb != null) {
                    if (admin.getAdminobjectInstanceArray().length <= 0) continue;
                    GerAdminobjectType old = dcb.getAdminObject();
                    GerAdminobjectInstanceType[] array = admin.getAdminobjectInstanceArray();
                    int oldCount = dcb.getAdminObjectInstance().length;
                    for (int j = 0; j < array.length; ++j) {
                        GerAdminobjectInstanceType instance = array[j];
                        XmlCursor source = instance.newCursor();
                        XmlCursor dest = old.newCursor();
                        dest.toEndToken();
                        if (!source.moveXml(dest)) {
                            throw new RuntimeException("Unable to move admin object instance");
                        }
                        source.dispose();
                        dest.dispose();
                        dcb.addAdminObjectInstance(old.getAdminobjectInstanceArray(oldCount + j));
                    }
                    continue;
                }
                DDBean target = null;
                for (int j = 0; j < ddBeans.size(); ++j) {
                    DDBean ddBean = (DDBean)ddBeans.get(j);
                    String ddClass = ddBean.getText("adminobject-class")[0];
                    String ddIface = ddBean.getText("adminobject-interface")[0];
                    if (!ddClass.equals(aoClass) || !ddIface.equals(aoIface)) continue;
                    target = ddBean;
                    ddBeans.remove(j);
                    break;
                }
                if (target == null) {
                    System.out.println("Geronimo connector deployment plan has admin object with interface '" + aoIface + "' and class '" + aoClass + "' but the ra.xml does not have a matching adminobject declared.  Deleting this adminobject from the Geronimo plan.");
                    continue;
                }
                dcb = new AdminObjectDCB(target, admin);
                dcbs.put("class " + aoClass + " iface " + aoIface, dcb);
            }
        }
        for (i = 0; i < ddBeans.size(); ++i) {
            DDBean ddBean = (DDBean)ddBeans.get(i);
            String ddClass = ddBean.getText("adminobject-class")[0];
            String ddIface = ddBean.getText("adminobject-interface")[0];
            GerAdminobjectType admin = connector.addNewAdminobject();
            dcbs.put("class " + ddClass + " iface " + ddIface, new AdminObjectDCB(ddBean, admin));
        }
        ArrayList<DConfigBean> adminResults = new ArrayList<DConfigBean>();
        for (String key : dcbs.keySet()) {
            DConfigBean value = (DConfigBean)dcbs.get(key);
            adminResults.add(value);
        }
        this.adminobjects = adminResults.toArray(new AdminObjectDCB[adminResults.size()]);
    }

    GerConnectorType getConnector() {
        return (GerConnectorType)this.getXmlObject();
    }

    public EnvironmentData getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(EnvironmentData environment) {
        EnvironmentData old = this.environment;
        this.environment = environment;
        if (old == null && environment == null || old != null && old == environment) {
            return;
        }
        if (old != null) {
            this.getConnector().unsetEnvironment();
        }
        if (environment != null) {
            environment.configure(this.getConnector().addNewEnvironment());
        }
        this.pcs.firePropertyChange("environment", old, environment);
    }

    public ResourceAdapter[] getResourceAdapter() {
        return this.resourceAdapter;
    }

    public void setResourceAdapter(ResourceAdapter[] resourceAdapter) {
        int i;
        ResourceAdapter[] old = this.resourceAdapter;
        HashSet<ResourceAdapter> before = new HashSet<ResourceAdapter>();
        for (i = 0; i < old.length; ++i) {
            before.add(old[i]);
        }
        this.resourceAdapter = resourceAdapter;
        for (i = 0; i < resourceAdapter.length; ++i) {
            ResourceAdapter adapter = resourceAdapter[i];
            if (adapter.getResourceAdapter() == null) {
                adapter.configure(this.resourceAdapterDDBean, this.getConnector().addNewResourceadapter());
                continue;
            }
            before.remove((Object)adapter);
        }
        block2: for (ResourceAdapter adapter : before) {
            GerResourceadapterType[] all = this.getConnector().getResourceadapterArray();
            for (int i2 = 0; i2 < all.length; ++i2) {
                if (all[i2] != adapter) continue;
                this.getConnector().removeResourceadapter(i2);
                continue block2;
            }
        }
        this.pcs.firePropertyChange("resourceAdapter", old, resourceAdapter);
    }

    public ResourceAdapter getResourceAdapter(int index) {
        return this.resourceAdapter[index];
    }

    public void setResourceAdapter(int index, ResourceAdapter ra) {
        ResourceAdapter[] old = this.resourceAdapter;
        this.resourceAdapter[index] = ra;
        if (ra.getResourceAdapter() == null) {
            ra.configure(this.resourceAdapterDDBean, this.getConnector().addNewResourceadapter());
        }
        this.pcs.firePropertyChange("resourceAdapter", old, this.resourceAdapter);
    }

    protected SchemaTypeLoader getSchemaTypeLoader() {
        return Connector15DCBRoot.SCHEMA_TYPE_LOADER;
    }
}

