/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector.deployment;

import [Ljava.lang.String;;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.common.UnresolvedReferenceException;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.naming.deployment.AbstractNamingBuilder;
import org.apache.geronimo.naming.deployment.ResourceEnvironmentBuilder;
import org.apache.geronimo.naming.deployment.ResourceEnvironmentSetter;
import org.apache.geronimo.naming.reference.ResourceReference;
import org.apache.geronimo.schema.NamespaceElementConverter;
import org.apache.geronimo.xbeans.geronimo.naming.GerPatternType;
import org.apache.geronimo.xbeans.geronimo.naming.GerResourceRefDocument;
import org.apache.geronimo.xbeans.geronimo.naming.GerResourceRefType;
import org.apache.geronimo.xbeans.j2ee.ResourceRefType;
import org.apache.xmlbeans.QNameSet;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlObject;

public class ResourceRefBuilder
extends AbstractNamingBuilder
implements ResourceEnvironmentSetter {
    private static final QName GER_RESOURCE_REF_QNAME = GerResourceRefDocument.type.getDocumentElementName();
    private static final QNameSet GER_RESOURCE_REF_QNAME_SET = QNameSet.singleton((QName)GER_RESOURCE_REF_QNAME);
    private final QNameSet resourceRefQNameSet;
    private static final String JAXR_CONNECTION_FACTORY_CLASS = "javax.xml.registry.ConnectionFactory";
    private static final String JAVAX_MAIL_SESSION_CLASS = "javax.mail.Session";
    public static final GBeanInfo GBEAN_INFO;
    static /* synthetic */ Class class$java$net$URL;

    public ResourceRefBuilder(Environment defaultEnvironment, String[] eeNamespaces) {
        super(defaultEnvironment);
        this.resourceRefQNameSet = ResourceRefBuilder.buildQNameSet((String[])eeNamespaces, (String)"resource-ref");
    }

    protected boolean willMergeEnvironment(XmlObject specDD, XmlObject plan) {
        return specDD.selectChildren(this.resourceRefQNameSet).length > 0;
    }

    public void buildNaming(XmlObject specDD, XmlObject plan, Configuration localConfiguration, Configuration remoteConfiguration, Module module, Map componentContext) throws DeploymentException {
        XmlObject[] resourceRefsUntyped = ResourceRefBuilder.convert((XmlObject[])specDD.selectChildren(this.resourceRefQNameSet), (NamespaceElementConverter)J2EE_CONVERTER, (SchemaType)ResourceRefType.type);
        XmlObject[] gerResourceRefsUntyped = plan == null ? NO_REFS : plan.selectChildren(GER_RESOURCE_REF_QNAME_SET);
        Map refMap = this.mapResourceRefs(gerResourceRefsUntyped);
        ClassLoader cl = module.getEarContext().getClassLoader();
        for (int i = 0; i < resourceRefsUntyped.length; ++i) {
            Class<?> iface;
            ResourceRefType resourceRef = (ResourceRefType)resourceRefsUntyped[i];
            String name = resourceRef.getResRefName().getStringValue().trim();
            String type = resourceRef.getResType().getStringValue().trim();
            GerResourceRefType gerResourceRef = (GerResourceRefType)refMap.get(name);
            try {
                iface = cl.loadClass(type);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("could not load class " + type, (Throwable)e);
            }
            if (iface == (class$java$net$URL == null ? ResourceRefBuilder.class$("java.net.URL") : class$java$net$URL)) {
                if (gerResourceRef == null || !gerResourceRef.isSetUrl()) {
                    throw new DeploymentException("No url supplied to resolve: " + name);
                }
                try {
                    this.getJndiContextMap(componentContext).put("env/" + name, new URL(gerResourceRef.getUrl()));
                    continue;
                }
                catch (MalformedURLException e) {
                    throw new DeploymentException("Could not convert " + gerResourceRef.getUrl() + " to URL", (Throwable)e);
                }
            }
            String j2eeType = JAVAX_MAIL_SESSION_CLASS.equals(type) ? "JavaMailResource" : (JAXR_CONNECTION_FACTORY_CLASS.equals(type) ? "JAXRConnectionFactory" : "JCAManagedConnectionFactory");
            try {
                AbstractNameQuery containerId = this.getResourceContainerId(name, j2eeType, null, gerResourceRef);
                try {
                    localConfiguration.findGBean(containerId);
                }
                catch (GBeanNotFoundException e) {
                    throw new UnresolvedReferenceException("Resource", false, containerId.toString(), localConfiguration.getId().toString());
                }
                ResourceReference ref = new ResourceReference(localConfiguration.getId(), containerId, iface);
                this.getJndiContextMap(componentContext).put("env/" + name, ref);
                continue;
            }
            catch (UnresolvedReferenceException e) {
                StringBuffer errorMessage = new StringBuffer("Unable to resolve resource reference '");
                errorMessage.append(name);
                errorMessage.append("' (");
                if (e.isMultiple()) {
                    errorMessage.append("Found multiple matching resources.  Try being more specific in a resource-ref mapping in your Geronimo deployment plan.");
                } else if (gerResourceRef == null) {
                    errorMessage.append("Could not auto-map to resource.  Try adding a resource-ref mapping to your Geronimo deployment plan.");
                } else if (gerResourceRef.isSetResourceLink()) {
                    errorMessage.append("Could not find resource '");
                    errorMessage.append(gerResourceRef.getResourceLink());
                    errorMessage.append("'.  Perhaps it has not yet been configured, or your application does not have a dependency declared for that resource module?");
                } else {
                    errorMessage.append("Could not find the resource specified in your Geronimo deployment plan:");
                    errorMessage.append(gerResourceRef.getPattern());
                }
                errorMessage.append(")");
                throw new DeploymentException(errorMessage.toString());
            }
        }
    }

    public void setResourceEnvironment(ResourceEnvironmentBuilder builder, XmlObject[] resourceRefs, GerResourceRefType[] gerResourceRefs) throws DeploymentException {
        resourceRefs = ResourceRefBuilder.convert((XmlObject[])resourceRefs, (NamespaceElementConverter)J2EE_CONVERTER, (SchemaType)ResourceRefType.type);
        Map refMap = this.mapResourceRefs((XmlObject[])gerResourceRefs);
        HashSet<AbstractNameQuery> unshareableResources = new HashSet<AbstractNameQuery>();
        HashSet<AbstractNameQuery> applicationManagedSecurityResources = new HashSet<AbstractNameQuery>();
        for (int i = 0; i < resourceRefs.length; ++i) {
            ResourceRefType resourceRefType = (ResourceRefType)resourceRefs[i];
            String type = resourceRefType.getResType().getStringValue().trim();
            if ((class$java$net$URL == null ? ResourceRefBuilder.class$("java.net.URL") : class$java$net$URL).getName().equals(type) || JAVAX_MAIL_SESSION_CLASS.equals(type) || JAXR_CONNECTION_FACTORY_CLASS.equals(type)) continue;
            GerResourceRefType gerResourceRef = (GerResourceRefType)refMap.get(resourceRefType.getResRefName().getStringValue());
            AbstractNameQuery containerId = this.getResourceContainerId(ResourceRefBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)resourceRefType.getResRefName()), "JCAManagedConnectionFactory", null, gerResourceRef);
            if ("Unshareable".equals(ResourceRefBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)resourceRefType.getResSharingScope()))) {
                unshareableResources.add(containerId);
            }
            if (!"Application".equals(ResourceRefBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)resourceRefType.getResAuth()))) continue;
            applicationManagedSecurityResources.add(containerId);
        }
        builder.setUnshareableResources(unshareableResources);
        builder.setApplicationManagedSecurityResources(applicationManagedSecurityResources);
    }

    private Map mapResourceRefs(XmlObject[] refs) {
        HashMap<String, GerResourceRefType> refMap = new HashMap<String, GerResourceRefType>();
        if (refs != null) {
            for (int i = 0; i < refs.length; ++i) {
                GerResourceRefType ref = (GerResourceRefType)refs[i].copy().changeType(GerResourceRefType.type);
                refMap.put(ref.getRefName().trim(), ref);
            }
        }
        return refMap;
    }

    private AbstractNameQuery getResourceContainerId(String name, String type, URI moduleURI, GerResourceRefType gerResourceRef) {
        AbstractNameQuery containerId;
        String module;
        String string = module = moduleURI == null ? null : moduleURI.toString();
        if (gerResourceRef == null) {
            containerId = ResourceRefBuilder.buildAbstractNameQuery(null, (String)module, (String)name, (String)type, (String)"ResourceAdapterModule");
        } else if (gerResourceRef.isSetResourceLink()) {
            containerId = ResourceRefBuilder.buildAbstractNameQuery(null, (String)module, (String)gerResourceRef.getResourceLink().trim(), (String)type, (String)"ResourceAdapterModule");
        } else {
            GerPatternType patternType = gerResourceRef.getPattern();
            containerId = ResourceRefBuilder.buildAbstractNameQuery((GerPatternType)patternType, (String)type, (String)"ResourceAdapterModule", null);
        }
        return containerId;
    }

    public QNameSet getSpecQNameSet() {
        return this.resourceRefQNameSet;
    }

    public QNameSet getPlanQNameSet() {
        return GER_RESOURCE_REF_QNAME_SET;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic((Class)ResourceRefBuilder.class, (String)"ModuleBuilder");
        infoBuilder.addAttribute("eeNamespaces", String;.class, true, true);
        infoBuilder.addAttribute("defaultEnvironment", Environment.class, true, true);
        infoBuilder.setConstructor(new String[]{"defaultEnvironment", "eeNamespaces"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

