/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector.deployment;

import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.DeploymentConfiguration;
import org.apache.geronimo.connector.deployment.RARConfiguration;
import org.apache.geronimo.connector.deployment.dconfigbean.ResourceAdapter_1_0DConfigRoot;
import org.apache.geronimo.connector.deployment.jsr88.Connector15DCBRoot;
import org.apache.geronimo.deployment.ModuleConfigurer;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;

public class RARConfigurer
implements ModuleConfigurer {
    public static final GBeanInfo GBEAN_INFO;

    public DeploymentConfiguration createConfiguration(DeployableObject deployable) {
        if (ModuleType.RAR.equals(deployable.getType())) {
            String ddBeanRootVersion = deployable.getDDBeanRoot().getDDBeanRootVersion();
            if (ddBeanRootVersion != null && ddBeanRootVersion.equals("1.5")) {
                return new RARConfiguration(deployable, new Connector15DCBRoot(deployable.getDDBeanRoot()));
            }
            String[] specVersion = deployable.getDDBeanRoot().getText("connector/spec-version");
            if (specVersion.length > 0 && "1.0".equals(specVersion[0])) {
                return new RARConfiguration(deployable, new ResourceAdapter_1_0DConfigRoot(deployable.getDDBeanRoot()));
            }
            throw new IllegalArgumentException("Unknown resource adapter version: " + deployable.getDDBeanRoot().getDDBeanRootVersion());
        }
        return null;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic((Class)RARConfigurer.class, (String)"DeploymentConfigurer");
        infoFactory.addInterface(ModuleConfigurer.class);
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

