/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector.deployment;

import java.beans.Introspector;
import java.beans.PropertyEditor;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.naming.Reference;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.common.UnresolvedReferenceException;
import org.apache.geronimo.common.propertyeditor.PropertyEditors;
import org.apache.geronimo.connector.ActivationSpecWrapperGBean;
import org.apache.geronimo.connector.AdminObjectWrapperGBean;
import org.apache.geronimo.connector.JCAResourceImplGBean;
import org.apache.geronimo.connector.ResourceAdapterImplGBean;
import org.apache.geronimo.connector.ResourceAdapterModuleImplGBean;
import org.apache.geronimo.connector.ResourceAdapterWrapperGBean;
import org.apache.geronimo.connector.deployment.ConnectorPlanRectifier;
import org.apache.geronimo.connector.outbound.JCAConnectionFactoryImplGBean;
import org.apache.geronimo.connector.outbound.ManagedConnectionFactoryWrapperGBean;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.LocalTransactions;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.NoPool;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.NoTransactions;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.PartitionedPool;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.SinglePool;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.TransactionLog;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.TransactionSupport;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.XATransactions;
import org.apache.geronimo.deployment.DeploymentContext;
import org.apache.geronimo.deployment.ModuleIDBuilder;
import org.apache.geronimo.deployment.NamespaceDrivenBuilder;
import org.apache.geronimo.deployment.NamespaceDrivenBuilderCollection;
import org.apache.geronimo.deployment.service.EnvironmentBuilder;
import org.apache.geronimo.deployment.service.GBeanBuilder;
import org.apache.geronimo.deployment.util.DeploymentUtil;
import org.apache.geronimo.deployment.xbeans.EnvironmentType;
import org.apache.geronimo.deployment.xmlbeans.XmlBeansUtil;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.DynamicGAttributeInfo;
import org.apache.geronimo.gbean.GAttributeInfo;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.InvalidConfigurationException;
import org.apache.geronimo.j2ee.deployment.ActivationSpecInfoLocator;
import org.apache.geronimo.j2ee.deployment.ConnectorModule;
import org.apache.geronimo.j2ee.deployment.EARContext;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.ModuleBuilder;
import org.apache.geronimo.kernel.GBeanAlreadyExistsException;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Naming;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.config.ConfigurationStore;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.management.JCAConnectionFactory;
import org.apache.geronimo.management.geronimo.JCAAdminObject;
import org.apache.geronimo.management.geronimo.JCAResourceAdapter;
import org.apache.geronimo.management.geronimo.ResourceAdapterModule;
import org.apache.geronimo.naming.deployment.ENCConfigBuilder;
import org.apache.geronimo.naming.reference.ResourceReference;
import org.apache.geronimo.schema.SchemaConversionUtils;
import org.apache.geronimo.xbeans.geronimo.GerAdminobjectInstanceType;
import org.apache.geronimo.xbeans.geronimo.GerAdminobjectType;
import org.apache.geronimo.xbeans.geronimo.GerConfigPropertySettingType;
import org.apache.geronimo.xbeans.geronimo.GerConnectionDefinitionType;
import org.apache.geronimo.xbeans.geronimo.GerConnectiondefinitionInstanceType;
import org.apache.geronimo.xbeans.geronimo.GerConnectionmanagerType;
import org.apache.geronimo.xbeans.geronimo.GerConnectorDocument;
import org.apache.geronimo.xbeans.geronimo.GerConnectorType;
import org.apache.geronimo.xbeans.geronimo.GerResourceadapterType;
import org.apache.geronimo.xbeans.geronimo.GerSinglepoolType;
import org.apache.geronimo.xbeans.geronimo.naming.GerGbeanLocatorType;
import org.apache.geronimo.xbeans.j2ee.ActivationspecType;
import org.apache.geronimo.xbeans.j2ee.AdminobjectType;
import org.apache.geronimo.xbeans.j2ee.ConfigPropertyType;
import org.apache.geronimo.xbeans.j2ee.ConnectionDefinitionType;
import org.apache.geronimo.xbeans.j2ee.ConnectorDocument;
import org.apache.geronimo.xbeans.j2ee.ConnectorType;
import org.apache.geronimo.xbeans.j2ee.MessagelistenerType;
import org.apache.geronimo.xbeans.j2ee.ResourceadapterType;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlDocumentProperties;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;

public class ConnectorModuleBuilder
implements ModuleBuilder,
ActivationSpecInfoLocator {
    private static final Log log;
    private static QName CONNECTOR_QNAME;
    static final String GERCONNECTOR_NAMESPACE;
    private final int defaultMaxSize;
    private final int defaultMinSize;
    private final int defaultBlockingTimeoutMilliseconds;
    private final int defaultIdleTimeoutMinutes;
    private final boolean defaultXATransactionCaching;
    private final boolean defaultXAThreadCaching;
    private final Environment defaultEnvironment;
    private final NamespaceDrivenBuilderCollection serviceBuilders;
    private static final QName RESOURCE_ADAPTER_VERSION;
    public static final GBeanInfo GBEAN_INFO;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$apache$geronimo$connector$ActivationSpecWrapperGBean;
    static /* synthetic */ Class class$org$apache$geronimo$connector$outbound$ManagedConnectionFactoryWrapper;
    static /* synthetic */ Class class$org$apache$geronimo$connector$AdminObjectWrapper;

    public ConnectorModuleBuilder(Environment defaultEnvironment, int defaultMaxSize, int defaultMinSize, int defaultBlockingTimeoutMilliseconds, int defaultIdleTimeoutMinutes, boolean defaultXATransactionCaching, boolean defaultXAThreadCaching, Collection serviceBuilders) {
        this.defaultEnvironment = defaultEnvironment;
        this.defaultMaxSize = defaultMaxSize;
        this.defaultMinSize = defaultMinSize;
        this.defaultBlockingTimeoutMilliseconds = defaultBlockingTimeoutMilliseconds;
        this.defaultIdleTimeoutMinutes = defaultIdleTimeoutMinutes;
        this.defaultXATransactionCaching = defaultXATransactionCaching;
        this.defaultXAThreadCaching = defaultXAThreadCaching;
        this.serviceBuilders = new NamespaceDrivenBuilderCollection(serviceBuilders, GBeanBuilder.SERVICE_QNAME);
    }

    public Module createModule(File plan, JarFile moduleFile, Naming naming, ModuleIDBuilder idBuilder) throws DeploymentException {
        return this.createModule(plan, moduleFile, "rar", null, null, null, naming, idBuilder);
    }

    public Module createModule(Object plan, JarFile moduleFile, String targetPath, URL specDDUrl, Environment environment, Object moduleContextInfo, AbstractName earName, Naming naming, ModuleIDBuilder idBuilder) throws DeploymentException {
        return this.createModule(plan, moduleFile, targetPath, specDDUrl, environment, earName, naming, idBuilder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Module createModule(Object plan, JarFile moduleFile, String targetPath, URL specDDUrl, Environment earEnvironment, AbstractName earName, Naming naming, ModuleIDBuilder idBuilder) throws DeploymentException {
        AbstractName moduleName;
        ConnectorType connector;
        String specDD;
        if (!$assertionsDisabled && moduleFile == null) {
            throw new AssertionError((Object)"moduleFile is null");
        }
        if (!$assertionsDisabled && targetPath == null) {
            throw new AssertionError((Object)"targetPath is null");
        }
        if (!$assertionsDisabled && targetPath.endsWith("/")) {
            throw new AssertionError((Object)"targetPath must not end with a '/'");
        }
        try {
            if (specDDUrl == null) {
                specDDUrl = DeploymentUtil.createJarURL((JarFile)moduleFile, (String)"META-INF/ra.xml");
            }
            specDD = DeploymentUtil.readAll((URL)specDDUrl);
        }
        catch (Exception e) {
            return null;
        }
        try {
            XmlObject xmlObject = XmlBeansUtil.parse((String)specDD);
            ConnectorDocument connectorDoc = ConnectorModuleBuilder.convertToConnectorSchema(xmlObject);
            connector = connectorDoc.getConnector();
        }
        catch (XmlException e) {
            throw new DeploymentException("Could not parse ra.xml descriptor", (Throwable)e);
        }
        GerConnectorType gerConnector = null;
        try {
            try {
                if (plan instanceof XmlObject) {
                    gerConnector = (GerConnectorType)SchemaConversionUtils.getNestedObjectAsType((XmlObject)((XmlObject)plan), (QName)CONNECTOR_QNAME, (SchemaType)GerConnectorType.type);
                } else {
                    GerConnectorDocument gerConnectorDoc;
                    ArrayList errors = new ArrayList();
                    if (plan != null) {
                        gerConnectorDoc = GerConnectorDocument.Factory.parse((File)plan, XmlBeansUtil.createXmlOptions(errors));
                    } else {
                        URL path = DeploymentUtil.createJarURL((JarFile)moduleFile, (String)"META-INF/geronimo-ra.xml");
                        gerConnectorDoc = GerConnectorDocument.Factory.parse(path, XmlBeansUtil.createXmlOptions(errors));
                    }
                    if (errors.size() > 0) {
                        throw new DeploymentException("Could not parse connector doc: " + errors);
                    }
                    if (gerConnectorDoc != null) {
                        gerConnector = gerConnectorDoc.getConnector();
                    }
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            if (gerConnector == null) {
                throw new DeploymentException("A connector module must be deployed using a Geronimo deployment plan (either META-INF/geronimo-ra.xml in the RAR file or a standalone deployment plan passed to the deployer).");
            }
            ConnectorPlanRectifier.rectifyPlan(gerConnector);
            XmlCursor cursor = gerConnector.newCursor();
            try {
                SchemaConversionUtils.convertToGeronimoSubSchemas((XmlCursor)cursor);
            }
            finally {
                cursor.dispose();
            }
            XmlBeansUtil.validateDD((XmlObject)gerConnector);
        }
        catch (XmlException e) {
            throw new DeploymentException((Throwable)e);
        }
        EnvironmentType environmentType = gerConnector.getEnvironment();
        Environment environment = EnvironmentBuilder.buildEnvironment((EnvironmentType)environmentType, (Environment)this.defaultEnvironment);
        if (earEnvironment != null) {
            EnvironmentBuilder.mergeEnvironments((Environment)earEnvironment, (Environment)environment);
            environment = earEnvironment;
            if (!environment.getConfigId().isResolved()) {
                throw new IllegalStateException("Connector module ID should be fully resolved (not " + environment.getConfigId() + ")");
            }
        } else {
            idBuilder.resolve(environment, new File(moduleFile.getName()).getName(), "rar");
        }
        if (earName == null) {
            earName = naming.createRootName(environment.getConfigId(), "null", "J2EEApplication");
            moduleName = naming.createChildName(earName, environment.getConfigId().toString(), "ResourceAdapterModule");
        } else {
            moduleName = naming.createChildName(earName, targetPath, "ResourceAdapterModule");
        }
        boolean standAlone = earEnvironment == null;
        return new ConnectorModule(standAlone, moduleName, environment, moduleFile, targetPath, (XmlObject)connector, (XmlObject)gerConnector, specDD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ConnectorDocument convertToConnectorSchema(XmlObject xmlObject) throws XmlException {
        block10: {
            if (ConnectorDocument.type.equals(xmlObject.schemaType())) {
                XmlBeansUtil.validateDD((XmlObject)xmlObject);
                return (ConnectorDocument)xmlObject;
            }
            XmlCursor cursor = xmlObject.newCursor();
            XmlDocumentProperties xmlDocumentProperties = cursor.documentProperties();
            String publicId = xmlDocumentProperties.getDoctypePublicId();
            try {
                if (!"-//Sun Microsystems, Inc.//DTD Connector 1.0//EN".equals(publicId)) break block10;
                XmlCursor moveable = xmlObject.newCursor();
                try {
                    String schemaLocationURL = "http://java.sun.com/xml/ns/j2ee/connector_1_5.xsd";
                    String version = "1.5";
                    SchemaConversionUtils.convertToSchema((XmlCursor)cursor, (String)"http://java.sun.com/xml/ns/j2ee", (String)schemaLocationURL, (String)version);
                    cursor.toStartDoc();
                    cursor.toChild("http://java.sun.com/xml/ns/j2ee", "connector");
                    cursor.toFirstChild();
                    SchemaConversionUtils.convertToDescriptionGroup((String)"http://java.sun.com/xml/ns/j2ee", (XmlCursor)cursor, (XmlCursor)moveable);
                    cursor.toNextSibling("http://java.sun.com/xml/ns/j2ee", "spec-version");
                    cursor.removeXml();
                    cursor.toNextSibling("http://java.sun.com/xml/ns/j2ee", "version");
                    cursor.setName(RESOURCE_ADAPTER_VERSION);
                    cursor.toNextSibling("http://java.sun.com/xml/ns/j2ee", "resourceadapter");
                    moveable.toCursor(cursor);
                    cursor.toFirstChild();
                    cursor.beginElement("outbound-resourceadapter", "http://java.sun.com/xml/ns/j2ee");
                    cursor.beginElement("connection-definition", "http://java.sun.com/xml/ns/j2ee");
                    moveable.toChild("http://java.sun.com/xml/ns/j2ee", "managedconnectionfactory-class");
                    moveable.push();
                    moveable.moveXml(cursor);
                    while (moveable.toNextSibling("http://java.sun.com/xml/ns/j2ee", "config-property")) {
                        moveable.moveXml(cursor);
                    }
                    moveable.pop();
                    moveable.toNextSibling("http://java.sun.com/xml/ns/j2ee", "connectionfactory-interface");
                    moveable.moveXml(cursor);
                    moveable.toNextSibling("http://java.sun.com/xml/ns/j2ee", "connectionfactory-impl-class");
                    moveable.moveXml(cursor);
                    moveable.toNextSibling("http://java.sun.com/xml/ns/j2ee", "connection-interface");
                    moveable.moveXml(cursor);
                    moveable.toNextSibling("http://java.sun.com/xml/ns/j2ee", "connection-impl-class");
                    moveable.moveXml(cursor);
                    cursor.toNextToken();
                    moveable.toNextSibling("http://java.sun.com/xml/ns/j2ee", "transaction-support");
                    moveable.moveXml(cursor);
                    while (moveable.toNextSibling("http://java.sun.com/xml/ns/j2ee", "authentication-mechanism")) {
                        moveable.moveXml(cursor);
                    }
                    moveable.toNextSibling("http://java.sun.com/xml/ns/j2ee", "reauthentication-support");
                    moveable.moveXml(cursor);
                }
                finally {
                    moveable.dispose();
                }
            }
            finally {
                cursor.dispose();
            }
        }
        XmlObject result = xmlObject.changeType(ConnectorDocument.type);
        if (result != null) {
            XmlBeansUtil.validateDD((XmlObject)result);
            return (ConnectorDocument)result;
        }
        XmlBeansUtil.validateDD((XmlObject)xmlObject);
        return (ConnectorDocument)xmlObject;
    }

    public void installModule(JarFile earFile, EARContext earContext, Module module, Collection configurationStores, ConfigurationStore targetConfigurationStore, Collection repository) throws DeploymentException {
        try {
            JarFile moduleFile = module.getModuleFile();
            earContext.addManifestClassPath(moduleFile, URI.create(module.getTargetPath()));
            URI targetURI = URI.create(module.getTargetPath() + "/");
            Enumeration<JarEntry> entries = moduleFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                URI target = targetURI.resolve(entry.getName());
                if (entry.getName().endsWith(".jar")) {
                    earContext.addInclude(target, (ZipFile)moduleFile, entry);
                    continue;
                }
                earContext.addFile(target, (ZipFile)moduleFile, entry);
            }
        }
        catch (IOException e) {
            throw new DeploymentException("Problem deploying connector", (Throwable)e);
        }
    }

    public void initContext(EARContext earContext, Module module, ClassLoader cl) throws DeploymentException {
        ConnectorModule resourceModule = (ConnectorModule)module;
        ConnectorType connector = (ConnectorType)module.getSpecDD();
        AbstractName resourceAdapterModuleName = resourceModule.getModuleName();
        AbstractName resourceAdapterjsr77Name = earContext.getNaming().createChildName(resourceAdapterModuleName, module.getName(), "ResourceAdapter");
        AbstractName jcaResourcejsr77Name = earContext.getNaming().createChildName(resourceAdapterjsr77Name, module.getName(), "JCAResource");
        GBeanData resourceAdapterModuleData = new GBeanData(resourceAdapterModuleName, ResourceAdapterModuleImplGBean.GBEAN_INFO);
        if (earContext.getServerName() != null) {
            resourceAdapterModuleData.setReferencePattern("J2EEServer", earContext.getServerName());
            if (!earContext.getModuleName().equals((Object)resourceAdapterModuleName)) {
                resourceAdapterModuleData.setReferencePattern("J2EEApplication", earContext.getModuleName());
            }
        }
        resourceAdapterModuleData.setReferencePattern("ResourceAdapter", resourceAdapterjsr77Name);
        resourceAdapterModuleData.setAttribute("deploymentDescriptor", (Object)module.getOriginalSpecDD());
        resourceAdapterModuleData.setAttribute("displayName", connector.getDisplayNameArray().length == 0 ? null : connector.getDisplayNameArray(0).getStringValue());
        resourceAdapterModuleData.setAttribute("description", connector.getDescriptionArray().length == 0 ? null : connector.getDescriptionArray(0).getStringValue());
        resourceAdapterModuleData.setAttribute("vendorName", (Object)connector.getVendorName().getStringValue());
        resourceAdapterModuleData.setAttribute("EISType", (Object)connector.getEisType().getStringValue());
        resourceAdapterModuleData.setAttribute("resourceAdapterVersion", (Object)connector.getResourceadapterVersion().getStringValue());
        ResourceadapterType resourceadapter = connector.getResourceadapter();
        if (resourceadapter.isSetResourceadapterClass()) {
            GBeanInfoBuilder resourceAdapterInfoBuilder = new GBeanInfoBuilder(ResourceAdapterWrapperGBean.class, ResourceAdapterWrapperGBean.GBEAN_INFO);
            GBeanData resourceAdapterGBeanData = this.setUpDynamicGBean(resourceAdapterInfoBuilder, resourceadapter.getConfigPropertyArray(), cl);
            resourceAdapterGBeanData.setAttribute("resourceAdapterClass", (Object)resourceadapter.getResourceadapterClass().getStringValue().trim());
            resourceAdapterModuleData.setAttribute("resourceAdapterGBeanData", (Object)resourceAdapterGBeanData);
        }
        if (resourceadapter.isSetInboundResourceadapter() && resourceadapter.getInboundResourceadapter().isSetMessageadapter()) {
            Map activationSpecInfoMap = this.getActivationSpecInfoMap(resourceadapter.getInboundResourceadapter().getMessageadapter().getMessagelistenerArray(), cl);
            resourceAdapterModuleData.setAttribute("activationSpecInfoMap", (Object)activationSpecInfoMap);
        }
        Map adminObjectInfoMap = this.getAdminObjectInfoMap(resourceadapter.getAdminobjectArray(), cl);
        resourceAdapterModuleData.setAttribute("adminObjectInfoMap", (Object)adminObjectInfoMap);
        if (resourceadapter.isSetOutboundResourceadapter()) {
            Map managedConnectionFactoryInfoMap = this.getManagedConnectionFactoryInfoMap(resourceadapter.getOutboundResourceadapter().getConnectionDefinitionArray(), cl);
            resourceAdapterModuleData.setAttribute("managedConnectionFactoryInfoMap", (Object)managedConnectionFactoryInfoMap);
        }
        try {
            earContext.addGBean(resourceAdapterModuleData);
        }
        catch (GBeanAlreadyExistsException e) {
            throw new DeploymentException("Could not add resource adapter module gbean to context", (Throwable)e);
        }
        GBeanData resourceAdapterData = new GBeanData(resourceAdapterjsr77Name, ResourceAdapterImplGBean.GBEAN_INFO);
        resourceAdapterData.setReferencePattern("JCAResource", jcaResourcejsr77Name);
        try {
            earContext.addGBean(resourceAdapterData);
        }
        catch (GBeanAlreadyExistsException e) {
            throw new DeploymentException("Could not add resource adapter gbean to context", (Throwable)e);
        }
        GBeanData jcaResourceData = new GBeanData(jcaResourcejsr77Name, JCAResourceImplGBean.GBEAN_INFO);
        LinkedHashMap<String, String> thisModule = new LinkedHashMap<String, String>(2);
        thisModule.put("J2EEApplication", resourceAdapterModuleName.getNameProperty("J2EEApplication"));
        thisModule.put("ResourceAdapterModule", resourceAdapterModuleName.getNameProperty("name"));
        jcaResourceData.setReferencePattern("ConnectionFactories", new AbstractNameQuery(resourceAdapterModuleName.getArtifact(), thisModule, JCAConnectionFactory.class.getName()));
        jcaResourceData.setReferencePattern("ResourceAdapters", new AbstractNameQuery(resourceAdapterModuleName.getArtifact(), thisModule, JCAResourceAdapter.class.getName()));
        jcaResourceData.setReferencePattern("AdminObjects", new AbstractNameQuery(resourceAdapterModuleName.getArtifact(), thisModule, JCAAdminObject.class.getName()));
        try {
            earContext.addGBean(jcaResourceData);
        }
        catch (GBeanAlreadyExistsException e) {
            throw new DeploymentException("Could not add jca resource gbean to context", (Throwable)e);
        }
        GerConnectorType geronimoConnector = (GerConnectorType)module.getVendorDD();
        this.serviceBuilders.build((XmlObject)geronimoConnector, (DeploymentContext)earContext, (DeploymentContext)earContext);
        this.addConnectorGBeans(earContext, jcaResourcejsr77Name, resourceAdapterModuleData, connector, geronimoConnector, cl);
    }

    public void addGBeans(EARContext earContext, Module module, ClassLoader cl, Collection repository) throws DeploymentException {
    }

    public String getSchemaNamespace() {
        return GERCONNECTOR_NAMESPACE;
    }

    private void addConnectorGBeans(EARContext earContext, AbstractName jcaResourceName, GBeanData resourceAdapterModuleData, ConnectorType connector, GerConnectorType geronimoConnector, ClassLoader cl) throws DeploymentException {
        ResourceadapterType resourceadapter = connector.getResourceadapter();
        GerResourceadapterType[] geronimoResourceAdapters = geronimoConnector.getResourceadapterArray();
        for (int k = 0; k < geronimoResourceAdapters.length; ++k) {
            GerResourceadapterType geronimoResourceAdapter = geronimoResourceAdapters[k];
            AbstractName resourceAdapterAbstractName = null;
            if (resourceadapter.isSetResourceadapterClass()) {
                GBeanData resourceAdapterGBeanData = this.locateResourceAdapterGBeanData(resourceAdapterModuleData);
                GBeanData resourceAdapterInstanceGBeanData = new GBeanData(resourceAdapterGBeanData);
                this.setDynamicGBeanDataAttributes(resourceAdapterInstanceGBeanData, geronimoResourceAdapter.getResourceadapterInstance().getConfigPropertySettingArray(), cl);
                AbstractNameQuery workManagerName = ENCConfigBuilder.getGBeanQuery((String)"JCAWorkManager", (GerGbeanLocatorType)geronimoResourceAdapter.getResourceadapterInstance().getWorkmanager());
                resourceAdapterInstanceGBeanData.setReferencePattern("WorkManager", workManagerName);
                resourceAdapterInstanceGBeanData.setReferencePattern("XATerminator", earContext.getTransactionManagerName());
                String resourceAdapterName = geronimoResourceAdapter.getResourceadapterInstance().getResourceadapterName();
                resourceAdapterAbstractName = earContext.getNaming().createChildName(jcaResourceName, resourceAdapterName, "JCAResourceAdapter");
                resourceAdapterInstanceGBeanData.setAbstractName(resourceAdapterAbstractName);
                try {
                    earContext.addGBean(resourceAdapterInstanceGBeanData);
                }
                catch (GBeanAlreadyExistsException e) {
                    throw new DeploymentException("Could not add resource adapter instance gbean to context", (Throwable)e);
                }
            }
            if (!geronimoResourceAdapter.isSetOutboundResourceadapter()) continue;
            if (!resourceadapter.isSetOutboundResourceadapter()) {
                throw new DeploymentException("Geronimo plan configures an outbound resource adapter but ra.xml does not describe any");
            }
            String transactionSupport = resourceadapter.getOutboundResourceadapter().getTransactionSupport().getStringValue().trim();
            for (int i = 0; i < geronimoResourceAdapter.getOutboundResourceadapter().getConnectionDefinitionArray().length; ++i) {
                GerConnectionDefinitionType geronimoConnectionDefinition = geronimoResourceAdapter.getOutboundResourceadapter().getConnectionDefinitionArray(i);
                if (!$assertionsDisabled && geronimoConnectionDefinition == null) {
                    throw new AssertionError((Object)"Null GeronimoConnectionDefinition");
                }
                String connectionFactoryInterfaceName = geronimoConnectionDefinition.getConnectionfactoryInterface().trim();
                GBeanData connectionFactoryGBeanData = this.locateConnectionFactoryInfo(resourceAdapterModuleData, connectionFactoryInterfaceName);
                if (connectionFactoryGBeanData == null) {
                    throw new DeploymentException("No connection definition for ConnectionFactory class: " + connectionFactoryInterfaceName);
                }
                for (int j = 0; j < geronimoConnectionDefinition.getConnectiondefinitionInstanceArray().length; ++j) {
                    GerConnectiondefinitionInstanceType connectionfactoryInstance = geronimoConnectionDefinition.getConnectiondefinitionInstanceArray()[j];
                    this.addOutboundGBeans(earContext, jcaResourceName, resourceAdapterAbstractName, connectionFactoryGBeanData, connectionfactoryInstance, transactionSupport, cl);
                }
            }
        }
        for (int i = 0; i < geronimoConnector.getAdminobjectArray().length; ++i) {
            GerAdminobjectType gerAdminObject = geronimoConnector.getAdminobjectArray()[i];
            String adminObjectInterface = gerAdminObject.getAdminobjectInterface().trim();
            GBeanData adminObjectGBeanData = this.locateAdminObjectInfo(resourceAdapterModuleData, adminObjectInterface);
            if (adminObjectGBeanData == null) {
                throw new DeploymentException("No admin object declared for interface: " + adminObjectInterface);
            }
            for (int j = 0; j < gerAdminObject.getAdminobjectInstanceArray().length; ++j) {
                GBeanData adminObjectInstanceGBeanData = new GBeanData(adminObjectGBeanData);
                GerAdminobjectInstanceType gerAdminObjectInstance = gerAdminObject.getAdminobjectInstanceArray()[j];
                this.setDynamicGBeanDataAttributes(adminObjectInstanceGBeanData, gerAdminObjectInstance.getConfigPropertySettingArray(), cl);
                AbstractName adminObjectAbstractName = earContext.getNaming().createChildName(jcaResourceName, gerAdminObjectInstance.getMessageDestinationName().trim(), "JCAAdminObject");
                adminObjectInstanceGBeanData.setAbstractName(adminObjectAbstractName);
                try {
                    earContext.addGBean(adminObjectInstanceGBeanData);
                    continue;
                }
                catch (GBeanAlreadyExistsException e) {
                    throw new DeploymentException("Could not add admin object gbean to context", (Throwable)e);
                }
            }
        }
    }

    private Map getActivationSpecInfoMap(MessagelistenerType[] messagelistenerArray, ClassLoader cl) throws DeploymentException {
        HashMap<String, GBeanData> activationSpecInfos = new HashMap<String, GBeanData>();
        for (int i = 0; i < messagelistenerArray.length; ++i) {
            Method[] methods;
            MessagelistenerType messagelistenerType = messagelistenerArray[i];
            String messageListenerInterface = messagelistenerType.getMessagelistenerType().getStringValue().trim();
            ActivationspecType activationspec = messagelistenerType.getActivationspec();
            String activationSpecClassName = activationspec.getActivationspecClass().getStringValue().trim();
            GBeanInfoBuilder infoBuilder = new GBeanInfoBuilder(class$org$apache$geronimo$connector$ActivationSpecWrapperGBean == null ? ConnectorModuleBuilder.class$("org.apache.geronimo.connector.ActivationSpecWrapperGBean") : class$org$apache$geronimo$connector$ActivationSpecWrapperGBean, ActivationSpecWrapperGBean.GBEAN_INFO);
            HashMap<String, String> getters = new HashMap<String, String>();
            HashSet<String> setters = new HashSet<String>();
            try {
                Class<?> activationSpecClass = cl.loadClass(activationSpecClassName);
                methods = activationSpecClass.getMethods();
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("Can not load activation spec class", (Throwable)e);
            }
            for (int j = 0; j < methods.length; ++j) {
                Method method = methods[j];
                String methodName = method.getName();
                if ((methodName.startsWith("get") || methodName.startsWith("is")) && method.getParameterTypes().length == 0) {
                    String attributeName = methodName.startsWith("get") ? methodName.substring(3) : methodName.substring(2);
                    getters.put(Introspector.decapitalize(attributeName), method.getReturnType().getName());
                    continue;
                }
                if (!methodName.startsWith("set") || method.getParameterTypes().length != 1) continue;
                setters.add(Introspector.decapitalize(methodName.substring(3)));
            }
            getters.keySet().retainAll(setters);
            getters.remove("resourceAdapter");
            Iterator iterator = getters.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                infoBuilder.addAttribute((GAttributeInfo)new DynamicGAttributeInfo((String)entry.getKey(), (String)entry.getValue(), true, true, true, true));
            }
            GBeanInfo gbeanInfo = infoBuilder.getBeanInfo();
            try {
                cl.loadClass(activationSpecClassName);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("Could not load ActivationSpec class", (Throwable)e);
            }
            GBeanData activationSpecInfo = new GBeanData(gbeanInfo);
            activationSpecInfo.setAttribute("activationSpecClass", (Object)activationSpecClassName);
            activationSpecInfos.put(messageListenerInterface, activationSpecInfo);
        }
        return activationSpecInfos;
    }

    private Map getManagedConnectionFactoryInfoMap(ConnectionDefinitionType[] connectionDefinitionArray, ClassLoader cl) throws DeploymentException {
        HashMap<String, GBeanData> managedConnectionFactoryInfos = new HashMap<String, GBeanData>();
        for (int i = 0; i < connectionDefinitionArray.length; ++i) {
            ConnectionDefinitionType connectionDefinition = connectionDefinitionArray[i];
            GBeanInfoBuilder managedConnectionFactoryInfoBuilder = new GBeanInfoBuilder(class$org$apache$geronimo$connector$outbound$ManagedConnectionFactoryWrapper == null ? ConnectorModuleBuilder.class$("org.apache.geronimo.connector.outbound.ManagedConnectionFactoryWrapper") : class$org$apache$geronimo$connector$outbound$ManagedConnectionFactoryWrapper, ManagedConnectionFactoryWrapperGBean.GBEAN_INFO);
            GBeanData managedConnectionFactoryGBeanData = this.setUpDynamicGBean(managedConnectionFactoryInfoBuilder, connectionDefinition.getConfigPropertyArray(), cl);
            String connectionfactoryInterface = connectionDefinition.getConnectionfactoryInterface().getStringValue().trim();
            managedConnectionFactoryGBeanData.setAttribute("managedConnectionFactoryClass", (Object)connectionDefinition.getManagedconnectionfactoryClass().getStringValue().trim());
            managedConnectionFactoryGBeanData.setAttribute("connectionFactoryInterface", (Object)connectionfactoryInterface);
            managedConnectionFactoryGBeanData.setAttribute("connectionFactoryImplClass", (Object)connectionDefinition.getConnectionfactoryImplClass().getStringValue().trim());
            managedConnectionFactoryGBeanData.setAttribute("connectionInterface", (Object)connectionDefinition.getConnectionInterface().getStringValue().trim());
            managedConnectionFactoryGBeanData.setAttribute("connectionImplClass", (Object)connectionDefinition.getConnectionImplClass().getStringValue().trim());
            managedConnectionFactoryInfos.put(connectionfactoryInterface, managedConnectionFactoryGBeanData);
        }
        return managedConnectionFactoryInfos;
    }

    private Map getAdminObjectInfoMap(AdminobjectType[] adminobjectArray, ClassLoader cl) throws DeploymentException {
        HashMap<String, GBeanData> adminObjectInfos = new HashMap<String, GBeanData>();
        for (int i = 0; i < adminobjectArray.length; ++i) {
            AdminobjectType adminObject = adminobjectArray[i];
            GBeanInfoBuilder adminObjectInfoBuilder = new GBeanInfoBuilder(class$org$apache$geronimo$connector$AdminObjectWrapper == null ? ConnectorModuleBuilder.class$("org.apache.geronimo.connector.AdminObjectWrapper") : class$org$apache$geronimo$connector$AdminObjectWrapper, AdminObjectWrapperGBean.GBEAN_INFO);
            GBeanData adminObjectGBeanData = this.setUpDynamicGBean(adminObjectInfoBuilder, adminObject.getConfigPropertyArray(), cl);
            String adminObjectInterface = adminObject.getAdminobjectInterface().getStringValue().trim();
            adminObjectGBeanData.setAttribute("adminObjectInterface", (Object)adminObjectInterface);
            adminObjectGBeanData.setAttribute("adminObjectClass", (Object)adminObject.getAdminobjectClass().getStringValue().trim());
            adminObjectInfos.put(adminObjectInterface, adminObjectGBeanData);
        }
        return adminObjectInfos;
    }

    private GBeanData setUpDynamicGBean(GBeanInfoBuilder infoBuilder, ConfigPropertyType[] configProperties, ClassLoader cl) throws DeploymentException {
        for (int i = 0; i < configProperties.length; ++i) {
            infoBuilder.addAttribute((GAttributeInfo)new DynamicGAttributeInfo(configProperties[i].getConfigPropertyName().getStringValue().trim(), configProperties[i].getConfigPropertyType().getStringValue().trim(), true, true, true, true));
        }
        GBeanInfo gbeanInfo = infoBuilder.getBeanInfo();
        GBeanData gbeanData = new GBeanData(gbeanInfo);
        for (int i = 0; i < configProperties.length; ++i) {
            if (!configProperties[i].isSetConfigPropertyValue()) continue;
            gbeanData.setAttribute(configProperties[i].getConfigPropertyName().getStringValue(), this.getValue(configProperties[i].getConfigPropertyType().getStringValue(), configProperties[i].getConfigPropertyValue().getStringValue(), cl));
        }
        return gbeanData;
    }

    private void setDynamicGBeanDataAttributes(GBeanData gbeanData, GerConfigPropertySettingType[] configProperties, ClassLoader cl) throws DeploymentException {
        try {
            for (int i = 0; i < configProperties.length; ++i) {
                String name = configProperties[i].getName();
                GAttributeInfo attributeInfo = gbeanData.getGBeanInfo().getAttribute(name);
                if (attributeInfo == null) {
                    throw new DeploymentException("The plan is trying to set attribute: " + name + " which does not exist.  Known attributs are: " + gbeanData.getGBeanInfo().getAttributes());
                }
                String type = attributeInfo.getType();
                gbeanData.setAttribute(name, this.getValue(type, configProperties[i].getStringValue().trim(), cl));
            }
        }
        catch (DeploymentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DeploymentException((Throwable)e);
        }
    }

    private Object getValue(String type, String value, ClassLoader cl) throws DeploymentException {
        Class<?> clazz;
        if (value == null) {
            return null;
        }
        try {
            clazz = cl.loadClass(type);
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentException("Could not load attribute class:  type: " + type, (Throwable)e);
        }
        if (value.equals("") && (Number.class.isAssignableFrom(clazz) || Date.class.isAssignableFrom(clazz))) {
            return null;
        }
        PropertyEditor editor = PropertyEditors.getEditor(clazz);
        editor.setAsText(value);
        return editor.getValue();
    }

    private AbstractName configureConnectionManager(EARContext earContext, AbstractName jcaResourceName, String ddTransactionSupport, GerConnectiondefinitionInstanceType connectionfactoryInstance, ClassLoader cl) throws DeploymentException {
        NoPool pooling;
        GerSinglepoolType pool;
        TransactionSupport transactionSupport;
        GBeanInfo gbeanInfo;
        AbstractName connectionManagerAbstractName = earContext.getNaming().createChildName(jcaResourceName, connectionfactoryInstance.getName().trim(), "JCAConnectionManager");
        try {
            gbeanInfo = GBeanInfo.getGBeanInfo((String)"org.apache.geronimo.connector.outbound.GenericConnectionManagerGBean", (ClassLoader)cl);
        }
        catch (InvalidConfigurationException e) {
            throw new DeploymentException("Unable to create GMBean", (Throwable)e);
        }
        GBeanData connectionManagerGBean = new GBeanData(connectionManagerAbstractName, gbeanInfo);
        GerConnectionmanagerType connectionManager = connectionfactoryInstance.getConnectionmanager();
        if (connectionManager.isSetNoTransaction()) {
            transactionSupport = NoTransactions.INSTANCE;
        } else if (connectionManager.isSetLocalTransaction()) {
            if ("NoTransaction".equals(ddTransactionSupport)) {
                throw new DeploymentException("You are requesting local transaction support for a connector that does not support transactions: named: " + connectionfactoryInstance.getName().trim());
            }
            transactionSupport = LocalTransactions.INSTANCE;
        } else if (connectionManager.isSetTransactionLog()) {
            if ("NoTransaction".equals(ddTransactionSupport)) {
                throw new DeploymentException("You are requesting local transaction support for a connector that does not support transactions: named: " + connectionfactoryInstance.getName().trim());
            }
            transactionSupport = TransactionLog.INSTANCE;
        } else if (connectionManager.isSetXaTransaction()) {
            if ("NoTransaction".equals(ddTransactionSupport)) {
                throw new DeploymentException("You are requesting xa transaction support for a connector that does not support transactions: named: " + connectionfactoryInstance.getName().trim());
            }
            if ("LocalTransaction".equals(ddTransactionSupport)) {
                throw new DeploymentException("You are requesting xa transaction support for a connector that supports only local transactions: named: " + connectionfactoryInstance.getName().trim());
            }
            transactionSupport = new XATransactions(connectionManager.getXaTransaction().isSetTransactionCaching(), connectionManager.getXaTransaction().isSetThreadCaching());
        } else if ("NoTransaction".equals(ddTransactionSupport)) {
            transactionSupport = NoTransactions.INSTANCE;
        } else if ("LocalTransaction".equals(ddTransactionSupport)) {
            transactionSupport = LocalTransactions.INSTANCE;
        } else if ("XATransaction".equals(ddTransactionSupport)) {
            transactionSupport = new XATransactions(this.defaultXATransactionCaching, this.defaultXAThreadCaching);
        } else {
            throw new DeploymentException("Unexpected transaction support element in connector named: " + connectionfactoryInstance.getName().trim());
        }
        if (connectionManager.getSinglePool() != null) {
            pool = connectionManager.getSinglePool();
            pooling = new SinglePool(pool.isSetMaxSize() ? pool.getMaxSize() : this.defaultMaxSize, pool.isSetMinSize() ? pool.getMinSize() : this.defaultMinSize, pool.isSetBlockingTimeoutMilliseconds() ? pool.getBlockingTimeoutMilliseconds() : this.defaultBlockingTimeoutMilliseconds, pool.isSetIdleTimeoutMinutes() ? pool.getIdleTimeoutMinutes() : this.defaultIdleTimeoutMinutes, pool.getMatchOne() != null, pool.getMatchAll() != null, pool.getSelectOneAssumeMatch() != null);
        } else if (connectionManager.getPartitionedPool() != null) {
            pool = connectionManager.getPartitionedPool();
            pooling = new PartitionedPool(pool.isSetMaxSize() ? pool.getMaxSize() : this.defaultMaxSize, pool.isSetMinSize() ? pool.getMinSize() : this.defaultMinSize, pool.isSetBlockingTimeoutMilliseconds() ? pool.getBlockingTimeoutMilliseconds() : this.defaultBlockingTimeoutMilliseconds, pool.isSetIdleTimeoutMinutes() ? pool.getIdleTimeoutMinutes() : this.defaultIdleTimeoutMinutes, pool.getMatchOne() != null, pool.getMatchAll() != null, pool.getSelectOneAssumeMatch() != null, pool.isSetPartitionByConnectionrequestinfo(), pool.isSetPartitionBySubject());
        } else if (connectionManager.getNoPool() != null) {
            pooling = new NoPool();
        } else {
            throw new DeploymentException("Unexpected pooling support element in connector named " + connectionfactoryInstance.getName().trim());
        }
        try {
            connectionManagerGBean.setAttribute("transactionSupport", (Object)transactionSupport);
            connectionManagerGBean.setAttribute("pooling", (Object)pooling);
            connectionManagerGBean.setReferencePattern("ConnectionTracker", earContext.getConnectionTrackerName());
            connectionManagerGBean.setAttribute("containerManagedSecurity", (Object)connectionManager.isSetContainerManagedSecurity());
            connectionManagerGBean.setReferencePattern("TransactionManager", earContext.getTransactionManagerName());
        }
        catch (Exception e) {
            throw new DeploymentException("Problem setting up ConnectionManager named " + connectionfactoryInstance.getName().trim(), (Throwable)e);
        }
        try {
            earContext.addGBean(connectionManagerGBean);
        }
        catch (GBeanAlreadyExistsException e) {
            throw new DeploymentException("Could not add connection manager gbean to context: name: " + connectionfactoryInstance.getName().trim(), (Throwable)e);
        }
        return connectionManagerAbstractName;
    }

    private void addOutboundGBeans(EARContext earContext, AbstractName jcaResourceName, AbstractName resourceAdapterAbstractName, GBeanData managedConnectionFactoryPrototypeGBeanData, GerConnectiondefinitionInstanceType connectiondefinitionInstance, String transactionSupport, ClassLoader cl) throws DeploymentException {
        GBeanData managedConnectionFactoryInstanceGBeanData = new GBeanData(managedConnectionFactoryPrototypeGBeanData);
        AbstractName connectionFactoryAbstractName = earContext.getNaming().createChildName(jcaResourceName, connectiondefinitionInstance.getName().trim(), "JCAConnectionFactory");
        AbstractName managedConnectionFactoryAbstractName = earContext.getNaming().createChildName(connectionFactoryAbstractName, connectiondefinitionInstance.getName().trim(), "JCAManagedConnectionFactory");
        AbstractName connectionManagerAbstractName = this.configureConnectionManager(earContext, managedConnectionFactoryAbstractName, transactionSupport, connectiondefinitionInstance, cl);
        this.setDynamicGBeanDataAttributes(managedConnectionFactoryInstanceGBeanData, connectiondefinitionInstance.getConfigPropertySettingArray(), cl);
        Object driver = managedConnectionFactoryInstanceGBeanData.getAttribute("Driver");
        if (driver != null && driver instanceof String) {
            try {
                cl.loadClass((String)driver);
            }
            catch (ClassNotFoundException e1) {
                log.warn((Object)("Problem loading driver class '" + driver + "', possibly due to a missing dependency on the driver jar!!"), (Throwable)e1);
            }
        }
        try {
            if (resourceAdapterAbstractName != null) {
                managedConnectionFactoryInstanceGBeanData.setReferencePattern("ResourceAdapterWrapper", resourceAdapterAbstractName);
            }
            managedConnectionFactoryInstanceGBeanData.setReferencePattern("ConnectionManagerContainer", connectionManagerAbstractName);
            String[] implementedInterfaces = connectiondefinitionInstance.getImplementedInterfaceArray();
            if (implementedInterfaces != null) {
                for (int i = 0; i < implementedInterfaces.length; ++i) {
                    implementedInterfaces[i] = implementedInterfaces[i].trim();
                }
            } else {
                implementedInterfaces = new String[]{};
            }
            managedConnectionFactoryInstanceGBeanData.setAttribute("implementedInterfaces", (Object)implementedInterfaces);
        }
        catch (Exception e) {
            throw new DeploymentException((Throwable)e);
        }
        managedConnectionFactoryInstanceGBeanData.setAbstractName(managedConnectionFactoryAbstractName);
        try {
            earContext.addGBean(managedConnectionFactoryInstanceGBeanData);
        }
        catch (GBeanAlreadyExistsException e) {
            throw new DeploymentException("Could not add managed connection factory gbean to context", (Throwable)e);
        }
        GBeanData connectionFactoryGBeanData = new GBeanData(connectionFactoryAbstractName, JCAConnectionFactoryImplGBean.GBEAN_INFO);
        connectionFactoryGBeanData.setReferencePattern("JCAManagedConnectionFactory", managedConnectionFactoryAbstractName);
        try {
            earContext.addGBean(connectionFactoryGBeanData);
        }
        catch (GBeanAlreadyExistsException e) {
            throw new DeploymentException("Could not add connection factory gbean to context", (Throwable)e);
        }
    }

    public Reference createResourceRef(AbstractNameQuery containerId, Class iface, Configuration configuration) throws DeploymentException {
        try {
            configuration.findGBean(containerId);
        }
        catch (GBeanNotFoundException e) {
            throw new UnresolvedReferenceException("Resource", false, containerId.toString(), configuration.getId().toString());
        }
        return new ResourceReference(configuration.getId(), containerId, iface);
    }

    public Reference createAdminObjectRef(AbstractNameQuery containerId, Class iface, Configuration configuration) throws DeploymentException {
        try {
            configuration.findGBean(containerId);
        }
        catch (GBeanNotFoundException e) {
            throw new DeploymentException("Can not resolve admin object ref " + containerId + " in configuration " + configuration.getId());
        }
        return new ResourceReference(configuration.getId(), containerId, iface);
    }

    public GBeanData locateActivationSpecInfo(AbstractNameQuery resourceAdapterInstanceQuery, String messageListenerInterface, Configuration configuration) throws DeploymentException {
        GBeanData resourceModuleData;
        AbstractName instanceName;
        try {
            instanceName = configuration.findGBean(resourceAdapterInstanceQuery);
        }
        catch (GBeanNotFoundException e) {
            throw new DeploymentException("No resource adapter instance gbean found matching " + resourceAdapterInstanceQuery + " from configuration " + configuration.getId());
        }
        String moduleName = (String)instanceName.getName().get("ResourceAdapterModule");
        HashMap<String, String> moduleNameMap = new HashMap<String, String>(instanceName.getName());
        moduleNameMap.remove("JCAResource");
        moduleNameMap.remove("ResourceAdapter");
        moduleNameMap.remove("ResourceAdapterModule");
        moduleNameMap.put("j2eeType", "ResourceAdapterModule");
        moduleNameMap.put("name", moduleName);
        AbstractNameQuery nameQuery = new AbstractNameQuery(instanceName.getArtifact(), moduleNameMap, ResourceAdapterModule.class.getName());
        try {
            resourceModuleData = configuration.findGBeanData(nameQuery);
        }
        catch (GBeanNotFoundException e) {
            throw new DeploymentException("No resource module gbean found matching " + nameQuery + " from configuration " + configuration.getId());
        }
        Map activationSpecInfos = (Map)resourceModuleData.getAttribute("activationSpecInfoMap");
        if (activationSpecInfos == null) {
            throw new DeploymentException("No activation spec info map found in resource adapter module: " + resourceModuleData.getAbstractName());
        }
        return (GBeanData)activationSpecInfos.get(messageListenerInterface);
    }

    private GBeanData locateResourceAdapterGBeanData(GBeanData resourceAdapterModuleData) throws DeploymentException {
        GBeanData data = (GBeanData)resourceAdapterModuleData.getAttribute("resourceAdapterGBeanData");
        if (data == null) {
            throw new DeploymentException("No resource adapter info found for resource adapter module: " + resourceAdapterModuleData.getAbstractName());
        }
        return data;
    }

    private GBeanData locateAdminObjectInfo(GBeanData resourceAdapterModuleData, String adminObjectInterfaceName) throws DeploymentException {
        Map adminObjectInfos = (Map)resourceAdapterModuleData.getAttribute("adminObjectInfoMap");
        if (adminObjectInfos == null) {
            throw new DeploymentException("No admin object infos found for resource adapter module: " + resourceAdapterModuleData.getAbstractName());
        }
        return (GBeanData)adminObjectInfos.get(adminObjectInterfaceName);
    }

    private GBeanData locateConnectionFactoryInfo(GBeanData resourceAdapterModuleData, String connectionFactoryInterfaceName) throws DeploymentException {
        Map managedConnectionFactoryInfos = (Map)resourceAdapterModuleData.getAttribute("managedConnectionFactoryInfoMap");
        if (managedConnectionFactoryInfos == null) {
            throw new DeploymentException("No managed connection factory infos found for resource adapter module: " + resourceAdapterModuleData.getAbstractName());
        }
        return (GBeanData)managedConnectionFactoryInfos.get(connectionFactoryInterfaceName);
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        $assertionsDisabled = !ConnectorModuleBuilder.class.desiredAssertionStatus();
        log = LogFactory.getLog((Class)ConnectorModuleBuilder.class);
        CONNECTOR_QNAME = GerConnectorDocument.type.getDocumentElementName();
        GERCONNECTOR_NAMESPACE = CONNECTOR_QNAME.getNamespaceURI();
        RESOURCE_ADAPTER_VERSION = new QName("http://java.sun.com/xml/ns/j2ee", "resourceadapter-version");
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic((Class)ConnectorModuleBuilder.class, (String)"ModuleBuilder");
        infoBuilder.addAttribute("defaultEnvironment", Environment.class, true, true);
        infoBuilder.addAttribute("defaultMaxSize", Integer.TYPE, true, true);
        infoBuilder.addAttribute("defaultMinSize", Integer.TYPE, true, true);
        infoBuilder.addAttribute("defaultBlockingTimeoutMilliseconds", Integer.TYPE, true, true);
        infoBuilder.addAttribute("defaultIdleTimeoutMinutes", Integer.TYPE, true, true);
        infoBuilder.addAttribute("defaultXATransactionCaching", Boolean.TYPE, true, true);
        infoBuilder.addAttribute("defaultXAThreadCaching", Boolean.TYPE, true, true);
        infoBuilder.addReference("ServiceBuilders", NamespaceDrivenBuilder.class, "ModuleBuilder");
        infoBuilder.addInterface(ModuleBuilder.class);
        infoBuilder.addInterface(ActivationSpecInfoLocator.class);
        infoBuilder.setConstructor(new String[]{"defaultEnvironment", "defaultMaxSize", "defaultMinSize", "defaultBlockingTimeoutMilliseconds", "defaultIdleTimeoutMinutes", "defaultXATransactionCaching", "defaultXAThreadCaching", "ServiceBuilders"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

