/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector.deployment;

import [Ljava.lang.String;;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.naming.Reference;
import javax.xml.namespace.QName;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.common.UnresolvedReferenceException;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.naming.deployment.AbstractNamingBuilder;
import org.apache.geronimo.naming.reference.ResourceReference;
import org.apache.geronimo.schema.NamespaceElementConverter;
import org.apache.geronimo.xbeans.geronimo.naming.GerMessageDestinationDocument;
import org.apache.geronimo.xbeans.geronimo.naming.GerMessageDestinationType;
import org.apache.geronimo.xbeans.geronimo.naming.GerPatternType;
import org.apache.geronimo.xbeans.geronimo.naming.GerResourceEnvRefDocument;
import org.apache.geronimo.xbeans.geronimo.naming.GerResourceEnvRefType;
import org.apache.geronimo.xbeans.j2ee.MessageDestinationRefType;
import org.apache.geronimo.xbeans.j2ee.MessageDestinationType;
import org.apache.geronimo.xbeans.j2ee.ResourceEnvRefType;
import org.apache.xmlbeans.QNameSet;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlObject;

public class AdminObjectRefBuilder
extends AbstractNamingBuilder {
    private final QNameSet adminOjbectRefQNameSet;
    private final QNameSet messageDestinationQNameSet;
    private final QNameSet messageDestinationRefQNameSet;
    private static final QName GER_ADMIN_OBJECT_REF_QNAME = GerResourceEnvRefDocument.type.getDocumentElementName();
    private static final QNameSet GER_ADMIN_OBJECT_REF_QNAME_SET = QNameSet.singleton((QName)GER_ADMIN_OBJECT_REF_QNAME);
    private static final QName GER_MESSAGE_DESTINATION_QNAME = GerMessageDestinationDocument.type.getDocumentElementName();
    private static final QNameSet GER_MESSAGE_DESTINATION_QNAME_SET = QNameSet.singleton((QName)GER_MESSAGE_DESTINATION_QNAME);
    public static final GBeanInfo GBEAN_INFO;

    public AdminObjectRefBuilder(Environment defaultEnvironment, String[] eeNamespaces) {
        super(defaultEnvironment);
        this.adminOjbectRefQNameSet = AdminObjectRefBuilder.buildQNameSet((String[])eeNamespaces, (String)"resource-env-ref");
        this.messageDestinationQNameSet = AdminObjectRefBuilder.buildQNameSet((String[])eeNamespaces, (String)"message-destination");
        this.messageDestinationRefQNameSet = AdminObjectRefBuilder.buildQNameSet((String[])eeNamespaces, (String)"message-destination-ref");
    }

    protected boolean willMergeEnvironment(XmlObject specDD, XmlObject plan) {
        return specDD.selectChildren(this.adminOjbectRefQNameSet).length > 0 || specDD.selectChildren(this.messageDestinationRefQNameSet).length > 0;
    }

    public void initContext(XmlObject specDD, XmlObject plan, Configuration localConfiguration, Configuration remoteConfiguration, Module module) throws DeploymentException {
        XmlObject[] specDestinations = AdminObjectRefBuilder.convert((XmlObject[])specDD.selectChildren(this.messageDestinationQNameSet), (NamespaceElementConverter)J2EE_CONVERTER, (SchemaType)MessageDestinationType.type);
        XmlObject[] gerDestinations = plan.selectChildren(GER_MESSAGE_DESTINATION_QNAME_SET);
        HashMap<String, GerMessageDestinationType> nameMap = new HashMap<String, GerMessageDestinationType>();
        for (int i = 0; i < gerDestinations.length; ++i) {
            GerMessageDestinationType destination = (GerMessageDestinationType)gerDestinations[i].copy().changeType(GerMessageDestinationType.type);
            String name = destination.getMessageDestinationName().trim();
            nameMap.put(name, destination);
            boolean found = false;
            for (int j = 0; j < specDestinations.length; ++j) {
                MessageDestinationType specDestination = (MessageDestinationType)specDestinations[j];
                if (!specDestination.getMessageDestinationName().getStringValue().trim().equals(name)) continue;
                found = true;
                break;
            }
            if (found) continue;
            throw new DeploymentException("No spec DD message-destination for " + name);
        }
        module.getRootEarContext().registerMessageDestionations(module.getName(), nameMap);
    }

    public void buildNaming(XmlObject specDD, XmlObject plan, Configuration localConfiguration, Configuration remoteConfiguration, Module module, Map componentContext) throws DeploymentException {
        XmlObject[] resourceEnvRefsUntyped = AdminObjectRefBuilder.convert((XmlObject[])specDD.selectChildren(this.adminOjbectRefQNameSet), (NamespaceElementConverter)J2EE_CONVERTER, (SchemaType)ResourceEnvRefType.type);
        ClassLoader cl = module.getEarContext().getClassLoader();
        XmlObject[] gerResourceEnvRefsUntyped = plan == null ? NO_REFS : plan.selectChildren(GER_ADMIN_OBJECT_REF_QNAME_SET);
        Map refMap = AdminObjectRefBuilder.mapResourceEnvRefs(gerResourceEnvRefsUntyped);
        for (int i = 0; i < resourceEnvRefsUntyped.length; ++i) {
            Class<?> iface;
            ResourceEnvRefType resourceEnvRef = (ResourceEnvRefType)resourceEnvRefsUntyped[i];
            String name = resourceEnvRef.getResourceEnvRefName().getStringValue().trim();
            String type = resourceEnvRef.getResourceEnvRefType().getStringValue().trim();
            try {
                iface = cl.loadClass(type);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("could not load class " + type, (Throwable)e);
            }
            GerResourceEnvRefType gerResourceEnvRef = (GerResourceEnvRefType)refMap.get(name);
            try {
                AbstractNameQuery containerId = AdminObjectRefBuilder.getAdminObjectContainerId(name, gerResourceEnvRef);
                Reference ref = this.buildAdminObjectReference(localConfiguration, containerId, iface);
                this.getJndiContextMap(componentContext).put("env/" + name, ref);
                continue;
            }
            catch (UnresolvedReferenceException e) {
                throw new DeploymentException("Unable to resolve resource env reference '" + name + "' (" + (e.isMultiple() ? "found multiple matching resources" : "no matching resources found") + ")");
            }
        }
        XmlObject[] messageDestinationRefsUntyped = AdminObjectRefBuilder.convert((XmlObject[])specDD.selectChildren(this.messageDestinationRefQNameSet), (NamespaceElementConverter)J2EE_CONVERTER, (SchemaType)MessageDestinationRefType.type);
        for (int i = 0; i < messageDestinationRefsUntyped.length; ++i) {
            Class<?> iface;
            MessageDestinationRefType messageDestinationRef = (MessageDestinationRefType)messageDestinationRefsUntyped[i];
            String name = AdminObjectRefBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)messageDestinationRef.getMessageDestinationRefName());
            String linkName = AdminObjectRefBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)messageDestinationRef.getMessageDestinationLink());
            String type = AdminObjectRefBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)messageDestinationRef.getMessageDestinationType());
            try {
                iface = cl.loadClass(type);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("could not load class " + type, (Throwable)e);
            }
            String moduleURI = null;
            Map messageDestinations = module.getRootEarContext().getMessageDestinations();
            GerMessageDestinationType destination = AdminObjectRefBuilder.getMessageDestination(linkName, messageDestinations);
            if (destination != null) {
                if (destination.isSetAdminObjectLink()) {
                    if (destination.isSetAdminObjectModule()) {
                        moduleURI = destination.getAdminObjectModule().trim();
                    }
                    linkName = destination.getAdminObjectLink().trim();
                }
            } else {
                int pos = linkName.indexOf(35);
                if (pos > -1) {
                    linkName = linkName.substring(pos + 1);
                }
            }
            AbstractNameQuery containerId = AdminObjectRefBuilder.buildAbstractNameQuery(null, moduleURI, (String)linkName, (String)"JCAAdminObject", (String)"ResourceAdapterModule");
            Reference ref = this.buildAdminObjectReference(localConfiguration, containerId, iface);
            this.getJndiContextMap(componentContext).put("env/" + name, ref);
        }
    }

    public static GerMessageDestinationType getMessageDestination(String messageDestinationLink, Map messageDestinations) throws DeploymentException {
        GerMessageDestinationType destination = null;
        int pos = messageDestinationLink.indexOf(35);
        if (pos > -1) {
            String targetModule = messageDestinationLink.substring(0, pos);
            Map destinations = (Map)messageDestinations.get(targetModule);
            if (destinations == null) {
                StringBuffer sb = new StringBuffer();
                Iterator mapIterator = messageDestinations.keySet().iterator();
                while (mapIterator.hasNext()) {
                    sb.append(mapIterator.next()).append("\n");
                }
                throw new DeploymentException("Unknown module " + targetModule + " when processing message destination " + messageDestinationLink + "\nKnown modules in deployable unit are:\n" + sb.toString());
            }
            messageDestinationLink = messageDestinationLink.substring(pos + 1);
            destination = (GerMessageDestinationType)destinations.get(messageDestinationLink);
        } else {
            Iterator iterator = messageDestinations.values().iterator();
            while (iterator.hasNext()) {
                Map destinations = (Map)iterator.next();
                GerMessageDestinationType destinationTest = (GerMessageDestinationType)destinations.get(messageDestinationLink);
                if (destinationTest == null) continue;
                if (destination != null) {
                    throw new DeploymentException("Duplicate message destination " + messageDestinationLink + " accessed from a message-destination-link without a module");
                }
                destination = destinationTest;
            }
        }
        return destination;
    }

    private Reference buildAdminObjectReference(Configuration localConfiguration, AbstractNameQuery containerId, Class iface) throws DeploymentException {
        try {
            localConfiguration.findGBean(containerId);
        }
        catch (GBeanNotFoundException e) {
            throw new DeploymentException("Can not resolve admin object ref " + containerId + " in configuration " + localConfiguration.getId());
        }
        return new ResourceReference(localConfiguration.getId(), containerId, iface);
    }

    private static AbstractNameQuery getAdminObjectContainerId(String name, GerResourceEnvRefType gerResourceEnvRef) {
        AbstractNameQuery containerId;
        if (gerResourceEnvRef == null) {
            containerId = AdminObjectRefBuilder.buildAbstractNameQuery(null, null, (String)name, (String)"JCAAdminObject", (String)"ResourceAdapterModule");
        } else if (gerResourceEnvRef.isSetMessageDestinationLink()) {
            containerId = AdminObjectRefBuilder.buildAbstractNameQuery(null, null, (String)gerResourceEnvRef.getMessageDestinationLink().trim(), (String)"JCAAdminObject", (String)"ResourceAdapterModule");
        } else if (gerResourceEnvRef.isSetAdminObjectLink()) {
            String moduleURI = null;
            if (gerResourceEnvRef.isSetAdminObjectModule()) {
                moduleURI = gerResourceEnvRef.getAdminObjectModule().trim();
            }
            containerId = AdminObjectRefBuilder.buildAbstractNameQuery(null, (String)moduleURI, (String)gerResourceEnvRef.getAdminObjectLink().trim(), (String)"JCAAdminObject", (String)"ResourceAdapterModule");
        } else {
            GerPatternType patternType = gerResourceEnvRef.getPattern();
            containerId = AdminObjectRefBuilder.buildAbstractNameQuery((GerPatternType)patternType, (String)"JCAAdminObject", (String)"ResourceAdapterModule", null);
        }
        return containerId;
    }

    private static Map mapResourceEnvRefs(XmlObject[] refs) {
        HashMap<String, GerResourceEnvRefType> refMap = new HashMap<String, GerResourceEnvRefType>();
        if (refs != null) {
            for (int i = 0; i < refs.length; ++i) {
                GerResourceEnvRefType ref = (GerResourceEnvRefType)refs[i].copy().changeType(GerResourceEnvRefType.type);
                refMap.put(ref.getRefName().trim(), ref);
            }
        }
        return refMap;
    }

    public QNameSet getSpecQNameSet() {
        return this.adminOjbectRefQNameSet;
    }

    public QNameSet getPlanQNameSet() {
        return GER_ADMIN_OBJECT_REF_QNAME_SET;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic((Class)AdminObjectRefBuilder.class, (String)"ModuleBuilder");
        infoBuilder.addAttribute("eeNamespaces", String;.class, true, true);
        infoBuilder.addAttribute("defaultEnvironment", Environment.class, true, true);
        infoBuilder.setConstructor(new String[]{"defaultEnvironment", "eeNamespaces"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

