/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.concurrent.impl.thread;

import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.concurrent.ManagedContextHandler;
import org.apache.geronimo.concurrent.ManagedContextHandlerChain;
import org.apache.geronimo.concurrent.impl.ContextHandlerUtils;
import org.apache.geronimo.concurrent.impl.GBeanBuilder;
import org.apache.geronimo.concurrent.impl.NotificationHelper;
import org.apache.geronimo.concurrent.impl.thread.GeronimoManagedThread;
import org.apache.geronimo.concurrent.impl.thread.GeronimoManagedThreadFactory;
import org.apache.geronimo.concurrent.impl.thread.GeronimoManagedThreadFactorySource;
import org.apache.geronimo.concurrent.impl.thread.ManagedThreadGBean;
import org.apache.geronimo.concurrent.impl.thread.StandaloneManagedThreadFactory;
import org.apache.geronimo.concurrent.naming.ModuleAwareResourceSource;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.management.EventProvider;
import org.apache.geronimo.management.ManagedThreadFactory;

public class ManagedThreadFactoryGBean
extends GBeanBuilder
implements GBeanLifecycle,
GeronimoManagedThreadFactorySource,
ModuleAwareResourceSource,
EventProvider,
ManagedThreadFactory {
    private static final Log LOG = LogFactory.getLog(ManagedThreadFactoryGBean.class);
    public static final GBeanInfo GBEAN_INFO;
    private AbstractName name;
    private GeronimoManagedThreadFactory threadFactory;
    private ManagedContextHandlerChain mainContextHandler;
    private String groupName;
    private boolean daemonThread;
    private int threadPriority;
    private long hungTaskThreshold;
    private long hungTaskMonitorFrequency;
    private NotificationHelper notificationHelper;

    public ManagedThreadFactoryGBean(Kernel kernel, ClassLoader classLoader, AbstractName name, String[] contextHandlerClasses, String groupName, int threadPriority, boolean daemonThread, long hungTaskThreshold, long hungTaskMonitorFrequency) {
        super(kernel, classLoader);
        this.name = name;
        this.notificationHelper = new NotificationHelper(kernel, name);
        List<ManagedContextHandler> handlers = ContextHandlerUtils.loadHandlers(classLoader, contextHandlerClasses);
        this.mainContextHandler = new ManagedContextHandlerChain(handlers);
        this.groupName = groupName;
        this.daemonThread = daemonThread;
        this.threadPriority = ManagedThreadFactoryGBean.getThreadPriority(threadPriority);
        this.hungTaskThreshold = hungTaskThreshold;
        this.hungTaskMonitorFrequency = ManagedThreadFactoryGBean.getHungTaskMonitorFrequency(hungTaskMonitorFrequency);
    }

    private static int getThreadPriority(int threadPriority) {
        return threadPriority <= 0 ? 5 : threadPriority;
    }

    private static long getHungTaskMonitorFrequency(long hungTaskMonitorFrequency) {
        return hungTaskMonitorFrequency <= 0L ? 60000L : hungTaskMonitorFrequency;
    }

    private void sendNotification(ManagedThreadGBean threadGBean) {
        if (this.notificationHelper.isNotificationSupported()) {
            Properties userData = new Properties();
            userData.setProperty("managedthread", threadGBean.getObjectName());
            this.notificationHelper.sendNotification("threadfactory.newthread", userData);
        }
    }

    protected void addThreadGBean(GeronimoManagedThread thread) {
        AbstractName aName = this.kernel.getNaming().createRootName(this.name.getArtifact(), thread.getName(), "ManagedThread");
        GBeanData threadData = new GBeanData(aName, ManagedThreadGBean.getGBeanInfo());
        try {
            this.addGBeanKernel(aName, threadData);
            ManagedThreadGBean threadGBean = (ManagedThreadGBean)this.kernel.getGBean(aName);
            threadGBean.verifyObjectName();
            threadGBean.setManagedThread(thread);
            thread.setGbean(threadGBean);
            this.sendNotification(threadGBean);
        }
        catch (Exception e) {
            LOG.warn((Object)"Failed to add thread gbean", (Throwable)e);
        }
    }

    protected void removeThreadGBean(GeronimoManagedThread thread) {
        AbstractName gbeanName = thread.getGbean().getName();
        this.removeGBeanKernel(gbeanName);
    }

    public synchronized GeronimoManagedThreadFactory getManagedThreadFactory() {
        if (this.threadFactory == null) {
            this.threadFactory = new GeronimoManagedThreadFactory(this);
            this.threadFactory.setThreadGroup(this.groupName);
            this.threadFactory.setDaemonThread(this.daemonThread);
            this.threadFactory.setThreadPriority(ManagedThreadFactoryGBean.getThreadPriority(this.threadPriority));
            this.threadFactory.setHungTaskThreshold(this.hungTaskThreshold);
            this.threadFactory.setHungTaskMonitorFrequency(ManagedThreadFactoryGBean.getHungTaskMonitorFrequency(this.hungTaskMonitorFrequency));
        }
        return this.threadFactory;
    }

    public Object $getResource(AbstractName moduleID) {
        GeronimoManagedThreadFactory threadFactory = this.getManagedThreadFactory();
        return new StandaloneManagedThreadFactory(threadFactory, (ManagedContextHandler)this.mainContextHandler, moduleID);
    }

    public void doStart() throws Exception {
    }

    public void doFail() {
        if (this.threadFactory != null) {
            this.threadFactory.shutdown();
        }
    }

    public void doStop() throws Exception {
        this.doFail();
    }

    public String[] getThreads() {
        if (this.threadFactory != null) {
            return this.threadFactory.getThreads();
        }
        return new String[0];
    }

    public String[] getHungTaskThreads() {
        if (this.threadFactory != null) {
            return this.threadFactory.getHungTaskThreads();
        }
        return new String[0];
    }

    public int getPriority() {
        return this.threadPriority;
    }

    public boolean getDaemon() {
        return this.daemonThread;
    }

    public long getHungTaskThreshold() {
        return this.hungTaskThreshold;
    }

    public long getHungTaskMonitorFrequency() {
        return this.hungTaskMonitorFrequency;
    }

    public AbstractName getName() {
        return this.name;
    }

    public String getObjectName() {
        return this.name.getObjectName().getCanonicalName();
    }

    public String[] getEventTypes() {
        return new String[]{"threadfactory.newthread"};
    }

    public boolean isEventProvider() {
        return true;
    }

    public boolean isStateManageable() {
        return true;
    }

    public boolean isStatisticsProvider() {
        return false;
    }

    protected void verifyObjectName() {
        GBeanBuilder.verifyObjectName(this.getObjectName(), "ManagedThreadFactory", "ManagedThreadFactory");
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic(ManagedThreadFactoryGBean.class, (String)"ManagedThreadFactory");
        infoFactory.addAttribute("classLoader", ClassLoader.class, false, false);
        infoFactory.addAttribute("abstractName", AbstractName.class, false, false);
        infoFactory.addAttribute("kernel", Kernel.class, false, false);
        infoFactory.addAttribute("contextHandlers", String[].class, true, false);
        infoFactory.addAttribute("groupName", String.class, true);
        infoFactory.addAttribute("priority", Integer.TYPE, true);
        infoFactory.addAttribute("daemon", Boolean.TYPE, true);
        infoFactory.addAttribute("hungTaskThreshold", Long.TYPE, true);
        infoFactory.addAttribute("hungTaskMonitorFrequency", Long.TYPE, true);
        infoFactory.addInterface(GeronimoManagedThreadFactorySource.class);
        infoFactory.addInterface(ManagedThreadFactory.class);
        infoFactory.setConstructor(new String[]{"kernel", "classLoader", "abstractName", "contextHandlers", "groupName", "priority", "daemon", "hungTaskThreshold", "hungTaskMonitorFrequency"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

