/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.concurrent.impl.executor;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.concurrent.impl.GBeanBuilder;
import org.apache.geronimo.concurrent.impl.executor.ServerManagedExecutorServiceGBean;
import org.apache.geronimo.concurrent.impl.thread.GeronimoManagedThreadFactorySource;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.kernel.Kernel;

public class ServerManagedExecutorServiceWrapperGBean
extends GBeanBuilder
implements GBeanLifecycle {
    private static final Log LOG = LogFactory.getLog(ServerManagedExecutorServiceWrapperGBean.class);
    public static final GBeanInfo GBEAN_INFO;
    private AbstractName name;
    private String[] contextHandlerClasses;
    private int minPoolSize;
    private int maxPoolSize;
    private long keepAliveTime;
    private int queueCapacity;
    private AbstractName executorServiceName;
    private ServerManagedExecutorServiceGBean executorServiceGBean;

    public ServerManagedExecutorServiceWrapperGBean(Kernel kernel, AbstractName name, ClassLoader classLoader, int minPoolSize, int maxPoolSize, long keepAliveTime, int queueCapacity, GeronimoManagedThreadFactorySource threadFactorySource, String[] contextHandlerClasses) {
        super(kernel, classLoader);
        this.name = name;
        this.contextHandlerClasses = contextHandlerClasses;
        this.minPoolSize = minPoolSize;
        this.maxPoolSize = maxPoolSize;
        this.keepAliveTime = keepAliveTime;
        this.queueCapacity = queueCapacity;
    }

    public void doStart() throws Exception {
        String threadName = (String)this.name.getName().get("name");
        this.executorServiceName = this.kernel.getNaming().createRootName(this.name.getArtifact(), threadName, "ManagedExecutorService");
        GBeanData executorServiceData = new GBeanData(this.executorServiceName, ServerManagedExecutorServiceGBean.getGBeanInfo());
        executorServiceData.setAttribute("contextHandlers", (Object)this.contextHandlerClasses);
        executorServiceData.setAttribute("minPoolSize", (Object)this.minPoolSize);
        executorServiceData.setAttribute("maxPoolSize", (Object)this.maxPoolSize);
        executorServiceData.setAttribute("keepAliveTime", (Object)this.keepAliveTime);
        executorServiceData.setAttribute("queueCapacity", (Object)this.queueCapacity);
        GBeanData wrapperData = this.kernel.getGBeanData(this.name);
        executorServiceData.setReferencePatterns("threadFactory", wrapperData.getReferencePatterns("threadFactory"));
        this.addGBeanKernel(this.executorServiceName, executorServiceData);
        this.executorServiceGBean = (ServerManagedExecutorServiceGBean)this.kernel.getGBean(this.executorServiceName);
        this.executorServiceGBean.verifyObjectName();
    }

    public void doFail() {
        try {
            this.doStop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void doStop() throws Exception {
        this.executorServiceGBean = null;
        if (this.executorServiceName != null) {
            this.removeGBeanKernel(this.executorServiceName);
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic(ServerManagedExecutorServiceWrapperGBean.class, (String)"ManagedThreadFactoryBuilder");
        infoFactory.addAttribute("classLoader", ClassLoader.class, false, false);
        infoFactory.addAttribute("abstractName", AbstractName.class, false, false);
        infoFactory.addAttribute("kernel", Kernel.class, false, false);
        infoFactory.addAttribute("minPoolSize", Integer.TYPE, true);
        infoFactory.addAttribute("maxPoolSize", Integer.TYPE, true);
        infoFactory.addAttribute("keepAliveTime", Long.TYPE, true);
        infoFactory.addAttribute("queueCapacity", Integer.TYPE, true);
        infoFactory.addAttribute("contextHandlers", String[].class, true);
        infoFactory.addReference("threadFactory", GeronimoManagedThreadFactorySource.class);
        infoFactory.setConstructor(new String[]{"kernel", "abstractName", "classLoader", "minPoolSize", "maxPoolSize", "keepAliveTime", "queueCapacity", "threadFactory", "contextHandlers"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

