/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.concurrent.builder;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.util.concurrent.ContextService;
import javax.util.concurrent.ManagedExecutorService;
import javax.util.concurrent.ManagedScheduledExecutorService;
import javax.util.concurrent.ManagedThreadFactory;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.common.UnresolvedReferenceException;
import org.apache.geronimo.concurrent.naming.ResourceReferenceFactory;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.NamingBuilder;
import org.apache.geronimo.j2ee.deployment.annotation.AnnotatedApp;
import org.apache.geronimo.j2ee.deployment.annotation.ResourceAnnotationHelper;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.naming.deployment.AbstractNamingBuilder;
import org.apache.geronimo.schema.NamespaceElementConverter;
import org.apache.geronimo.xbeans.geronimo.naming.GerPatternType;
import org.apache.geronimo.xbeans.geronimo.naming.GerResourceEnvRefDocument;
import org.apache.geronimo.xbeans.geronimo.naming.GerResourceEnvRefType;
import org.apache.geronimo.xbeans.javaee.DescriptionType;
import org.apache.geronimo.xbeans.javaee.FullyQualifiedClassType;
import org.apache.geronimo.xbeans.javaee.InjectionTargetType;
import org.apache.geronimo.xbeans.javaee.JndiNameType;
import org.apache.geronimo.xbeans.javaee.ResourceEnvRefType;
import org.apache.geronimo.xbeans.javaee.XsdStringType;
import org.apache.xbean.finder.ClassFinder;
import org.apache.xmlbeans.QNameSet;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceRefBuilder
extends AbstractNamingBuilder {
    private static final Log log = LogFactory.getLog(ResourceRefBuilder.class);
    private static final QName GER_MANAGED_OBJECT_REF_QNAME = GerResourceEnvRefDocument.type.getDocumentElementName();
    private static final QNameSet GER_MANAGED_OBJECT_REF_QNAME_SET = QNameSet.singleton((QName)GER_MANAGED_OBJECT_REF_QNAME);
    private final QNameSet resourceRefQNameSet;
    private final Kernel kernel;
    static NamingBuilder.Key<Map<String, GerResourceEnvRefType>> DEFAULT_MAPPINGS_KEY = new NamingBuilder.Key<Map<String, GerResourceEnvRefType>>(){

        public Map<String, GerResourceEnvRefType> get(Map context) {
            HashMap result = (HashMap)context.get(this);
            if (result == null) {
                result = new HashMap();
                context.put(this, result);
            }
            return result;
        }
    };
    public static final GBeanInfo GBEAN_INFO;

    public ResourceRefBuilder(Kernel kernel, Environment defaultEnvironment, String[] eeNamespaces) {
        super(defaultEnvironment);
        this.kernel = kernel;
        this.resourceRefQNameSet = ResourceRefBuilder.buildQNameSet((String[])eeNamespaces, (String)"resource-env-ref");
    }

    protected boolean willMergeEnvironment(XmlObject specDD, XmlObject plan) {
        return specDD.selectChildren(this.resourceRefQNameSet).length > 0;
    }

    public void buildNaming(XmlObject specDD, XmlObject plan, Module module, Map componentContext) throws DeploymentException {
        XmlObject[] gerResourceEnvRefsUntyped = plan == null ? NO_REFS : plan.selectChildren(GER_MANAGED_OBJECT_REF_QNAME_SET);
        Map<String, GerResourceEnvRefType> refMap = ResourceRefBuilder.mapResourceEnvRefs(gerResourceEnvRefsUntyped);
        if (module.getClassFinder() != null) {
            try {
                ManagedResourceRefProcessor processor = new ManagedResourceRefProcessor(refMap, module.getSharedContext());
                ResourceAnnotationHelper.processAnnotations((AnnotatedApp)module.getAnnotatedApp(), (ClassFinder)module.getClassFinder(), (ResourceAnnotationHelper.ResourceProcessor)processor);
            }
            catch (Exception e) {
                log.warn((Object)("Unable to process @Resource annotations for module " + module.getName()), (Throwable)e);
            }
        }
        Map defaultMappings = (Map)DEFAULT_MAPPINGS_KEY.get(module.getSharedContext());
        refMap.putAll(defaultMappings);
        List resourceEnvRefsUntyped = ResourceRefBuilder.convert((XmlObject[])specDD.selectChildren(this.resourceRefQNameSet), (NamespaceElementConverter)JEE_CONVERTER, ResourceEnvRefType.class, (SchemaType)ResourceEnvRefType.type);
        ClassLoader cl = module.getEarContext().getClassLoader();
        for (ResourceEnvRefType resourceEnvRef : resourceEnvRefsUntyped) {
            Class<?> iface;
            String name = ResourceRefBuilder.getStringValue((org.apache.geronimo.xbeans.javaee.String)resourceEnvRef.getResourceEnvRefName());
            String type = ResourceRefBuilder.getStringValue((org.apache.geronimo.xbeans.javaee.String)resourceEnvRef.getResourceEnvRefType());
            this.addInjections(name, resourceEnvRef.getInjectionTargetArray(), componentContext);
            try {
                iface = cl.loadClass(type);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("could not load class " + type, (Throwable)e);
            }
            GerResourceEnvRefType gerResourceEnvRef = refMap.remove(name);
            String j2eeType = null;
            if (iface != ContextService.class) {
                if (iface == ManagedThreadFactory.class) {
                    j2eeType = "ManagedThreadFactory";
                } else if (iface == ManagedExecutorService.class) {
                    j2eeType = "ManagedExecutorService";
                } else if (iface == ManagedScheduledExecutorService.class) {
                    j2eeType = "ManagedExecutorService";
                } else {
                    log.debug((Object)("Ignoring non-managed resource reference type: " + iface));
                    continue;
                }
            }
            try {
                AbstractNameQuery containerId = ResourceRefBuilder.getAdminObjectContainerId(name, j2eeType, gerResourceEnvRef);
                ResourceReferenceFactory ref = this.buildManagedObjectReference(module, containerId, iface);
                this.getJndiContextMap(componentContext).put("env/" + name, ref);
            }
            catch (UnresolvedReferenceException e) {
                throw new DeploymentException("Unable to resolve resource env reference '" + name + "' (" + (e.isMultiple() ? "found multiple matching resources" : "no matching resources found") + ")", (Throwable)e);
            }
        }
    }

    private ResourceReferenceFactory buildManagedObjectReference(Module module, AbstractNameQuery containerId, Class iface) throws DeploymentException {
        block3: {
            Configuration localConfiguration = module.getEarContext().getConfiguration();
            try {
                localConfiguration.findGBean(containerId);
            }
            catch (GBeanNotFoundException e) {
                Set results = this.kernel.listGBeans(containerId);
                if (results == null || results.isEmpty()) {
                    throw new DeploymentException("Cannot resolve managed object ref " + containerId);
                }
                if (results.size() <= 1) break block3;
                throw new DeploymentException("Managed object ref resolved to multiple results " + containerId);
            }
        }
        return new ResourceReferenceFactory(module.getConfigId(), containerId, iface, module.getModuleName());
    }

    private static AbstractNameQuery getAdminObjectContainerId(String name, String j2eeType, GerResourceEnvRefType gerResourceEnvRef) {
        AbstractNameQuery containerId;
        if (gerResourceEnvRef == null) {
            containerId = ResourceRefBuilder.buildAbstractNameQuery(null, null, (String)name, (String)j2eeType, null);
        } else {
            GerPatternType patternType = gerResourceEnvRef.getPattern();
            containerId = ResourceRefBuilder.buildAbstractNameQuery((GerPatternType)patternType, (String)j2eeType, null, null);
        }
        return containerId;
    }

    private static Map<String, GerResourceEnvRefType> mapResourceEnvRefs(XmlObject[] refs) {
        HashMap<String, GerResourceEnvRefType> refMap = new HashMap<String, GerResourceEnvRefType>();
        if (refs != null) {
            for (XmlObject ref1 : refs) {
                GerResourceEnvRefType ref = (GerResourceEnvRefType)ref1.copy().changeType(GerResourceEnvRefType.type);
                refMap.put(ref.getRefName().trim(), ref);
            }
        }
        return refMap;
    }

    public int getPriority() {
        return 45;
    }

    public QNameSet getSpecQNameSet() {
        return QNameSet.EMPTY;
    }

    public QNameSet getPlanQNameSet() {
        return QNameSet.EMPTY;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic(ResourceRefBuilder.class, (String)"ModuleBuilder");
        infoBuilder.addAttribute("kernel", Kernel.class, false, false);
        infoBuilder.addAttribute("eeNamespaces", String[].class, true, true);
        infoBuilder.addAttribute("defaultEnvironment", Environment.class, true, true);
        infoBuilder.setConstructor(new String[]{"kernel", "defaultEnvironment", "eeNamespaces"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ManagedResourceRefProcessor
    extends ResourceAnnotationHelper.ResourceProcessor {
        private Map<String, GerResourceEnvRefType> refMap;
        private Map sharedContext;

        public ManagedResourceRefProcessor(Map<String, GerResourceEnvRefType> refMap, Map sharedContext) {
            this.refMap = refMap;
            this.sharedContext = sharedContext;
        }

        private static String getDefaultServiceMapping(String resourceType) {
            if (resourceType.equals(ContextService.class.getName())) {
                return "DefaultContextService";
            }
            if (resourceType.equals(ManagedThreadFactory.class.getName())) {
                return "DefaultManagedThreadFactory";
            }
            if (resourceType.equals(ManagedExecutorService.class.getName())) {
                return "DefaultManagedExecutorService";
            }
            if (resourceType.equals(ManagedScheduledExecutorService.class.getName())) {
                return "DefaultManagedScheduledExecutorService";
            }
            throw new IllegalArgumentException("Invalid resource type: " + resourceType);
        }

        public boolean processResource(AnnotatedApp annotatedApp, Resource annotation, Class cls, Method method, Field field) throws DeploymentException {
            String resourceName = ManagedResourceRefProcessor.getResourceName((Resource)annotation, (Method)method, (Field)field);
            String resourceType = ManagedResourceRefProcessor.getResourceType((Resource)annotation, (Method)method, (Field)field);
            if (resourceType.equals(ContextService.class.getName()) || resourceType.equals(ManagedThreadFactory.class.getName()) || resourceType.equals(ManagedExecutorService.class.getName()) || resourceType.equals(ManagedScheduledExecutorService.class.getName())) {
                InjectionTargetType[] targets;
                ResourceEnvRefType[] ResourceEnvRefs;
                ResourceEnvRefType resourceEnvRef = null;
                for (ResourceEnvRefType resourceEnvRefType : ResourceEnvRefs = annotatedApp.getResourceEnvRefArray()) {
                    if (!resourceEnvRefType.getResourceEnvRefName().getStringValue().trim().equals(resourceName)) continue;
                    resourceEnvRef = resourceEnvRefType;
                    break;
                }
                if (resourceEnvRef == null) {
                    resourceEnvRef = annotatedApp.addNewResourceEnvRef();
                    JndiNameType resourceEnvRefName = resourceEnvRef.addNewResourceEnvRefName();
                    resourceEnvRefName.setStringValue(resourceName);
                    resourceEnvRef.setResourceEnvRefName(resourceEnvRefName);
                }
                if (!resourceEnvRef.isSetResourceEnvRefType() && !resourceType.equals("")) {
                    FullyQualifiedClassType qualifiedClass = resourceEnvRef.addNewResourceEnvRefType();
                    qualifiedClass.setStringValue(resourceType);
                    resourceEnvRef.setResourceEnvRefType(qualifiedClass);
                }
                if ((resourceEnvRef.getDescriptionArray() == null || resourceEnvRef.getDescriptionArray().length == 0) && annotation.description().trim().length() > 0) {
                    DescriptionType description = resourceEnvRef.addNewDescription();
                    String descriptionAnnotation = annotation.description();
                    description.setStringValue(descriptionAnnotation);
                }
                if (!resourceEnvRef.isSetMappedName() && annotation.mappedName().trim().length() > 0) {
                    XsdStringType mappedName = resourceEnvRef.addNewMappedName();
                    mappedName.setStringValue(annotation.mappedName().trim());
                    resourceEnvRef.setMappedName(mappedName);
                }
                if (!(method == null && field == null || ManagedResourceRefProcessor.hasTarget((Method)method, (Field)field, (InjectionTargetType[])(targets = resourceEnvRef.getInjectionTargetArray())))) {
                    ManagedResourceRefProcessor.configureInjectionTarget((InjectionTargetType)resourceEnvRef.addNewInjectionTarget(), (Method)method, (Field)field);
                }
                if (annotation.name().trim().length() == 0 && !this.refMap.containsKey(resourceName)) {
                    GerResourceEnvRefType gerResourceEnvRefType = GerResourceEnvRefType.Factory.newInstance();
                    gerResourceEnvRefType.setRefName(resourceName);
                    GerPatternType patternType = gerResourceEnvRefType.addNewPattern();
                    patternType.setName(ManagedResourceRefProcessor.getDefaultServiceMapping(resourceType));
                    ((Map)DEFAULT_MAPPINGS_KEY.get(this.sharedContext)).put(resourceName, gerResourceEnvRefType);
                }
            }
            return true;
        }
    }
}

