/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.clustering.wadi;

import org.apache.catalina.tribes.membership.StaticMember;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamReference;

public class WadiStaticMember
implements GBeanLifecycle {
    private static final Log log = LogFactory.getLog(WadiStaticMember.class);
    private final String classname;
    private final int port;
    private final int securePort;
    private final String host;
    private final String domain;
    private final byte[] uniqueId;
    private final WadiStaticMember nextWadiStaticMember;
    private final StaticMember staticMember;
    public static final String GBEAN_ATTR_CLASSNAME = "className";
    public static final String GBEAN_ATTR_PORT = "port";
    public static final String GBEAN_ATTR_SECURE_PORT = "securePort";
    public static final String GBEAN_ATTR_HOST = "host";
    public static final String GBEAN_ATTR_DOMAIN = "domain";
    public static final String GBEAN_ATTR_UNIQUE_ID = "UniqueId";
    public static final String GBEAN_REF_NEXT_STATIC_MEMBER = "nextWadiStaticMember";

    public WadiStaticMember(@ParamAttribute(name="className") String classname, @ParamAttribute(name="port") int port, @ParamAttribute(name="securePort") int securePort, @ParamAttribute(name="host") String host, @ParamAttribute(name="domain") String domain, @ParamAttribute(name="UniqueId") byte[] uniqueId, @ParamReference(name="nextWadiStaticMember") WadiStaticMember nextWadiStaticMember) throws Exception {
        if (classname == null) {
            throw new IllegalArgumentException("classname is required");
        }
        if (host == null) {
            throw new IllegalArgumentException("host is required");
        }
        if (domain == null) {
            throw new IllegalArgumentException("domain is required");
        }
        if (uniqueId == null) {
            throw new IllegalArgumentException("UniqueId is required");
        }
        this.classname = classname;
        this.port = port;
        this.securePort = securePort;
        this.host = host;
        this.domain = domain;
        this.uniqueId = uniqueId;
        this.nextWadiStaticMember = nextWadiStaticMember;
        this.staticMember = (StaticMember)Class.forName(classname).newInstance();
        this.staticMember.setPort(port);
        this.staticMember.setSecurePort(securePort);
        this.staticMember.setHost(host);
        this.staticMember.setDomain(domain);
        this.staticMember.setUniqueId(uniqueId);
    }

    public void doStart() throws Exception {
        log.debug((Object)"Started WadiStaticMember");
    }

    public void doFail() {
        log.debug((Object)"Failed to create WadiStaticMember");
    }

    public void doStop() throws Exception {
        log.debug((Object)"Stopped WadiStaticMember");
    }

    public Object getNextStaticMember() {
        return this.nextWadiStaticMember;
    }

    public Object getStaticMember() {
        return this.staticMember;
    }
}

