/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.cli;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;

public class PrintHelper {
    public static final int DEFAULT_WIDTH = 76;
    public static final int DEFAULT_LEFT_PAD = 1;
    public static final int DEFAULT_DESC_PAD = 3;
    public static final String DEFAULT_SYNTAX_PREFIX = "usage: ";
    public static final String DEFAULT_OPT_PREFIX = "-";
    public static final String DEFAULT_LONG_OPT_PREFIX = "--";
    public static final String DEFAULT_ARG_NAME = "arg";
    private final OutputStream outputStream;
    public int defaultWidth;
    public int defaultLeftPad;
    public int defaultDescPad;
    public String defaultSyntaxPrefix;
    public String defaultNewLine;
    public String defaultOptPrefix;
    public String defaultLongOptPrefix;
    public String defaultArgName;

    public static String reformat(String source, int indent, int endCol) {
        if (endCol - indent < 10) {
            throw new IllegalArgumentException("This is ridiculous!");
        }
        StringBuffer buf = new StringBuffer((int)((double)source.length() * 1.1));
        String prefix = indent == 0 ? "" : PrintHelper.buildIndent(indent);
        try {
            String line;
            BufferedReader in = new BufferedReader(new StringReader(source));
            block2: while ((line = in.readLine()) != null) {
                if (buf.length() > 0) {
                    buf.append('\n');
                }
                while (line.length() > 0) {
                    line = prefix + line;
                    if (line.length() > endCol) {
                        int pos = line.lastIndexOf(32, endCol);
                        if (pos < indent && (pos = line.indexOf(32, endCol)) < indent) {
                            pos = line.length();
                        }
                        buf.append(line.substring(0, pos)).append('\n');
                        if (pos >= line.length() - 1) continue block2;
                        line = line.substring(pos + 1);
                        continue;
                    }
                    buf.append(line).append("\n");
                    continue block2;
                }
            }
        }
        catch (IOException e) {
            throw new AssertionError((Object)"This should be impossible");
        }
        return buf.toString();
    }

    private static String buildIndent(int indent) {
        StringBuffer buf = new StringBuffer(indent);
        for (int i = 0; i < indent; ++i) {
            buf.append(' ');
        }
        return buf.toString();
    }

    public PrintHelper(OutputStream outputStream) {
        if (null == outputStream) {
            throw new IllegalArgumentException("outputStream is required");
        }
        this.outputStream = outputStream;
        this.defaultWidth = 76;
        this.defaultLeftPad = 1;
        this.defaultDescPad = 3;
        this.defaultSyntaxPrefix = DEFAULT_SYNTAX_PREFIX;
        this.defaultNewLine = System.getProperty("line.separator");
        this.defaultOptPrefix = DEFAULT_OPT_PREFIX;
        this.defaultLongOptPrefix = DEFAULT_LONG_OPT_PREFIX;
        this.defaultArgName = DEFAULT_ARG_NAME;
    }

    public void printHelp(String cmdLineSyntax, String header, Options options, String footer, boolean autoUsage) {
        this.printHelp(this.defaultWidth, cmdLineSyntax, header, options, footer, autoUsage);
    }

    public void printHelp(int width, String cmdLineSyntax, String header, Options options, String footer, boolean autoUsage) {
        PrintWriter pw = new PrintWriter(this.outputStream);
        this.printHelp(pw, width, cmdLineSyntax, header, options, this.defaultLeftPad, this.defaultDescPad, footer, autoUsage);
        pw.flush();
    }

    public void printHelp(PrintWriter pw, int width, String cmdLineSyntax, String header, Options options, int leftPad, int descPad, String footer, boolean autoUsage) throws IllegalArgumentException {
        if (cmdLineSyntax == null || cmdLineSyntax.length() == 0) {
            throw new IllegalArgumentException("cmdLineSyntax not provided");
        }
        if (autoUsage) {
            this.printUsage(pw, width, cmdLineSyntax, options);
        } else {
            this.printUsage(pw, width, cmdLineSyntax);
        }
        if (header != null && header.trim().length() > 0) {
            this.printWrapped(pw, width, header);
        }
        this.printOptions(pw, width, options, leftPad, descPad);
        if (footer != null && footer.trim().length() > 0) {
            this.printWrapped(pw, width, footer);
        }
    }

    public void printUsage(PrintWriter pw, int width, String app, Options options) {
        ArrayList<OptionGroup> list = new ArrayList<OptionGroup>();
        StringBuffer optionsBuff = new StringBuffer();
        for (Option option : options.getOptions()) {
            OptionGroup group = options.getOptionGroup(option);
            if (group != null && !list.contains(group)) {
                list.add(group);
                Collection names = group.getNames();
                optionsBuff.append("[");
                Iterator iter = names.iterator();
                while (iter.hasNext()) {
                    optionsBuff.append(iter.next());
                    if (!iter.hasNext()) continue;
                    optionsBuff.append("|");
                }
                optionsBuff.append("] ");
                continue;
            }
            if (group != null) continue;
            if (!option.isRequired()) {
                optionsBuff.append("[");
            }
            if (!" ".equals(option.getOpt())) {
                optionsBuff.append(DEFAULT_OPT_PREFIX).append(option.getOpt());
            } else {
                optionsBuff.append(DEFAULT_LONG_OPT_PREFIX).append(option.getLongOpt());
            }
            if (option.hasArg()) {
                optionsBuff.append(" ");
            }
            if (option.hasArg()) {
                optionsBuff.append(option.getArgName());
            }
            if (!option.isRequired()) {
                optionsBuff.append("]");
            }
            optionsBuff.append(" ");
        }
        app = app.replace("$options", optionsBuff.toString());
        this.printWrapped(pw, width, app.indexOf(32) + 1, app);
    }

    public void printUsage(PrintWriter pw, int width, String cmdLineSyntax) {
        int argPos = cmdLineSyntax.indexOf(32) + 1;
        this.printWrapped(pw, width, this.defaultSyntaxPrefix.length() + argPos, this.defaultSyntaxPrefix + cmdLineSyntax);
    }

    public void printOptions(PrintWriter pw, int width, Options options, int leftPad, int descPad) {
        StringBuffer sb = new StringBuffer();
        this.renderOptions(sb, width, options, leftPad, descPad, true);
        pw.println(sb.toString());
    }

    public void printOptions(PrintWriter pw, Options options) {
        StringBuffer sb = new StringBuffer();
        this.renderOptions(sb, this.defaultWidth, options, this.defaultLeftPad, this.defaultDescPad, true);
        pw.println(sb.toString());
    }

    public void printOptionsNoDesc(PrintWriter pw, Options options) {
        StringBuffer sb = new StringBuffer();
        this.renderOptions(sb, this.defaultWidth, options, this.defaultLeftPad, this.defaultDescPad, false);
        pw.println(sb.toString());
    }

    public void printWrapped(PrintWriter pw, int width, String text) {
        this.printWrapped(pw, width, 0, text);
    }

    public void printWrapped(PrintWriter pw, int width, int nextLineTabStop, String text) {
        StringBuffer sb = new StringBuffer(text.length());
        this.renderWrappedText(sb, width, nextLineTabStop, text);
        pw.println(sb.toString());
    }

    protected StringBuffer renderOptions(StringBuffer sb, int width, Options options, int leftPad, int descPad, boolean displayDesc) {
        StringBuffer optBuf;
        String lpad = this.createPadding(leftPad);
        String dpad = this.createPadding(descPad);
        int max = 0;
        ArrayList<StringBuffer> prefixList = new ArrayList<StringBuffer>();
        ArrayList optList = new ArrayList(options.getOptions());
        Collections.sort(optList, new StringBufferComparator());
        for (Option option : optList) {
            optBuf = new StringBuffer(8);
            if (option.getOpt().equals(" ")) {
                optBuf.append(lpad).append("   " + this.defaultLongOptPrefix).append(option.getLongOpt());
            } else {
                optBuf.append(lpad).append(this.defaultOptPrefix).append(option.getOpt());
                if (option.hasLongOpt()) {
                    optBuf.append(',').append(this.defaultLongOptPrefix).append(option.getLongOpt());
                }
            }
            if (option.hasArg()) {
                if (option.hasArgName()) {
                    optBuf.append(" <").append(option.getArgName()).append('>');
                } else {
                    optBuf.append(' ');
                }
            }
            prefixList.add(optBuf);
            max = optBuf.length() > max ? optBuf.length() : max;
        }
        int x = 0;
        Iterator i = optList.iterator();
        while (i.hasNext()) {
            Option option;
            option = (Option)i.next();
            if ((optBuf = new StringBuffer(prefixList.get(x++).toString())).length() < max) {
                optBuf.append(this.createPadding(max - optBuf.length()));
            }
            optBuf.append(dpad);
            if (displayDesc) {
                optBuf.append(option.getDescription());
            }
            int nextLineTabStop = max + descPad;
            this.renderWrappedText(sb, width, nextLineTabStop, optBuf.toString());
            if (!i.hasNext()) continue;
            sb.append(this.defaultNewLine);
            if (!displayDesc) continue;
            sb.append(this.defaultNewLine);
        }
        return sb;
    }

    protected StringBuffer renderWrappedText(StringBuffer sb, int width, int nextLineTabStop, String text) {
        int pos = this.findWrapPos(text, width, 0);
        if (pos == -1) {
            sb.append(this.rtrim(text));
            return sb;
        }
        sb.append(this.rtrim(text.substring(0, pos))).append(this.defaultNewLine);
        String padding = this.createPadding(nextLineTabStop);
        while (true) {
            if ((pos = this.findWrapPos(text = padding + text.substring(pos).trim(), width, 0)) == -1) {
                sb.append(text);
                return sb;
            }
            sb.append(this.rtrim(text.substring(0, pos))).append(this.defaultNewLine);
        }
    }

    protected int findWrapPos(String text, int width, int startPos) {
        char c;
        int pos = -1;
        pos = text.indexOf(10, startPos);
        if (pos != -1 && pos <= width || (pos = text.indexOf(9, startPos)) != -1 && pos <= width) {
            return pos;
        }
        if (startPos + width >= text.length()) {
            return -1;
        }
        for (pos = startPos + width; pos >= startPos && (c = text.charAt(pos)) != ' ' && c != '\n' && c != '\r'; --pos) {
        }
        if (pos > startPos) {
            return pos;
        }
        for (pos = startPos + width; pos <= text.length() && (c = text.charAt(pos)) != ' ' && c != '\n' && c != '\r'; ++pos) {
        }
        return pos == text.length() ? -1 : pos;
    }

    protected String createPadding(int len) {
        StringBuffer sb = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            sb.append(' ');
        }
        return sb.toString();
    }

    protected String rtrim(String s) {
        int pos;
        if (s == null || s.length() == 0) {
            return s;
        }
        for (pos = s.length(); pos >= 0 && Character.isWhitespace(s.charAt(pos - 1)); --pos) {
        }
        return s.substring(0, pos);
    }

    private static class StringBufferComparator
    implements Comparator {
        private StringBufferComparator() {
        }

        public int compare(Object o1, Object o2) {
            String str1 = this.stripPrefix(o1.toString());
            String str2 = this.stripPrefix(o2.toString());
            return str1.compareTo(str2);
        }

        private String stripPrefix(String strOption) {
            int iStartIndex = strOption.lastIndexOf(45);
            if (iStartIndex == -1) {
                iStartIndex = 0;
            }
            return strOption.substring(iStartIndex);
        }
    }
}

