/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.axis2.feature;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.geronimo.axis2.feature.AddressingFeatureConfigurator;
import org.apache.geronimo.axis2.feature.MTOMFeatureConfigurator;
import org.apache.geronimo.axis2.feature.RespectBindingFeatureConfigurator;
import org.apache.geronimo.axis2.feature.WebServiceFeatureConfigurator;
import org.apache.geronimo.jaxws.feature.AddressingFeatureInfo;
import org.apache.geronimo.jaxws.feature.MTOMFeatureInfo;
import org.apache.geronimo.jaxws.feature.RespectBindingFeatureInfo;
import org.apache.geronimo.jaxws.feature.WebServiceFeatureInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerFeaturesConfigurator
implements WebServiceFeatureConfigurator<WebServiceFeatureInfo> {
    private static final Logger logger = LoggerFactory.getLogger(ServerFeaturesConfigurator.class);
    private Map<String, WebServiceFeatureConfigurator> classNameConfiguratorMap = new ConcurrentHashMap<String, WebServiceFeatureConfigurator>();

    public ServerFeaturesConfigurator() {
        this.classNameConfiguratorMap.put(AddressingFeatureInfo.class.getName(), new AddressingFeatureConfigurator());
        this.classNameConfiguratorMap.put(MTOMFeatureInfo.class.getName(), new MTOMFeatureConfigurator());
        this.classNameConfiguratorMap.put(RespectBindingFeatureInfo.class.getName(), new RespectBindingFeatureConfigurator());
    }

    @Override
    public void configure(EndpointDescription endpointDescription, WebServiceFeatureInfo webServiceFeatureInfo) {
        WebServiceFeatureConfigurator configurator = this.classNameConfiguratorMap.get(webServiceFeatureInfo.getClass().getName());
        if (configurator == null) {
            logger.warn("No web service configurator supports the target webServiceFeatureInfo" + webServiceFeatureInfo);
            return;
        }
        configurator.configure(endpointDescription, webServiceFeatureInfo);
    }

    public void registerWebServiceFeatureConfigurator(String className, WebServiceFeatureConfigurator configurator) {
        this.classNameConfiguratorMap.put(className, configurator);
    }

    public WebServiceFeatureConfigurator unregisterWebServiceFeatureConfigurator(String className) {
        return this.classNameConfiguratorMap.remove(className);
    }
}

