/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.axis2.client;

import java.util.Hashtable;
import java.util.Map;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.jaxws.ClientConfigurationFactory;
import org.apache.axis2.jaxws.util.ClassLoaderUtils;
import org.apache.axis2.jaxws.util.Constants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Axis2ClientConfigurationFactory
extends ClientConfigurationFactory {
    private static final Log LOG = LogFactory.getLog(Axis2ClientConfigurationFactory.class);
    private Map<ClassLoader, ConfigurationContext> contextCache = new Hashtable<ClassLoader, ConfigurationContext>();
    private boolean reuseConfigurationContext;

    public Axis2ClientConfigurationFactory(boolean reuse) {
        this.reuseConfigurationContext = reuse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurationContext getClientConfigurationContext() {
        ClassLoader cl = ClassLoaderUtils.getContextClassLoader();
        if (cl == null) {
            if (this.reuseConfigurationContext) {
                cl = ClientConfigurationFactory.class.getClassLoader();
            } else {
                return this.createConfigurationContext();
            }
        }
        ClassLoader classLoader = cl;
        synchronized (classLoader) {
            return this.getConfigurationContext(cl);
        }
    }

    private ConfigurationContext getConfigurationContext(ClassLoader cl) {
        ConfigurationContext context = this.contextCache.get(cl);
        if (context == null) {
            context = this.createConfigurationContext();
            this.contextCache.put(cl, context);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Created new configuration context " + context + "  for " + cl));
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Configuration context " + context + " reused for " + cl));
        }
        return context;
    }

    private ConfigurationContext removeConfigurationContext(ClassLoader cl) {
        return this.contextCache.remove(cl);
    }

    public void clearCache() {
        this.contextCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurationContext clearCache(ClassLoader cl) {
        ConfigurationContext context = null;
        if (cl != null) {
            ClassLoader classLoader = cl;
            synchronized (classLoader) {
                context = this.removeConfigurationContext(cl);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Removed configuration context " + context + " for " + cl));
            }
        }
        return context;
    }

    private ConfigurationContext createConfigurationContext() {
        String repoPath = System.getProperty(Constants.AXIS2_REPO_PATH);
        String axisConfigPath = System.getProperty(Constants.AXIS2_CONFIG_PATH);
        try {
            return ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)repoPath, (String)axisConfigPath);
        }
        catch (AxisFault e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

