/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.axis.client;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.rmi.Remote;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.encoding.DeserializerFactory;
import javax.xml.rpc.encoding.SerializerFactory;
import javax.xml.rpc.encoding.TypeMapping;
import javax.xml.rpc.handler.HandlerChain;
import net.sf.cglib.core.Signature;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import net.sf.cglib.proxy.NoOp;
import net.sf.cglib.reflect.FastClass;
import net.sf.cglib.reflect.FastConstructor;
import org.apache.axis.AxisEngine;
import org.apache.axis.Constants;
import org.apache.axis.client.Service;
import org.apache.axis.constants.Use;
import org.apache.axis.description.TypeDesc;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.encoding.ser.SimpleDeserializerFactory;
import org.apache.axis.encoding.ser.SimpleSerializerFactory;
import org.apache.axis.handlers.HandlerInfoChainFactory;
import org.apache.geronimo.axis.client.GenericServiceEndpoint;
import org.apache.geronimo.axis.client.GenericServiceEndpointWrapper;
import org.apache.geronimo.axis.client.NoOverrideCallbackFilter;
import org.apache.geronimo.axis.client.OperationInfo;
import org.apache.geronimo.axis.client.SEIFactory;
import org.apache.geronimo.axis.client.SerializableNoOp;
import org.apache.geronimo.axis.client.ServiceEndpointMethodInterceptor;
import org.apache.geronimo.axis.client.ServiceImpl;
import org.apache.geronimo.axis.client.TypeInfo;

public class SEIFactoryImpl
implements SEIFactory,
Serializable {
    private final QName serviceName;
    private final QName portQName;
    private final String serviceEndpointClassName;
    private final OperationInfo[] operationInfos;
    private transient FastConstructor constructor;
    private Object serviceImpl;
    private final List typeInfo;
    private final URL location;
    private final List handlerInfos;
    private final String credentialsName;
    private transient HandlerInfoChainFactory handlerInfoChainFactory;
    private transient OperationInfo[] sortedOperationInfos;
    private Class serviceEndpointClass;

    public SEIFactoryImpl(QName serviceName, String portName, String serviceEndpointClassName, OperationInfo[] operationInfos, List typeInfo, URL location, List handlerInfos, String credentialsName) {
        this.serviceName = serviceName;
        this.portQName = new QName("", portName);
        this.serviceEndpointClassName = serviceEndpointClassName;
        this.operationInfos = operationInfos;
        this.typeInfo = typeInfo;
        this.location = location;
        this.handlerInfos = handlerInfos;
        this.credentialsName = credentialsName;
    }

    void initialize(Object serviceImpl, ClassLoader classLoader) throws ClassNotFoundException {
        this.serviceImpl = serviceImpl;
        Class<?> serviceEndpointBaseClass = classLoader.loadClass(this.serviceEndpointClassName);
        this.serviceEndpointClass = this.enhanceServiceEndpointInterface(serviceEndpointBaseClass, classLoader);
        Class[] constructorTypes = new Class[]{classLoader.loadClass(GenericServiceEndpoint.class.getName())};
        this.constructor = FastClass.create((Class)this.serviceEndpointClass).getConstructor(constructorTypes);
        this.handlerInfoChainFactory = new HandlerInfoChainFactory(this.handlerInfos);
        this.sortedOperationInfos = new OperationInfo[FastClass.create((Class)this.serviceEndpointClass).getMaxIndex() + 1];
        String encodingStyle = "";
        for (int i = 0; i < this.operationInfos.length; ++i) {
            OperationInfo operationInfo = this.operationInfos[i];
            Signature signature = operationInfo.getSignature();
            MethodProxy methodProxy = MethodProxy.find((Class)this.serviceEndpointClass, (Signature)signature);
            if (methodProxy == null) {
                throw new RuntimeException("No method proxy for operationInfo " + signature);
            }
            int index = methodProxy.getSuperIndex();
            this.sortedOperationInfos[index] = operationInfo;
            if (operationInfo.getOperationDesc().getUse() != Use.ENCODED) continue;
            encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
        }
        Service service = ((ServiceImpl)serviceImpl).getService();
        AxisEngine axisEngine = service.getEngine();
        TypeMappingRegistry typeMappingRegistry = axisEngine.getTypeMappingRegistry();
        org.apache.axis.encoding.TypeMapping typeMapping = typeMappingRegistry.getOrMakeTypeMapping(encodingStyle);
        typeMapping.register(BigInteger.class, Constants.XSD_UNSIGNEDLONG, (SerializerFactory)new SimpleSerializerFactory(BigInteger.class, Constants.XSD_UNSIGNEDLONG), (DeserializerFactory)new SimpleDeserializerFactory(BigInteger.class, Constants.XSD_UNSIGNEDLONG));
        typeMapping.register(URI.class, Constants.XSD_ANYURI, (SerializerFactory)new SimpleSerializerFactory(URI.class, Constants.XSD_ANYURI), (DeserializerFactory)new SimpleDeserializerFactory(URI.class, Constants.XSD_ANYURI));
        for (TypeInfo info : this.typeInfo) {
            TypeDesc.registerTypeDescForClass((Class)info.getClazz(), (TypeDesc)info.buildTypeDesc());
        }
        TypeInfo.register(this.typeInfo, (TypeMapping)typeMapping);
    }

    private Class enhanceServiceEndpointInterface(Class serviceEndpointInterface, ClassLoader classLoader) {
        Enhancer enhancer = new Enhancer();
        enhancer.setClassLoader(classLoader);
        enhancer.setSuperclass(GenericServiceEndpointWrapper.class);
        enhancer.setInterfaces(new Class[]{serviceEndpointInterface});
        enhancer.setCallbackFilter((CallbackFilter)new NoOverrideCallbackFilter(GenericServiceEndpointWrapper.class));
        enhancer.setCallbackTypes(new Class[]{NoOp.class, MethodInterceptor.class});
        enhancer.setUseFactory(false);
        enhancer.setUseCache(false);
        return enhancer.createClass();
    }

    @Override
    public Remote createServiceEndpoint() throws ServiceException {
        Service service = ((ServiceImpl)this.serviceImpl).getService();
        GenericServiceEndpoint serviceEndpoint = new GenericServiceEndpoint(this.portQName, service, this.location);
        ServiceEndpointMethodInterceptor callback = new ServiceEndpointMethodInterceptor(serviceEndpoint, this.sortedOperationInfos, this.credentialsName);
        Callback[] callbacks = new Callback[]{SerializableNoOp.INSTANCE, callback};
        Enhancer.registerCallbacks((Class)this.serviceEndpointClass, (Callback[])callbacks);
        try {
            return (Remote)this.constructor.newInstance(new Object[]{serviceEndpoint});
        }
        catch (InvocationTargetException e) {
            throw (ServiceException)new ServiceException("Could not construct service instance", e.getTargetException()).initCause((Throwable)e);
        }
    }

    @Override
    public HandlerChain createHandlerChain() {
        return this.handlerInfoChainFactory.createHandlerChain();
    }

    @Override
    public OperationInfo[] getOperationInfos() {
        return this.operationInfos;
    }

    @Override
    public QName getPortQName() {
        return this.portQName;
    }

    @Override
    public QName getServiceName() {
        return this.serviceName;
    }

    @Override
    public URL getWSDLDocumentLocation() {
        try {
            return new URL(this.location.toExternalForm() + "?wsdl");
        }
        catch (MalformedURLException e) {
            return null;
        }
    }
}

