/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.aries;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.instrument.ClassDefinition;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.geronimo.aries.ApplicationGBean;
import org.apache.geronimo.aries.ResolverErrorAnalyzer;
import org.apache.geronimo.kernel.util.FileUtils;
import org.apache.geronimo.kernel.util.IOUtils;
import org.apache.geronimo.kernel.util.JarUtils;
import org.apache.geronimo.transformer.TransformerAgent;
import org.apache.xbean.osgi.bundle.util.BundleUtils;
import org.apache.xbean.osgi.bundle.util.HeaderParser;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.wiring.FrameworkWiring;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationUpdateHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationUpdateHelper.class);
    private static final long bundleRefreshTimeout = ApplicationUpdateHelper.getBundleRefreshTimeout();
    private final ApplicationGBean applicationGBean;

    public ApplicationUpdateHelper(ApplicationGBean applicationGBean) {
        this.applicationGBean = applicationGBean;
    }

    private static long getBundleRefreshTimeout() {
        String property = System.getProperty("org.apache.geronimo.aries.bundleRefreshTimeout", String.valueOf(300000));
        return Long.parseLong(property);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBundle(Bundle targetBundle, File bundleFile) throws Exception {
        String applicationName = this.applicationGBean.getApplicationName();
        String bundleName = targetBundle.getSymbolicName();
        LOG.info("Updating {} bundle in {} application", (Object)bundleName, (Object)applicationName);
        BundleContext context = this.applicationGBean.getBundle().getBundleContext();
        List<Bundle> bundles = Arrays.asList(targetBundle);
        FrameworkWiring wiring = (FrameworkWiring)context.getBundle(0L).adapt(FrameworkWiring.class);
        try {
            Collection dependents = wiring.getDependencyClosure(bundles);
            dependents.removeAll(bundles);
            if (!dependents.isEmpty()) {
                String bundleListString = ApplicationUpdateHelper.bundleCollectionToString(dependents);
                LOG.info("Update of {} bundle will cause the following bundles to be refreshed: {}", (Object)bundleName, (Object)bundleListString);
            }
            targetBundle.stop();
            InputStream in = null;
            String bundleLocation = targetBundle.getLocation();
            File location = BundleUtils.toFile((String)bundleLocation);
            if (location != null && location.isDirectory()) {
                try {
                    this.updateEBA(targetBundle, bundleFile);
                }
                catch (Exception e) {
                    LOG.warn("Error updating application bundle with the new contents.", (Throwable)e);
                }
                URL url = new URL(bundleLocation);
                in = url.openStream();
            } else {
                in = new FileInputStream(bundleFile);
            }
            try {
                targetBundle.update(in);
            }
            finally {
                IOUtils.close((Closeable)in);
            }
            if (!wiring.resolveBundles(bundles)) {
                StringBuilder builder = new StringBuilder();
                builder.append("Updated ").append(bundleName).append(" bundle cannot be resolved.");
                ResolverErrorAnalyzer errorAnalyzer = new ResolverErrorAnalyzer(context);
                String resolverErrors = errorAnalyzer.getErrorsAsString(this.applicationGBean.getApplicationContent());
                if (resolverErrors != null) {
                    builder.append(" ").append(resolverErrors);
                }
                throw new BundleException(builder.toString());
            }
            if (location == null || !location.isDirectory()) {
                try {
                    this.updateEBA(targetBundle, bundleFile);
                }
                catch (Exception e) {
                    LOG.warn("Error updating application archive with the new contents. Changes made might be gone next time the application or server is restarted.", (Throwable)e);
                }
            }
            RefreshListener refreshListener = new RefreshListener();
            wiring.refreshBundles(bundles, new FrameworkListener[]{refreshListener});
            refreshListener.waitForRefresh(bundleRefreshTimeout);
            if (BundleUtils.canStart((Bundle)targetBundle)) {
                targetBundle.start(1);
            }
            LOG.info("Bundle {} was successfully updated in {} application", (Object)bundleName, (Object)applicationName);
        }
        catch (Exception e) {
            LOG.error("Error updating " + bundleName + " bundle in " + applicationName + " application", (Throwable)e);
            throw new Exception("Error updating application: " + e.getMessage());
        }
    }

    public boolean updateBundleClasses(Bundle targetBundle, File changesFile, boolean updateArchive) throws Exception {
        if (!TransformerAgent.isRedefineClassesSupported()) {
            return false;
        }
        if (!this.hotSwapClasses(targetBundle, changesFile)) {
            return false;
        }
        if (updateArchive) {
            try {
                this.updateEBAPartial(targetBundle, changesFile);
            }
            catch (Exception e) {
                LOG.warn("Error updating application archive with the new contents. Changes made might be gone next time the application or server is restarted.", (Throwable)e);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateEBAPartial(Bundle targetBundle, File changesFile) throws IOException {
        File ebaArchive = this.applicationGBean.getApplicationArchive();
        String bundleNameInApp = this.getBundleNameInArchive(targetBundle);
        LOG.debug("Updating {} application archive with new contents for {}", (Object)ebaArchive, (Object)bundleNameInApp);
        if (ebaArchive.isDirectory()) {
            File bundleFile = new File(ebaArchive, bundleNameInApp);
            if (!bundleFile.exists()) {
                throw new IOException("Unable to locate " + bundleNameInApp + " in " + ebaArchive);
            }
            if (bundleFile.isFile()) {
                File updatedBundleFile = this.createUpdateJarFileDirectory(changesFile, ebaArchive, bundleNameInApp);
                try {
                    this.updateApplicationDirectory(ebaArchive, updatedBundleFile, bundleNameInApp);
                }
                finally {
                    ApplicationUpdateHelper.deleteFile(updatedBundleFile);
                }
            } else {
                ZipFile zipFile = new ZipFile(changesFile);
                JarUtils.unzipToDirectory((ZipFile)zipFile, (File)bundleFile);
            }
        } else {
            File updatedBundleFile = this.createUpdateJarFileArchive(changesFile, ebaArchive, bundleNameInApp);
            try {
                this.updateApplicationArchive(ebaArchive, updatedBundleFile, bundleNameInApp);
            }
            finally {
                ApplicationUpdateHelper.deleteFile(updatedBundleFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hotSwapClasses(Bundle bundle, File changesFile) {
        String bundleName = bundle.getSymbolicName();
        LOG.info("Checking if class hot swap can be performed for {} bundle", (Object)bundleName);
        String[] classPath = this.getBundleClassPath(bundle);
        ArrayList<ClassDefinition> classDefinitionList = new ArrayList<ClassDefinition>();
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(changesFile);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) continue;
                String name = entry.getName();
                if (!name.endsWith(".class")) {
                    throw new IllegalStateException("Non class file found: " + name);
                }
                Class<?> clazz = this.loadClass(bundle, classPath, name);
                InputStream in = zipFile.getInputStream(entry);
                byte[] clazzBytes = IOUtils.getBytes((InputStream)in);
                classDefinitionList.add(new ClassDefinition(clazz, clazzBytes));
            }
        }
        catch (Exception e) {
            boolean bl;
            try {
                LOG.info("Hot swap cannot be performed for {} bundle: {}", (Object)bundleName, (Object)e.getMessage());
                LOG.debug("Hot swap cannot be performed for " + bundleName + " bundle", (Throwable)e);
                bl = false;
            }
            catch (Throwable throwable) {
                JarUtils.close(zipFile);
                throw throwable;
            }
            JarUtils.close((ZipFile)zipFile);
            return bl;
        }
        JarUtils.close((ZipFile)zipFile);
        try {
            LOG.info("Attempting to hot swap the following classes for {} bundle: {}", (Object)bundleName, (Object)ApplicationUpdateHelper.classDefinitionToString(classDefinitionList));
            ClassDefinition[] classDefinitions = new ClassDefinition[classDefinitionList.size()];
            classDefinitionList.toArray(classDefinitions);
            TransformerAgent.redefine((ClassDefinition[])classDefinitions);
            LOG.info("Hot swap was successfully performed for {} bundle", (Object)bundleName);
            return true;
        }
        catch (Exception e) {
            LOG.info("Unable to perform class hot swap for {} bundle: {}", (Object)bundleName, (Object)e.getMessage());
            LOG.debug("Error performing hot swap for " + bundleName + " bundle", (Throwable)e);
            return false;
        }
    }

    private String[] getBundleClassPath(Bundle bundle) {
        String classPathHeader = (String)bundle.getHeaders().get("Bundle-ClassPath");
        if (classPathHeader == null) {
            return null;
        }
        List classPathElements = HeaderParser.parseHeader((String)classPathHeader);
        String[] classPath = new String[classPathElements.size()];
        for (int i = 0; i < classPathElements.size(); ++i) {
            String classPathName = ((HeaderParser.HeaderElement)classPathElements.get(i)).getName();
            if (classPathName.equals(".") || classPathName.equals("/")) {
                classPath[i] = "";
                continue;
            }
            int start = 0;
            if (classPathName.startsWith("/")) {
                ++start;
            }
            int end = classPathName.length();
            if (classPathName.endsWith("/")) {
                --end;
            }
            classPath[i] = classPathName.substring(start, end);
        }
        return classPath;
    }

    private Class<?> loadClass(Bundle bundle, String[] classPath, String classEntryName) throws ClassNotFoundException {
        if (classPath == null) {
            String className = this.getClassName("", classEntryName);
            return bundle.loadClass(className);
        }
        ArrayList<String> classes = null;
        for (String classPathEntry : classPath) {
            String className = this.getClassName(classPathEntry, classEntryName);
            LOG.debug("Attempting to load {} ", (Object)className);
            try {
                return bundle.loadClass(className);
            }
            catch (Throwable t) {
                LOG.debug("Failed to load " + className, t);
                if (classes == null) {
                    classes = new ArrayList<String>(classPath.length);
                }
                classes.add(className);
            }
        }
        throw new ClassNotFoundException(((Object)classes).toString());
    }

    private String getClassName(String classPathEntry, String classEntryName) {
        if (classPathEntry.length() > 0 && classEntryName.startsWith(classPathEntry)) {
            classEntryName = classEntryName.substring(classPathEntry.length() + 1);
        }
        return classEntryName.substring(0, classEntryName.length() - ".class".length()).replace('/', '.');
    }

    private static String bundleCollectionToString(Collection<Bundle> bundles) {
        StringBuilder builder = new StringBuilder();
        Iterator<Bundle> iterator = bundles.iterator();
        while (iterator.hasNext()) {
            Bundle bundle = iterator.next();
            builder.append(bundle.getSymbolicName());
            builder.append(" [").append(bundle.getBundleId()).append("]");
            if (!iterator.hasNext()) continue;
            builder.append(", ");
        }
        return builder.toString();
    }

    private static String classDefinitionToString(Collection<ClassDefinition> definitions) {
        StringBuilder builder = new StringBuilder();
        Iterator<ClassDefinition> iterator = definitions.iterator();
        while (iterator.hasNext()) {
            ClassDefinition definition = iterator.next();
            builder.append(definition.getDefinitionClass().getName());
            if (!iterator.hasNext()) continue;
            builder.append(", ");
        }
        return builder.toString();
    }

    private File createUpdateJarFileDirectory(File changesFile, File ebaArchive, String bundleNameInApp) throws IOException {
        File sourceFile = new File(ebaArchive, bundleNameInApp);
        if (!sourceFile.exists()) {
            throw new IOException("Unable to locate " + bundleNameInApp + " in " + ebaArchive);
        }
        File updatedFile = null;
        try {
            updatedFile = File.createTempFile(bundleNameInApp, ".jar");
            JarInputStream jarIn = new JarInputStream(new FileInputStream(sourceFile));
            ApplicationUpdateHelper.updateJarFile(jarIn, changesFile, updatedFile);
        }
        catch (IOException e) {
            ApplicationUpdateHelper.deleteFile(updatedFile);
            throw e;
        }
        return updatedFile;
    }

    private File createUpdateJarFileArchive(File changesFile, File ebaArchive, String bundleNameInApp) throws IOException {
        File updatedFile = null;
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(ebaArchive);
            ZipEntry entry = zipFile.getEntry(bundleNameInApp);
            if (entry == null) {
                throw new IOException("Unable to locate " + bundleNameInApp + " in " + ebaArchive);
            }
            updatedFile = File.createTempFile(bundleNameInApp, ".jar");
            JarInputStream jarIn = new JarInputStream(zipFile.getInputStream(entry));
            ApplicationUpdateHelper.updateJarFile(jarIn, changesFile, updatedFile);
        }
        catch (IOException e) {
            try {
                ApplicationUpdateHelper.deleteFile(updatedFile);
                throw e;
            }
            catch (Throwable throwable) {
                JarUtils.close(zipFile);
                throw throwable;
            }
        }
        JarUtils.close((ZipFile)zipFile);
        return updatedFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateJarFile(JarInputStream jarIn, File changesFile, File outputFile) throws IOException {
        HashMap<String, ZipEntry> updatedEntries = new HashMap<String, ZipEntry>();
        ZipFile zipFile = null;
        JarOutputStream jarOut = null;
        try {
            zipFile = new ZipFile(changesFile);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) continue;
                updatedEntries.put(entry.getName(), entry);
            }
            Manifest manifest = jarIn.getManifest();
            ZipEntry manifestEntry = (ZipEntry)updatedEntries.remove("META-INF/MANIFEST.MF");
            if (manifestEntry != null) {
                manifest = new Manifest(zipFile.getInputStream(manifestEntry));
            }
            jarOut = new JarOutputStream((OutputStream)new FileOutputStream(outputFile), manifest);
            JarEntry entry = null;
            byte[] buffer = new byte[4096];
            while ((entry = jarIn.getNextJarEntry()) != null) {
                ZipEntry source = (ZipEntry)updatedEntries.remove(entry.getName());
                if (source == null) {
                    ApplicationUpdateHelper.copyZipEntry(jarOut, entry, jarIn, buffer);
                    continue;
                }
                InputStream in = zipFile.getInputStream(source);
                try {
                    ApplicationUpdateHelper.copyZipEntry(jarOut, source, in, buffer);
                }
                finally {
                    IOUtils.close((Closeable)in);
                }
            }
            if (!updatedEntries.isEmpty()) {
                throw new IOException("Some jar entries were not updated: " + updatedEntries.keySet());
            }
        }
        catch (Throwable throwable) {
            IOUtils.close((Closeable)jarIn);
            JarUtils.close((ZipFile)zipFile);
            IOUtils.close(jarOut);
            throw throwable;
        }
        IOUtils.close((Closeable)jarIn);
        JarUtils.close((ZipFile)zipFile);
        IOUtils.close((Closeable)jarOut);
    }

    protected void updateEBA(Bundle bundle, File newBundleFile) throws IOException {
        File ebaArchive = this.applicationGBean.getApplicationArchive();
        String bundleNameInApp = this.getBundleNameInArchive(bundle);
        LOG.debug("Updating {} application archive with new contents for {}", (Object)ebaArchive, (Object)bundleNameInApp);
        if (ebaArchive.isDirectory()) {
            File bundleFile = new File(ebaArchive, bundleNameInApp);
            if (!bundleFile.exists()) {
                throw new IOException("Unable to locate " + bundleNameInApp + " in " + ebaArchive);
            }
            if (bundleFile.isFile()) {
                this.updateApplicationDirectory(ebaArchive, newBundleFile, bundleNameInApp);
            } else {
                ZipFile zipFile = new ZipFile(newBundleFile);
                JarUtils.unzipToDirectory((ZipFile)zipFile, (File)bundleFile);
                zipFile = new ZipFile(newBundleFile);
                List<File> filesToDelete = this.findDeletedFiles(zipFile, bundleFile);
                ArrayList inUseFiles = new ArrayList();
                for (File file : filesToDelete) {
                    FileUtils.recursiveDelete((File)file, inUseFiles);
                }
                if (!inUseFiles.isEmpty()) {
                    LOG.warn("Some files could not be deleted: {}", inUseFiles);
                }
            }
        } else {
            this.updateApplicationArchive(ebaArchive, newBundleFile, bundleNameInApp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<File> findDeletedFiles(ZipFile zipFile, File directory) {
        ArrayList<File> deletedFiles = new ArrayList<File>();
        try {
            this.collectDeletedFiles(zipFile, directory, "", deletedFiles);
        }
        finally {
            JarUtils.close((ZipFile)zipFile);
        }
        return deletedFiles;
    }

    private void collectDeletedFiles(ZipFile zipFile, File directory, String baseName, List<File> deleted) {
        File[] files = directory.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                String name = baseName + file.getName();
                ZipEntry entry = zipFile.getEntry(name);
                if (entry == null) {
                    deleted.add(file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.collectDeletedFiles(zipFile, file, name + "/", deleted);
            }
        }
    }

    private void updateApplicationDirectory(File ebaArchive, File bundleFile, String bundleNameInApp) throws IOException {
        File destinationFile = new File(ebaArchive, bundleNameInApp);
        LOG.debug("Updating contents of {} with {}", (Object)bundleNameInApp, (Object)bundleFile.getAbsolutePath());
        FileUtils.copyFile((File)bundleFile, (File)destinationFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateApplicationArchive(File ebaArchive, File bundleFile, String bundleNameInApp) throws IOException {
        File newEbaArchive = new File(ebaArchive.getAbsoluteFile() + ".new");
        ZipFile oldZipFile = null;
        ZipOutputStream newZipFile = null;
        try {
            newZipFile = new ZipOutputStream(new FileOutputStream(newEbaArchive));
            oldZipFile = new ZipFile(ebaArchive);
            Enumeration<? extends ZipEntry> entries = oldZipFile.entries();
            byte[] buffer = new byte[4096];
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                InputStream in = null;
                if (entry.getName().equals(bundleNameInApp)) {
                    in = new FileInputStream(bundleFile);
                    LOG.debug("Updating contents of {} with {}", (Object)bundleNameInApp, (Object)bundleFile.getAbsolutePath());
                } else {
                    in = oldZipFile.getInputStream(entry);
                }
                try {
                    ApplicationUpdateHelper.copyZipEntry(newZipFile, new ZipEntry(entry.getName()), in, buffer);
                }
                finally {
                    IOUtils.close((Closeable)in);
                }
            }
        }
        catch (IOException e) {
            try {
                LOG.debug("Error updating application archive", (Throwable)e);
                newEbaArchive.delete();
                throw e;
            }
            catch (Throwable throwable) {
                JarUtils.close(oldZipFile);
                IOUtils.close(newZipFile);
                throw throwable;
            }
        }
        JarUtils.close((ZipFile)oldZipFile);
        IOUtils.close((Closeable)newZipFile);
        if (ebaArchive.delete()) {
            if (!newEbaArchive.renameTo(ebaArchive)) {
                throw new IOException("Error renaming application archive");
            }
        } else {
            throw new IOException("Error deleting existing application archive");
        }
        LOG.debug("Application archive was successfully updated.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyZipEntry(ZipOutputStream zipFile, ZipEntry entry, InputStream in, byte[] buffer) throws IOException {
        zipFile.putNextEntry(entry);
        try {
            int count;
            while ((count = in.read(buffer)) > 0) {
                zipFile.write(buffer, 0, count);
            }
        }
        finally {
            zipFile.closeEntry();
        }
    }

    private String getBundleNameInArchive(Bundle bundle) {
        String baseLocation = ApplicationUpdateHelper.normalizeLocation(this.applicationGBean.getBundle().getLocation());
        String location = ApplicationUpdateHelper.normalizeLocation(bundle.getLocation());
        if (location.startsWith(baseLocation)) {
            return location.substring(baseLocation.length());
        }
        URI bundleLocation = URI.create(location);
        String bundleNameInApp = bundleLocation.getPath();
        if (bundleNameInApp.startsWith("/")) {
            bundleNameInApp = bundleNameInApp.substring(1);
        }
        return bundleNameInApp;
    }

    private static String normalizeLocation(String bundleLocation) {
        if (bundleLocation.startsWith("reference:")) {
            return bundleLocation.substring("reference:".length());
        }
        return bundleLocation;
    }

    private static void deleteFile(File file) {
        if (file != null) {
            file.delete();
        }
    }

    private class RefreshListener
    implements FrameworkListener {
        public CountDownLatch latch = new CountDownLatch(1);

        private RefreshListener() {
        }

        public void frameworkEvent(FrameworkEvent event) {
            if (event.getType() == 4) {
                this.latch.countDown();
            }
        }

        public void waitForRefresh(long timeout) {
            try {
                this.latch.await(timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

