/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.aries;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.aries.application.ApplicationMetadataFactory;
import org.apache.aries.application.DeploymentContent;
import org.apache.aries.application.DeploymentMetadata;
import org.apache.aries.application.DeploymentMetadataFactory;
import org.apache.aries.application.management.AriesApplication;
import org.apache.aries.application.management.AriesApplicationContext;
import org.apache.aries.application.management.AriesApplicationContextManager;
import org.apache.aries.application.management.AriesApplicationResolver;
import org.apache.aries.application.management.BundleInfo;
import org.apache.aries.application.management.ManagementException;
import org.apache.aries.application.management.ResolveConstraint;
import org.apache.aries.application.management.ResolverException;
import org.apache.geronimo.aries.ApplicationInstaller;
import org.apache.geronimo.aries.ApplicationUpdateHelper;
import org.apache.geronimo.aries.GeronimoApplication;
import org.apache.geronimo.aries.GeronimoApplicationContext;
import org.apache.geronimo.aries.GeronimoApplicationContextManager;
import org.apache.geronimo.aries.ResolverErrorAnalyzer;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.gbean.annotation.ParamSpecial;
import org.apache.geronimo.gbean.annotation.SpecialAttributeType;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.osgi.web.WebApplicationUtils;
import org.apache.xbean.osgi.bundle.util.BundleUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.service.packageadmin.PackageAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GBean
public class ApplicationGBean
implements GBeanLifecycle {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationGBean.class);
    private static final long applicationStartTimeout = ApplicationGBean.getApplicationStartTimeout();
    private final Bundle bundle;
    private final ApplicationInstaller installer;
    private final Artifact configId;
    private final ApplicationUpdateHelper updateHelper;
    private GeronimoApplication application;
    private AriesApplicationContext.ApplicationState applicationState;
    private Set<Bundle> applicationBundles;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationGBean(@ParamSpecial(type=SpecialAttributeType.kernel) Kernel kernel, @ParamSpecial(type=SpecialAttributeType.bundle) Bundle bundle, @ParamAttribute(name="configId") Artifact configId, @ParamReference(name="Installer") ApplicationInstaller installer) throws Exception {
        this.bundle = bundle;
        this.installer = installer;
        this.configId = configId;
        this.updateHelper = new ApplicationUpdateHelper(this);
        BundleContext bundleContext = bundle.getBundleContext();
        DeploymentMetadataFactory deploymentFactory = null;
        ApplicationMetadataFactory applicationFactory = null;
        ServiceReference deploymentFactoryReference = bundleContext.getServiceReference(DeploymentMetadataFactory.class.getName());
        ServiceReference applicationFactoryReference = bundleContext.getServiceReference(ApplicationMetadataFactory.class.getName());
        try {
            deploymentFactory = this.getService(deploymentFactoryReference, DeploymentMetadataFactory.class);
            applicationFactory = this.getService(applicationFactoryReference, ApplicationMetadataFactory.class);
            this.application = new GeronimoApplication(bundle, applicationFactory, deploymentFactory);
            this.install(deploymentFactory);
        }
        finally {
            if (deploymentFactory != null) {
                bundleContext.ungetService(deploymentFactoryReference);
            }
            if (applicationFactory != null) {
                bundleContext.ungetService(applicationFactoryReference);
            }
        }
        ServiceReference applicationManagerReference = bundleContext.getServiceReference(AriesApplicationContextManager.class.getName());
        GeronimoApplicationContextManager applicationManager = this.getService(applicationManagerReference, GeronimoApplicationContextManager.class);
        try {
            applicationManager.registerApplicationContext(new GeronimoApplicationContext(this));
        }
        finally {
            bundleContext.ungetService(applicationManagerReference);
        }
    }

    public long[] getApplicationContentBundleIds() {
        long[] ids = new long[this.applicationBundles.size()];
        int i = 0;
        for (Bundle content : this.applicationBundles) {
            ids[i++] = content.getBundleId();
        }
        return ids;
    }

    private Bundle getBundle(long bundleId) {
        for (Bundle content : this.applicationBundles) {
            if (content.getBundleId() != bundleId) continue;
            return content;
        }
        return null;
    }

    public String getApplicationContentBundleSymbolicName(long bundleId) {
        Bundle bundle = this.getBundle(bundleId);
        return bundle != null ? bundle.getSymbolicName() : null;
    }

    public synchronized void updateApplicationContent(long bundleId, File file) throws Exception {
        Bundle targetBundle = this.getBundle(bundleId);
        if (targetBundle == null) {
            throw new IllegalArgumentException("Could not find bundle with id " + bundleId + " in the application");
        }
        this.waitForStart();
        this.updateHelper.updateBundle(targetBundle, file);
        this.waitForStart();
    }

    public synchronized boolean hotSwapApplicationContent(long bundleId, File changesFile, boolean updateArchive) throws Exception {
        Bundle targetBundle = this.getBundle(bundleId);
        if (targetBundle == null) {
            throw new IllegalArgumentException("Could not find bundle with id " + bundleId + " in the application");
        }
        this.waitForStart();
        return this.updateHelper.updateBundleClasses(targetBundle, changesFile, updateArchive);
    }

    protected File getApplicationArchive() throws IOException {
        File ebaArchive = this.installer.getApplicationLocation(this.configId);
        if (ebaArchive == null || !ebaArchive.exists()) {
            throw new IOException("Cannot locate application archive for " + this.configId);
        }
        return ebaArchive;
    }

    protected Bundle getBundle() {
        return this.bundle;
    }

    protected AriesApplication getAriesApplication() {
        return this.application;
    }

    protected Set<Bundle> getApplicationContent() {
        return new HashSet<Bundle>(this.applicationBundles);
    }

    protected AriesApplicationContext.ApplicationState getApplicationState() {
        return this.applicationState;
    }

    protected String getApplicationName() {
        return this.application.getApplicationMetadata().getApplicationScope();
    }

    private DeploymentMetadata getDeploymentMetadata(AriesApplicationResolver resolver, DeploymentMetadataFactory deploymentFactory) throws ResolverException {
        DeploymentMetadata meta = this.application.getDeploymentMetadata();
        if (meta == null) {
            LOG.debug("Resolving {} application.", (Object)this.getApplicationName());
            Set requiredBundles = resolver.resolve((AriesApplication)this.application, new ResolveConstraint[0]);
            meta = deploymentFactory.createDeploymentMetadata((AriesApplication)this.application, requiredBundles);
            LOG.debug("Resolved application bundles: {} ", (Object)requiredBundles);
        } else {
            LOG.debug("Application {} is resolved.", (Object)this.getApplicationName());
        }
        return meta;
    }

    private void install(DeploymentMetadataFactory deploymentFactory) throws Exception {
        BundleContext bundleContext = this.bundle.getBundleContext();
        AriesApplicationResolver resolver = null;
        PackageAdmin packageAdmin = null;
        ServiceReference resolverRef = bundleContext.getServiceReference(AriesApplicationResolver.class.getName());
        ServiceReference packageAdminRef = bundleContext.getServiceReference(PackageAdmin.class.getName());
        this.applicationBundles = new LinkedHashSet<Bundle>();
        try {
            resolver = this.getService(resolverRef, AriesApplicationResolver.class);
            DeploymentMetadata meta = this.getDeploymentMetadata(resolver, deploymentFactory);
            List deploymentContentsBundles = meta.getApplicationDeploymentContents();
            List provisionBundles = meta.getApplicationProvisionBundles();
            ArrayList bundlesToInstall = new ArrayList();
            bundlesToInstall.addAll(deploymentContentsBundles);
            bundlesToInstall.addAll(provisionBundles);
            packageAdmin = this.getService(packageAdminRef, PackageAdmin.class);
            for (DeploymentContent content : bundlesToInstall) {
                Version bundleVersion;
                String bundleSymbolicName = content.getContentName();
                Bundle contentBundle = this.findBundleInFramework(packageAdmin, bundleSymbolicName, bundleVersion = content.getExactVersion());
                if (contentBundle != null) {
                    for (DeploymentContent deploymentContent : deploymentContentsBundles) {
                        if (!deploymentContent.getContentName().equals(bundleSymbolicName) || !deploymentContent.getExactVersion().equals((Object)bundleVersion)) continue;
                        this.applicationBundles.add(contentBundle);
                    }
                    continue;
                }
                BundleInfo bundleInfo = this.findBundleInfoInApplication(bundleSymbolicName, bundleVersion);
                if (bundleInfo == null) {
                    bundleInfo = this.findBundleInfoUsingResolver(resolver, bundleSymbolicName, bundleVersion);
                }
                if (bundleInfo == null) {
                    throw new ManagementException("Cound not find bundles: " + bundleSymbolicName + "_" + bundleVersion);
                }
                contentBundle = bundleContext.installBundle(bundleInfo.getLocation());
                this.applicationBundles.add(contentBundle);
            }
        }
        catch (BundleException be) {
            for (Bundle bundle : this.applicationBundles) {
                bundle.uninstall();
            }
            this.applicationBundles.clear();
            throw be;
        }
        finally {
            if (resolver != null) {
                bundleContext.ungetService(resolverRef);
            }
            if (packageAdmin != null) {
                bundleContext.ungetService(packageAdminRef);
            }
        }
        this.applicationState = AriesApplicationContext.ApplicationState.INSTALLED;
    }

    private Bundle findBundleInFramework(PackageAdmin admin, String symbolicName, Version version) {
        String exactVersion = "[" + version + "," + version + "]";
        Bundle[] bundles = admin.getBundles(symbolicName, exactVersion);
        if (bundles != null && bundles.length == 1) {
            return bundles[0];
        }
        return null;
    }

    private BundleInfo findBundleInfoInApplication(String symbolicName, Version version) {
        for (BundleInfo info : this.application.getBundleInfo()) {
            if (!info.getSymbolicName().equals(symbolicName) || !info.getVersion().equals((Object)version)) continue;
            return info;
        }
        return null;
    }

    private BundleInfo findBundleInfoUsingResolver(AriesApplicationResolver resolver, String symbolicName, Version version) {
        return resolver.getBundleInfo(symbolicName, version);
    }

    private <T> T getService(ServiceReference ref, Class<T> type) throws ManagementException {
        Object service = null;
        if (ref != null) {
            service = this.bundle.getBundleContext().getService(ref);
        }
        if (service == null) {
            throw new ManagementException((Exception)new ServiceException(type.getName(), 1));
        }
        return type.cast(service);
    }

    private static boolean getFailOnStartError() {
        String property = System.getProperty("org.apache.geronimo.aries.failApplicationOnStartError", "false");
        return Boolean.parseBoolean(property);
    }

    public void doStart() throws Exception {
        LOG.debug("Starting {} application.", (Object)this.getApplicationName());
        this.applicationState = AriesApplicationContext.ApplicationState.STARTING;
        try {
            this.startApplicationBundles();
            this.applicationState = AriesApplicationContext.ApplicationState.ACTIVE;
            LOG.debug("Application {} started successfully.", (Object)this.getApplicationName());
        }
        catch (BundleException be) {
            this.applicationState = AriesApplicationContext.ApplicationState.INSTALLED;
            BundleException rootException = be;
            String rootMessage = be.getMessage();
            BundleContext bundleContext = this.bundle.getBundleContext();
            if (bundleContext != null) {
                try {
                    ResolverErrorAnalyzer errorAnalyzer = new ResolverErrorAnalyzer(bundleContext);
                    String resolverErrors = errorAnalyzer.getErrorsAsString(this.applicationBundles);
                    if (resolverErrors != null) {
                        rootException = null;
                        rootMessage = resolverErrors;
                    }
                }
                catch (IllegalStateException e) {
                    // empty catch block
                }
            }
            String message = MessageFormat.format("Error starting {0} application. {1}", this.getApplicationName(), rootMessage);
            if (ApplicationGBean.getFailOnStartError()) {
                throw new BundleException(message, (Throwable)rootException);
            }
            LOG.error(message, (Throwable)rootException);
        }
    }

    private void startApplicationBundles() throws Exception {
        BundleContext context = this.bundle.getBundleContext();
        FrameworkWiring wiring = (FrameworkWiring)context.getBundle(0L).adapt(FrameworkWiring.class);
        if (!wiring.resolveBundles(this.applicationBundles)) {
            throw new BundleException("One or more bundles in " + this.getApplicationName() + " application could not be resolved.");
        }
        LinkedList<Bundle> bundlesWeStarted = new LinkedList<Bundle>();
        try {
            this.applicationBundles = this.getSortedBundles();
            for (Bundle b : this.applicationBundles) {
                if (!BundleUtils.canStart((Bundle)b)) continue;
                LOG.debug("Starting {} application bundle.", (Object)b);
                b.start(1);
                bundlesWeStarted.addFirst(b);
            }
        }
        catch (BundleException be) {
            for (Bundle b : bundlesWeStarted) {
                try {
                    b.stop();
                }
                catch (BundleException be2) {}
            }
            throw be;
        }
    }

    private LinkedHashSet<Bundle> getSortedBundles() {
        LinkedList<Bundle> stack = new LinkedList<Bundle>();
        LinkedHashSet<Bundle> orderedBundles = new LinkedHashSet<Bundle>(this.applicationBundles.size());
        for (Bundle bundle : this.applicationBundles) {
            this.sortDependentBundles(bundle, orderedBundles, stack);
        }
        return orderedBundles;
    }

    private void sortDependentBundles(Bundle bundle, LinkedHashSet<Bundle> sortedBundles, LinkedList<Bundle> stack) {
        Bundle wiredBundle;
        if (sortedBundles.contains(bundle)) {
            return;
        }
        if (stack.contains(bundle)) {
            LOG.warn("Bundle dependency loop detected: {}", stack.subList(stack.indexOf(bundle), stack.size()));
            return;
        }
        stack.add(bundle);
        BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        List wires = wiring.getRequiredWires("osgi.wiring.package");
        for (BundleWire wire : wires) {
            wiredBundle = wire.getProviderWiring().getBundle();
            if (wiredBundle == bundle || !this.applicationBundles.contains(wiredBundle)) continue;
            this.sortDependentBundles(wiredBundle, sortedBundles, stack);
        }
        wires = wiring.getRequiredWires("osgi.wiring.bundle");
        for (BundleWire wire : wires) {
            wiredBundle = wire.getProviderWiring().getBundle();
            if (wiredBundle == bundle || !this.applicationBundles.contains(wiredBundle)) continue;
            this.sortDependentBundles(wiredBundle, sortedBundles, stack);
        }
        stack.removeLast();
        sortedBundles.add(bundle);
    }

    private static long getApplicationStartTimeout() {
        String property = System.getProperty("org.apache.geronimo.aries.applicationStartTimeout", String.valueOf(300000));
        return Long.parseLong(property);
    }

    private void waitForStart() {
        this.waitForStart(applicationStartTimeout);
    }

    private void waitForStart(long timeout) {
        HashSet<Bundle> webBundles = new HashSet<Bundle>();
        for (Bundle b : this.applicationBundles) {
            if (b.getState() != 32 || !WebApplicationUtils.isWebApplicationBundle((Bundle)b)) continue;
            webBundles.add(b);
        }
        if (!webBundles.isEmpty()) {
            LOG.debug("Waiting {}ms for asynchronous processing for {} bundles to finish", (Object)timeout, webBundles);
            try {
                boolean completed = this.installer.getWebApplicationTracker().waitForBundles(webBundles, timeout);
                if (completed) {
                    LOG.debug("Asynchronous processing completed.");
                } else {
                    LOG.debug("Time out while waiting for asynchronous processing to finish.");
                }
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }

    public void doStop() {
        LOG.debug("Stopping {} application.", (Object)this.getApplicationName());
        LinkedList<Bundle> sortedList = new LinkedList<Bundle>();
        for (Bundle bundle : this.applicationBundles) {
            sortedList.addFirst(bundle);
        }
        for (Bundle bundle : sortedList) {
            try {
                LOG.debug("Stopping and uninstalling {} application bundle.", (Object)bundle);
                bundle.uninstall();
            }
            catch (Exception e) {
                LOG.error("Fail to uninstall", (Throwable)e);
            }
        }
        this.applicationBundles.clear();
        this.applicationState = AriesApplicationContext.ApplicationState.RESOLVED;
    }

    public void doFail() {
        this.doStop();
    }

    protected void applicationStart() throws BundleException {
        try {
            this.installer.getConfigurationManager().loadConfiguration(this.configId);
            this.installer.getConfigurationManager().startConfiguration(this.configId);
        }
        catch (Exception e) {
            throw new BundleException("Failed to start application", (Throwable)e);
        }
    }

    protected void applicationStop() throws BundleException {
        try {
            this.installer.getConfigurationManager().unloadConfiguration(this.configId);
        }
        catch (Exception e) {
            throw new BundleException("Failed to start application", (Throwable)e);
        }
    }

    protected void applicationUninstall() {
        LOG.debug("Uninstalling {} application.", (Object)this.getApplicationName());
        try {
            this.installer.getConfigurationManager().unloadConfiguration(this.configId);
            this.installer.getConfigurationManager().uninstallConfiguration(this.configId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.applicationState = AriesApplicationContext.ApplicationState.UNINSTALLED;
    }
}

