/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.aries.shell;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.apache.aries.application.filesystem.IDirectory;
import org.apache.aries.application.management.AriesApplication;
import org.apache.aries.application.management.AriesApplicationManager;
import org.apache.aries.application.management.ResolveConstraint;
import org.apache.aries.application.utils.filesystem.FileSystem;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.osgi.framework.ServiceReference;

@Command(scope="eba", name="resolve", description="Resolve Aries Application")
public class ResolveApplication
extends OsgiCommandSupport {
    @Argument(required=true, description="File name of an unresolved Aries Application")
    String applicationPath;
    @Option(name="-o", aliases={"--out"}, description="File name to store the resolved application in")
    String resovledApplicationPath;

    protected AriesApplicationManager getAriesApplicationManager() {
        ServiceReference ref = this.bundleContext.getServiceReference(AriesApplicationManager.class.getName());
        return (AriesApplicationManager)this.getService(AriesApplicationManager.class, ref);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doExecute() throws Exception {
        File sourceApplication = new File(this.applicationPath);
        IDirectory in = FileSystem.getFSRoot((File)sourceApplication);
        if (in == null) {
            System.err.println("File not found: " + this.applicationPath);
            return in;
        }
        AriesApplicationManager manager = this.getAriesApplicationManager();
        AriesApplication application = manager.createApplication(in);
        if (application.isResolved()) {
            System.out.println("Application " + application.getApplicationMetadata().getApplicationSymbolicName() + " is already resolved.");
        } else {
            System.out.println("Attempting to resolve " + application.getApplicationMetadata().getApplicationSymbolicName() + " application.");
            AriesApplication resolved = manager.resolve(application, new ResolveConstraint[0]);
            File targetApplication = null;
            if (this.resovledApplicationPath == null) {
                String baseName = null;
                baseName = this.applicationPath.endsWith(".eba") ? this.applicationPath.substring(0, this.applicationPath.length() - 4) : this.applicationPath;
                targetApplication = new File(baseName + ".resolved.eba");
            } else {
                targetApplication = new File(this.resovledApplicationPath);
            }
            System.out.println("Application " + application.getApplicationMetadata().getApplicationSymbolicName() + " was successfully resolved.");
            System.out.println("Writing the resolved application to " + targetApplication);
            FileOutputStream os = new FileOutputStream(targetApplication);
            try {
                resolved.store((OutputStream)os);
            }
            finally {
                os.close();
            }
            System.out.println("Done.");
        }
        return null;
    }
}

