/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.activemq;

import java.io.File;
import java.net.URI;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.JMSException;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.jmx.ManagementContext;
import org.apache.activemq.transport.TransportDisposedIOException;
import org.apache.activemq.xbean.BrokerFactoryBean;
import org.apache.geronimo.activemq.BrokerServiceGBean;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.gbean.annotation.ParamSpecial;
import org.apache.geronimo.gbean.annotation.SpecialAttributeType;
import org.apache.geronimo.management.geronimo.JMSManager;
import org.apache.geronimo.management.geronimo.NetworkConnector;
import org.apache.geronimo.system.jmx.MBeanServerReference;
import org.apache.geronimo.system.serverinfo.ServerInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

@GBean(j2eeType="JMSServer")
public class BrokerServiceGBeanImpl
implements BrokerServiceGBean,
GBeanLifecycle {
    private static final Logger log = LoggerFactory.getLogger(BrokerServiceGBeanImpl.class);
    private final String objectName;
    private final BrokerService brokerService;
    private final boolean asyncStartup;
    private final int asyncStartupDelay;
    private final CountDownLatch asyncStarted = new CountDownLatch(1);
    private final AtomicBoolean active = new AtomicBoolean(false);
    private Thread asyncStartThread;
    private JMSManager manager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BrokerServiceGBeanImpl(@ParamAttribute(name="brokerName") String brokerName, @ParamAttribute(name="amqBaseDir") URI amqBaseDir, @ParamAttribute(name="amqDataDir") String amqDataDir, @ParamAttribute(name="amqConfigFile") String amqConfigFile, @ParamAttribute(name="useShutdownHook") boolean useShutdownHook, @ParamAttribute(name="asyncStartup") boolean asyncStartup, @ParamAttribute(name="asyncStartupDelay") int asyncStartupDelay, @ParamReference(name="ServerInfo") ServerInfo serverInfo, @ParamReference(name="MBeanServerReference") MBeanServerReference mbeanServerReference, @ParamSpecial(type=SpecialAttributeType.objectName) String objectName, @ParamSpecial(type=SpecialAttributeType.classLoader) ClassLoader classLoader) throws Exception {
        this.objectName = objectName;
        this.asyncStartup = asyncStartup;
        this.asyncStartupDelay = asyncStartupDelay;
        URI baseDir = serverInfo.resolveServer(amqBaseDir);
        URI dataDir = baseDir.resolve(amqDataDir);
        URI amqConfigUri = baseDir.resolve(amqConfigFile);
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(classLoader);
        try {
            BrokerFactoryBean brokerFactory = new BrokerFactoryBean((Resource)new FileSystemResource(new File(amqConfigUri)));
            Class<BrokerServiceGBeanImpl> clazz = BrokerServiceGBeanImpl.class;
            synchronized (BrokerServiceGBeanImpl.class) {
                System.setProperty("activemq.brokerName", brokerName);
                System.setProperty("activemq.home", new File(baseDir).toString());
                System.setProperty("activemq.data", new File(dataDir).toString());
                File geronimoHomeURL = serverInfo.resolveServer("./");
                System.setProperty("activemq.geronimo.home.url", geronimoHomeURL.toURI().toURL().toString());
                brokerFactory.afterPropertiesSet();
                // ** MonitorExit[var17_17] (shouldn't be in output)
                this.brokerService = brokerFactory.getBroker();
                ManagementContext mgmtctx = new ManagementContext(mbeanServerReference != null ? mbeanServerReference.getMBeanServer() : null);
                mgmtctx.setCreateConnector(false);
                this.brokerService.setManagementContext(mgmtctx);
                this.brokerService.setUseShutdownHook(useShutdownHook);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
        {
            return;
        }
    }

    public synchronized BrokerService getBrokerContainer() {
        return this.brokerService;
    }

    public String getBrokerName() {
        return this.brokerService.getBrokerName();
    }

    public synchronized void doStart() throws Exception {
        if (!this.asyncStartup) {
            this.brokerService.start();
        } else {
            this.active.set(true);
            this.asyncStartThread = new Thread(new Runnable(){

                public void run() {
                    BrokerServiceGBeanImpl.this.asyncStart();
                }
            }, "AsyncStartThread-" + this.getBrokerName());
            this.asyncStartThread.setDaemon(true);
            this.asyncStartThread.start();
            this.asyncStarted.await(this.asyncStartupDelay, TimeUnit.SECONDS);
        }
    }

    public synchronized void doStop() throws Exception {
        if (this.asyncStartup) {
            this.active.set(false);
            if (this.asyncStarted.getCount() > 0L) {
                return;
            }
        }
        this.brokerService.stop();
        this.brokerService.waitUntilStopped();
    }

    public synchronized void doFail() {
        if (this.asyncStartup) {
            this.active.set(false);
            if (this.asyncStarted.getCount() > 0L) {
                return;
            }
        }
        try {
            this.brokerService.stop();
            this.brokerService.waitUntilStopped();
        }
        catch (JMSException ignored) {
            if (!(ignored.getCause() instanceof TransportDisposedIOException)) {
                log.warn("Caught while closing due to failure: " + (Object)((Object)ignored), (Throwable)ignored);
            }
        }
        catch (Exception e) {
            log.warn("Caught while closing due to failure: " + e, (Throwable)e);
        }
    }

    private void asyncStart() {
        while (this.active.get()) {
            try {
                this.brokerService.start();
                log.info("brokerService started");
                this.asyncStarted.countDown();
                this.brokerService.waitUntilStopped();
                if (!this.active.get()) continue;
                log.warn("brokerService stopped");
            }
            catch (Exception e) {
                log.warn("brokerService start failed: " + e, (Throwable)e);
            }
        }
    }

    public String getObjectName() {
        return this.objectName;
    }

    public boolean isStateManageable() {
        return true;
    }

    public boolean isStatisticsProvider() {
        return false;
    }

    public boolean isEventProvider() {
        return true;
    }

    public NetworkConnector[] getConnectors() {
        return this.manager.getConnectorsForContainer((Object)this);
    }

    public NetworkConnector[] getConnectors(String protocol) {
        return this.manager.getConnectorsForContainer((Object)this, protocol);
    }

    public JMSManager getManager() {
        return this.manager;
    }

    public void setManager(JMSManager manager) {
        this.manager = manager;
    }
}

