/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.activemq;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.geronimo.activemq.BrokerServiceGBean;
import org.apache.geronimo.activemq.management.ActiveMQTransportConnector;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.annotation.AnnotationGBeanInfoFactory;
import org.apache.geronimo.gbean.annotation.ParamSpecial;
import org.apache.geronimo.gbean.annotation.SpecialAttributeType;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.lifecycle.LifecycleListener;

public class ActiveMQBrokerServiceMonitorGBean
implements GBeanLifecycle,
LifecycleListener {
    private Kernel kernel;
    private Map<AbstractName, List<AbstractName>> brokerNameConnectorNamesMap = new ConcurrentHashMap<AbstractName, List<AbstractName>>();
    private ClassLoader classLoader;

    public ActiveMQBrokerServiceMonitorGBean(@ParamSpecial(type=SpecialAttributeType.kernel) Kernel kernel, @ParamSpecial(type=SpecialAttributeType.classLoader) ClassLoader classLoader) {
        this.kernel = kernel;
        this.classLoader = classLoader;
    }

    public void doFail() {
        this.kernel.getLifecycleMonitor().removeLifecycleListener((LifecycleListener)this);
    }

    public void doStart() throws Exception {
        AbstractNameQuery brokerServiceQuery = new AbstractNameQuery(new URI("?#org.apache.geronimo.activemq.BrokerServiceGBean"));
        this.kernel.getLifecycleMonitor().addLifecycleListener((LifecycleListener)this, brokerServiceQuery);
        Set brokerServiceNames = this.kernel.listGBeans(brokerServiceQuery);
        for (AbstractName brokerServiceName : brokerServiceNames) {
            if (!this.kernel.isRunning(brokerServiceName)) continue;
            this.startConnectorWrapperGBeans(brokerServiceName);
        }
    }

    public void doStop() throws Exception {
        this.kernel.getLifecycleMonitor().removeLifecycleListener((LifecycleListener)this);
    }

    public void failed(AbstractName abstractName) {
        this.stopConnectorWrapperGBeans(abstractName);
    }

    public void loaded(AbstractName abstractName) {
    }

    public void running(AbstractName abstractName) {
        this.startConnectorWrapperGBeans(abstractName);
    }

    public void starting(AbstractName abstractName) {
    }

    public void stopped(AbstractName abstractName) {
        this.stopConnectorWrapperGBeans(abstractName);
    }

    public void stopping(AbstractName abstractName) {
    }

    public void unloaded(AbstractName abstractName) {
    }

    protected void startConnectorWrapperGBeans(AbstractName brokerAbstractName) {
        try {
            BrokerService brokerService = ((BrokerServiceGBean)this.kernel.getGBean(brokerAbstractName)).getBrokerContainer();
            ArrayList<AbstractName> connectorNames = new ArrayList<AbstractName>();
            GBeanInfo gBeanInfo = new AnnotationGBeanInfoFactory().getGBeanInfo(ActiveMQTransportConnector.class);
            for (TransportConnector transportConnector : brokerService.getTransportConnectors()) {
                AbstractName connectorAbName = this.kernel.getNaming().createSiblingName(brokerAbstractName, transportConnector.getUri().toString().replace(':', '_'), "GBean");
                GBeanData gbeanData = new GBeanData(connectorAbName, gBeanInfo);
                gbeanData.setAttribute("transportConnector", (Object)transportConnector);
                this.kernel.loadGBean(gbeanData, this.classLoader);
                this.kernel.startGBean(connectorAbName);
                connectorNames.add(connectorAbName);
            }
            this.brokerNameConnectorNamesMap.put(brokerAbstractName, connectorNames);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void stopConnectorWrapperGBeans(AbstractName brokerAbstractName) {
        List<AbstractName> connectorNames = this.brokerNameConnectorNamesMap.remove(brokerAbstractName);
        if (connectorNames == null) {
            return;
        }
        for (AbstractName connectorName : connectorNames) {
            try {
                this.kernel.stopGBean(connectorName);
                this.kernel.unloadGBean(connectorName);
            }
            catch (Exception e) {}
        }
    }
}

