/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.activemq;

import java.net.URI;
import javax.jms.JMSException;
import javax.resource.ResourceException;
import javax.sql.DataSource;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.jmx.ManagementContext;
import org.apache.activemq.store.DefaultPersistenceAdapterFactory;
import org.apache.activemq.transport.TransportDisposedIOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.activemq.BrokerServiceGBean;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.management.geronimo.JMSManager;
import org.apache.geronimo.management.geronimo.NetworkConnector;
import org.apache.geronimo.naming.ResourceSource;
import org.apache.geronimo.system.jmx.MBeanServerReference;
import org.apache.geronimo.system.serverinfo.ServerInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrokerServiceGBeanImpl
implements GBeanLifecycle,
BrokerServiceGBean {
    private Log log = LogFactory.getLog(this.getClass());
    private String brokerName;
    private String brokerUri;
    private BrokerService brokerService;
    private ServerInfo serverInfo;
    private String dataDirectory;
    private ResourceSource<ResourceException> dataSource;
    private ClassLoader classLoader;
    private String objectName;
    private JMSManager manager;
    private boolean useShutdownHook;
    private MBeanServerReference mbeanServerReference;
    public static final GBeanInfo GBEAN_INFO;

    @Override
    public synchronized BrokerService getBrokerContainer() {
        return this.brokerService;
    }

    public void setMbeanServerReference(MBeanServerReference mbeanServerReference) {
        this.mbeanServerReference = mbeanServerReference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void doStart() throws Exception {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClassLoader());
        try {
            if (this.brokerService == null) {
                if (this.brokerUri != null) {
                    this.brokerService = BrokerFactory.createBroker((URI)new URI(this.brokerUri));
                    this.brokerName = this.brokerService.getBrokerName();
                } else {
                    this.brokerService = new BrokerService();
                    if (this.brokerName != null) {
                        this.brokerService.setBrokerName(this.brokerName);
                    } else {
                        this.brokerName = this.brokerService.getBrokerName();
                    }
                }
            }
            ManagementContext mgmtctx = new ManagementContext(this.mbeanServerReference != null ? this.mbeanServerReference.getMBeanServer() : null);
            mgmtctx.setCreateConnector(false);
            this.brokerService.setManagementContext(mgmtctx);
            this.brokerService.setUseShutdownHook(this.isUseShutdownHook());
            DefaultPersistenceAdapterFactory persistenceFactory = (DefaultPersistenceAdapterFactory)this.brokerService.getPersistenceFactory();
            persistenceFactory.setDataDirectoryFile(this.serverInfo.resolveServer(this.dataDirectory));
            persistenceFactory.setDataSource((DataSource)this.dataSource.$getResource());
            this.brokerService.start();
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public synchronized void doStop() throws Exception {
        block3: {
            if (this.brokerService != null) {
                BrokerService temp = this.brokerService;
                this.brokerService = null;
                try {
                    temp.stop();
                }
                catch (JMSException ignored) {
                    if (ignored.getCause() instanceof TransportDisposedIOException) break block3;
                    throw ignored;
                }
            }
        }
    }

    public synchronized void doFail() {
        if (this.brokerService != null) {
            BrokerService temp = this.brokerService;
            this.brokerService = null;
            try {
                temp.stop();
            }
            catch (JMSException ignored) {
                if (!(ignored.getCause() instanceof TransportDisposedIOException)) {
                    this.log.warn((Object)("Caught while closing due to failure: " + (Object)((Object)ignored)), (Throwable)ignored);
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Caught while closing due to failure: " + e), (Throwable)e);
            }
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    @Override
    public String getBrokerName() {
        return this.brokerName;
    }

    public String getBrokerUri() {
        return this.brokerUri;
    }

    public void setBrokerName(String brokerName) {
        this.brokerName = brokerName;
    }

    public void setBrokerUri(String brokerUri) {
        this.brokerUri = brokerUri;
    }

    public ServerInfo getServerInfo() {
        return this.serverInfo;
    }

    public void setServerInfo(ServerInfo serverInfo) {
        this.serverInfo = serverInfo;
    }

    public String getDataDirectory() {
        return this.dataDirectory;
    }

    public void setDataDirectory(String dataDir) {
        this.dataDirectory = dataDir;
    }

    public ResourceSource<ResourceException> getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(ResourceSource<ResourceException> dataSource) {
        this.dataSource = dataSource;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public boolean isStateManageable() {
        return true;
    }

    public boolean isStatisticsProvider() {
        return false;
    }

    public boolean isEventProvider() {
        return true;
    }

    public NetworkConnector[] getConnectors() {
        return this.manager.getConnectorsForContainer((Object)this);
    }

    public NetworkConnector[] getConnectors(String protocol) {
        return this.manager.getConnectorsForContainer((Object)this, protocol);
    }

    public JMSManager getManager() {
        return this.manager;
    }

    public void setManager(JMSManager manager) {
        this.manager = manager;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            this.classLoader = this.getClass().getClassLoader();
        }
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public boolean isUseShutdownHook() {
        return this.useShutdownHook;
    }

    public void setUseShutdownHook(boolean useShutdownHook) {
        this.useShutdownHook = useShutdownHook;
    }

    static {
        GBeanInfoBuilder infoBuilder = new GBeanInfoBuilder("ActiveMQ Message Broker", BrokerServiceGBeanImpl.class, "JMSServer");
        infoBuilder.addReference("serverInfo", ServerInfo.class);
        infoBuilder.addReference("mbeanServerReference", MBeanServerReference.class);
        infoBuilder.addAttribute("classLoader", ClassLoader.class, false);
        infoBuilder.addAttribute("brokerName", String.class, true);
        infoBuilder.addAttribute("brokerUri", String.class, true);
        infoBuilder.addAttribute("useShutdownHook", Boolean.TYPE, true);
        infoBuilder.addAttribute("dataDirectory", String.class, true);
        infoBuilder.addReference("dataSource", ResourceSource.class);
        infoBuilder.addAttribute("objectName", String.class, false);
        infoBuilder.addReference("manager", JMSManager.class);
        infoBuilder.addInterface(BrokerServiceGBean.class);
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

