/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.activemq.management;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.activemq.broker.TransportConnector;
import org.apache.geronimo.activemq.BrokerServiceGBean;
import org.apache.geronimo.activemq.management.ActiveMQTransportConnector;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamSpecial;
import org.apache.geronimo.gbean.annotation.SpecialAttributeType;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.KernelException;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationUtil;
import org.apache.geronimo.kernel.config.EditableConfigurationManager;
import org.apache.geronimo.kernel.config.InvalidConfigException;
import org.apache.geronimo.management.activemq.ActiveMQBroker;
import org.apache.geronimo.management.activemq.ActiveMQManager;
import org.apache.geronimo.management.geronimo.JMSBroker;
import org.apache.geronimo.management.geronimo.JMSConnector;
import org.apache.geronimo.management.geronimo.NetworkConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GBean
public class ActiveMQManagerGBean
implements ActiveMQManager {
    private static final Logger log = LoggerFactory.getLogger(ActiveMQManagerGBean.class);
    private Kernel kernel;
    private String objectName;

    public ActiveMQManagerGBean(@ParamSpecial(type=SpecialAttributeType.kernel) Kernel kernel, @ParamSpecial(type=SpecialAttributeType.objectName) String objectName) {
        this.kernel = kernel;
        this.objectName = objectName;
    }

    public String getProductName() {
        return "ActiveMQ";
    }

    public String getObjectName() {
        return this.objectName;
    }

    public boolean isEventProvider() {
        return false;
    }

    public boolean isStateManageable() {
        return true;
    }

    public boolean isStatisticsProvider() {
        return false;
    }

    public Object[] getContainers() {
        AbstractNameQuery query = new AbstractNameQuery(ActiveMQBroker.class.getName());
        Set names = this.kernel.listGBeans(query);
        ArrayList<ActiveMQBroker> results = new ArrayList<ActiveMQBroker>(names.size());
        for (AbstractName name : names) {
            try {
                if (!this.kernel.isRunning(name)) continue;
                results.add((ActiveMQBroker)this.kernel.getGBean(name));
            }
            catch (GBeanNotFoundException e) {
                log.info("broker not found", (Throwable)e);
            }
        }
        return results.toArray(new ActiveMQBroker[0]);
    }

    public String[] getSupportedProtocols() {
        return new String[]{"tcp", "stomp", "vm", "peer", "udp", "multicast", "failover", "stomp+ssl", "nio", "mock", "fanout", "discovery"};
    }

    public NetworkConnector[] getConnectors() {
        List<NetworkConnector> connectors = this.getConnectorsList();
        return connectors.toArray(new NetworkConnector[0]);
    }

    private List<NetworkConnector> getConnectorsList() {
        ActiveMQBroker[] brokers;
        ArrayList<NetworkConnector> connectors = new ArrayList<NetworkConnector>();
        for (ActiveMQBroker broker : brokers = (ActiveMQBroker[])this.getContainers()) {
            connectors.addAll(this.getConnectorListForContainer((BrokerServiceGBean)broker));
        }
        return connectors;
    }

    public NetworkConnector[] getConnectors(String protocol) {
        if (protocol == null) {
            return this.getConnectors();
        }
        List<NetworkConnector> connectors = this.getConnectorsList();
        this.filterConnectorsByProtocol(protocol, connectors);
        return connectors.toArray(new NetworkConnector[0]);
    }

    private void filterConnectorsByProtocol(String protocol, List<NetworkConnector> connectors) {
        Iterator<NetworkConnector> connectorIterator = connectors.iterator();
        while (connectorIterator.hasNext()) {
            if (protocol.equals(connectorIterator.next().getProtocol())) continue;
            connectorIterator.remove();
        }
    }

    public NetworkConnector[] getConnectorsForContainer(Object genericBroker) {
        return this.getConnectorListForContainer((BrokerServiceGBean)genericBroker).toArray(new NetworkConnector[0]);
    }

    private List<NetworkConnector> getConnectorListForContainer(BrokerServiceGBean broker) {
        List transportConnectors = broker.getBrokerContainer().getTransportConnectors();
        ArrayList<NetworkConnector> connectors = new ArrayList<NetworkConnector>();
        for (TransportConnector transportConnector : transportConnectors) {
            connectors.add((NetworkConnector)new ActiveMQTransportConnector(transportConnector));
        }
        return connectors;
    }

    public NetworkConnector[] getConnectorsForContainer(Object broker, String protocol) {
        if (protocol == null) {
            return this.getConnectorsForContainer(broker);
        }
        List<NetworkConnector> connectors = this.getConnectorListForContainer((BrokerServiceGBean)broker);
        this.filterConnectorsByProtocol(protocol, connectors);
        return connectors.toArray(new NetworkConnector[0]);
    }

    public JMSConnector addConnector(JMSBroker broker, String uniqueName, String protocol, String host, int port) {
        throw new RuntimeException("not implemented");
    }

    public void removeConnector(AbstractName connectorName) {
        throw new RuntimeException("not implemented");
    }

    public JMSBroker addBroker(String brokerName, GBeanData brokerGBeanData) throws KernelException, InvalidConfigException {
        EditableConfigurationManager mgr = ConfigurationUtil.getEditableConfigurationManager((Kernel)this.kernel);
        if (mgr != null) {
            AbstractName brokerAbstractName = null;
            try {
                mgr.addGBeanToConfiguration(this.kernel.getAbstractNameFor((Object)this).getArtifact(), brokerGBeanData, false);
                brokerAbstractName = brokerGBeanData.getAbstractName();
                JMSBroker jMSBroker = (JMSBroker)this.kernel.getProxyManager().createProxy(brokerAbstractName, ActiveMQBroker.class.getClassLoader());
                return jMSBroker;
            }
            catch (InvalidConfigException e) {
                log.error("Unable to add ActiveMQ broker [" + brokerName + "]", (Throwable)e);
                throw e;
            }
            finally {
                ConfigurationUtil.releaseConfigurationManager((Kernel)this.kernel, (ConfigurationManager)mgr);
            }
        }
        log.warn("The ConfigurationManager in the kernel does not allow editing");
        return null;
    }

    public void removeBroker(AbstractName brokerAbstractName) throws KernelException, InvalidConfigException {
        EditableConfigurationManager mgr = ConfigurationUtil.getEditableConfigurationManager((Kernel)this.kernel);
        if (mgr != null) {
            try {
                mgr.removeGBeanFromConfiguration(brokerAbstractName.getArtifact(), brokerAbstractName);
            }
            catch (InvalidConfigException e) {
                log.error("Unable to remove ActiveMQ broker [" + brokerAbstractName + "]", (Throwable)e);
                throw e;
            }
            catch (GBeanNotFoundException e) {
                log.error("Fail to get ActiveMQ broker from kernel [" + brokerAbstractName + "]");
                throw e;
            }
            finally {
                ConfigurationUtil.releaseConfigurationManager((Kernel)this.kernel, (ConfigurationManager)mgr);
            }
        } else {
            log.warn("The ConfigurationManager in the kernel does not allow editing");
        }
    }
}

