/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.activemq;

import java.util.Map;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.KernelRegistry;
import org.apache.geronimo.system.configuration.LocalAttributeManager;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigSubstitutionsHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigSubstitutionsHelper.class);

    public static Map<String, Object> getSubstitutions(BundleContext bundleContext, Map<String, Object> defaultSubstitutions) {
        Kernel kernel = KernelRegistry.getSingleKernel();
        if (kernel != null) {
            try {
                LocalAttributeManager attributeManager = (LocalAttributeManager)kernel.getGBean(LocalAttributeManager.class);
                if (attributeManager != null) {
                    return attributeManager.getConfigSubstitutionsVariables();
                }
            }
            catch (Exception e) {
                LOG.debug("Error getting config substitutions", (Throwable)e);
            }
        }
        return defaultSubstitutions;
    }
}

