/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.logging.log4j;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import org.apache.log4j.LogManager;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.spi.Configurator;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.xml.DOMConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLConfigurator
implements Configurator {
    private static final Logger log = LoggerFactory.getLogger(URLConfigurator.class);

    public static void configure(URL url) {
        new URLConfigurator().doConfigure(url, LogManager.getLoggerRepository());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Configurator getConfigurator(URL url) throws FileNotFoundException {
        String contentType = null;
        URLConnection connection = null;
        try {
            connection = url.openConnection();
            contentType = connection.getContentType();
            if (log.isTraceEnabled()) {
                log.trace("Content type: " + contentType);
            }
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            log.warn("Could not determine content type from URL; ignoring", (Throwable)e);
        }
        if (contentType != null && contentType.toLowerCase().endsWith("/xml")) {
            return new DOMConfigurator();
        }
        String filename = url.getFile().toLowerCase();
        if (filename.endsWith(".xml")) {
            return new DOMConfigurator();
        }
        if (filename.endsWith(".properties")) {
            return new PropertyConfigurator();
        }
        if (connection != null) {
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                try {
                    String head = reader.readLine();
                    if (head.startsWith("<?xml")) {
                        DOMConfigurator dOMConfigurator = new DOMConfigurator();
                        return dOMConfigurator;
                    }
                }
                finally {
                    reader.close();
                }
            }
            catch (IOException e) {
                log.warn("Failed to check content header; ignoring", (Throwable)e);
            }
        }
        log.warn("Unable to determine content type, using property configurator");
        return new PropertyConfigurator();
    }

    public void doConfigure(URL url, LoggerRepository repo) {
        if (log.isDebugEnabled()) {
            log.debug("Configuring from URL: " + url);
        }
        Configurator delegate = null;
        try {
            delegate = this.getConfigurator(url);
        }
        catch (FileNotFoundException e) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace("Configuring Log4j using configurator: " + delegate + ", repository: " + repo);
        }
        delegate.doConfigure(url, repo);
    }
}

