/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.configuration;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import org.apache.geronimo.kernel.config.ConfigurationData;

public class InPlaceConfigurationUtil {
    private static final String IN_PLACE_LOCATION_FILE = "inPlaceLocation.config";

    public boolean isInPlaceConfiguration(File source) {
        File inPlaceLocation = this.getInPlaceLocation(source);
        return inPlaceLocation.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeInPlaceLocation(ConfigurationData configurationData, File source) throws IOException {
        if (null == configurationData.getInPlaceConfigurationDir()) {
            return;
        }
        File inPlaceLocation = this.getInPlaceLocation(source);
        Writer writer = null;
        try {
            FileOutputStream os = new FileOutputStream(inPlaceLocation);
            writer = new PrintWriter(os);
            File inPlaceConfigurationDir = configurationData.getInPlaceConfigurationDir();
            String absolutePath = inPlaceConfigurationDir.getAbsolutePath();
            writer.write(absolutePath);
            writer.close();
            writer = null;
        }
        finally {
            if (null != writer) {
                try {
                    writer.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File readInPlaceLocation(File source) throws IOException {
        File inPlaceLocation = this.getInPlaceLocation(source);
        if (!inPlaceLocation.exists()) {
            return null;
        }
        BufferedReader reader = null;
        try {
            FileInputStream is = new FileInputStream(inPlaceLocation);
            reader = new BufferedReader(new InputStreamReader(is));
            String path = reader.readLine();
            File file = new File(path);
            return file;
        }
        finally {
            if (null != reader) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private File getInPlaceLocation(File source) {
        File inPlaceLocation = new File(source, "META-INF");
        inPlaceLocation.mkdirs();
        return new File(inPlaceLocation, IN_PLACE_LOCATION_FILE);
    }
}

