/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.plugin;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.kernel.repository.ArtifactManager;
import org.apache.geronimo.kernel.repository.ListableRepository;
import org.apache.geronimo.system.configuration.LocalAttributeManager;
import org.apache.geronimo.system.configuration.LocalPluginAttributeStore;
import org.apache.geronimo.system.configuration.PluginAttributeStore;
import org.apache.geronimo.system.plugin.ServerInstance;
import org.apache.geronimo.system.resolver.AliasedArtifactResolver;
import org.apache.geronimo.system.resolver.ExplicitDefaultArtifactResolver;
import org.apache.geronimo.system.serverinfo.ServerInfo;

public class ServerInstanceData {
    private String name;
    private String attributeManagerFrom;
    private String configFile = "var/config/config.xml";
    private String configSubstitutionsFile = "var/config/config-substitutions.properties";
    private String configSubstitutionsPrefix = "org.apache.geronimo.config.substitution.";
    private String artifactAliasesFile = "var/config/artifact_aliases.properties";
    public static final GBeanInfo GBEAN_INFO;

    public ServerInstanceData() {
    }

    public ServerInstanceData(ServerInstanceData toCopy) {
        this.name = toCopy.getName();
        this.attributeManagerFrom = toCopy.getAttributeManagerFrom();
        this.configFile = toCopy.getConfigFile();
        this.configSubstitutionsFile = toCopy.getConfigSubstitutionsFile();
        this.configSubstitutionsPrefix = toCopy.getConfigSubstitutionsPrefix();
        this.artifactAliasesFile = toCopy.getArtifactAliasesFile();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAttributeManagerFrom() {
        return this.attributeManagerFrom;
    }

    public void setAttributeManagerFrom(String attributeManagerFrom) {
        this.attributeManagerFrom = attributeManagerFrom;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public String getConfigSubstitutionsFile() {
        return this.configSubstitutionsFile;
    }

    public void setConfigSubstitutionsFile(String configSubstitutionsFile) {
        this.configSubstitutionsFile = configSubstitutionsFile;
    }

    public String getConfigSubstitutionsPrefix() {
        return this.configSubstitutionsPrefix;
    }

    public void setConfigSubstitutionsPrefix(String configSubstitutionsPrefix) {
        this.configSubstitutionsPrefix = configSubstitutionsPrefix;
    }

    public String getArtifactAliasesFile() {
        return this.artifactAliasesFile;
    }

    public void setArtifactAliasesFile(String artifactAliasesFile) {
        this.artifactAliasesFile = artifactAliasesFile;
    }

    public ServerInstance getServerInstance(ArtifactManager artifactManager, ListableRepository targetRepo, ServerInfo serverInfo, Map<String, ServerInstance> serverInstances, boolean live) throws IOException {
        LocalAttributeManager attributeStore;
        ExplicitDefaultArtifactResolver geronimoArtifactResolver = new ExplicitDefaultArtifactResolver(this.getArtifactAliasesFile(), artifactManager, Collections.singleton(targetRepo), serverInfo);
        if (this.attributeManagerFrom == null) {
            attributeStore = new LocalAttributeManager(this.getConfigFile(), this.getConfigSubstitutionsFile(), this.getConfigSubstitutionsPrefix(), false, serverInfo);
            attributeStore.load();
        } else {
            ServerInstance shared = serverInstances.get(this.attributeManagerFrom);
            if (shared == null) {
                throw new IllegalArgumentException("Incorrect configuration: no server instance named '" + this.attributeManagerFrom + "' defined before being shared from '" + this.name + "'");
            }
            attributeStore = (LocalPluginAttributeStore)shared.getAttributeStore();
        }
        return new ServerInstance(this.name, (PluginAttributeStore)attributeStore, (AliasedArtifactResolver)geronimoArtifactResolver);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("ServerInstanceData:\n");
        buf.append("  Name: ").append(this.getName()).append("\n");
        buf.append("  AttributeManagerFrom: ").append(this.getAttributeManagerFrom()).append("\n");
        buf.append("  ConfigFile: ").append(this.getConfigFile()).append("\n");
        buf.append("  ConfigSubstitutionsFile: ").append(this.getConfigSubstitutionsFile()).append("\n");
        buf.append("  ConfigSubstitutionsPrefix: ").append(this.getConfigSubstitutionsPrefix()).append("\n");
        buf.append("  ArtifactAliasesFile: ").append(this.getArtifactAliasesFile()).append("\n");
        return buf.toString();
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic(ServerInstanceData.class, (String)"ServerInstanceData");
        infoFactory.addAttribute("name", String.class, true, true);
        infoFactory.addAttribute("attributeManagerFrom", String.class, true, true);
        infoFactory.addAttribute("configFile", String.class, true, true);
        infoFactory.addAttribute("configSubstitutionsFile", String.class, true, true);
        infoFactory.addAttribute("configSubstitutionsPrefix", String.class, true, true);
        infoFactory.addAttribute("artifactAliasesFile", String.class, true, true);
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

