/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.plugin;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import javax.security.auth.login.FailedLoginException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.geronimo.gbean.ReferenceCollection;
import org.apache.geronimo.gbean.ReferenceCollectionEvent;
import org.apache.geronimo.gbean.ReferenceCollectionListener;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.gbean.annotation.ParamSpecial;
import org.apache.geronimo.gbean.annotation.SpecialAttributeType;
import org.apache.geronimo.kernel.InvalidGBeanException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.basic.BasicKernel;
import org.apache.geronimo.kernel.config.ConfigurationAlreadyExistsException;
import org.apache.geronimo.kernel.config.ConfigurationData;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationStore;
import org.apache.geronimo.kernel.config.InvalidConfigException;
import org.apache.geronimo.kernel.config.KernelConfigurationManager;
import org.apache.geronimo.kernel.config.ManageableAttributeStore;
import org.apache.geronimo.kernel.config.NoSuchConfigException;
import org.apache.geronimo.kernel.config.NoSuchStoreException;
import org.apache.geronimo.kernel.config.PersistentConfigurationList;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.ArtifactManager;
import org.apache.geronimo.kernel.repository.ArtifactResolver;
import org.apache.geronimo.kernel.repository.DefaultArtifactManager;
import org.apache.geronimo.kernel.repository.Dependency;
import org.apache.geronimo.kernel.repository.FileWriteMonitor;
import org.apache.geronimo.kernel.repository.ImportType;
import org.apache.geronimo.kernel.repository.ListableRepository;
import org.apache.geronimo.kernel.repository.MissingDependencyException;
import org.apache.geronimo.kernel.repository.Repository;
import org.apache.geronimo.kernel.repository.Version;
import org.apache.geronimo.kernel.repository.WritableListableRepository;
import org.apache.geronimo.kernel.repository.WriteableRepository;
import org.apache.geronimo.kernel.util.XmlUtil;
import org.apache.geronimo.system.configuration.ConfigurationStoreUtil;
import org.apache.geronimo.system.configuration.PluginAttributeStore;
import org.apache.geronimo.system.configuration.RepositoryConfigurationStore;
import org.apache.geronimo.system.plugin.DownloadPoller;
import org.apache.geronimo.system.plugin.DownloadResults;
import org.apache.geronimo.system.plugin.GeronimoSourceRepository;
import org.apache.geronimo.system.plugin.NoServerInstanceException;
import org.apache.geronimo.system.plugin.OpenResult;
import org.apache.geronimo.system.plugin.PluginInstaller;
import org.apache.geronimo.system.plugin.PluginRepositoryList;
import org.apache.geronimo.system.plugin.PluginXmlUtil;
import org.apache.geronimo.system.plugin.ServerInstance;
import org.apache.geronimo.system.plugin.ServerInstanceData;
import org.apache.geronimo.system.plugin.SourceRepository;
import org.apache.geronimo.system.plugin.model.ArtifactType;
import org.apache.geronimo.system.plugin.model.AttributesType;
import org.apache.geronimo.system.plugin.model.ConfigXmlContentType;
import org.apache.geronimo.system.plugin.model.CopyFileType;
import org.apache.geronimo.system.plugin.model.DependencyType;
import org.apache.geronimo.system.plugin.model.HashType;
import org.apache.geronimo.system.plugin.model.LicenseType;
import org.apache.geronimo.system.plugin.model.ModuleType;
import org.apache.geronimo.system.plugin.model.PluginArtifactType;
import org.apache.geronimo.system.plugin.model.PluginListType;
import org.apache.geronimo.system.plugin.model.PluginType;
import org.apache.geronimo.system.plugin.model.PrerequisiteType;
import org.apache.geronimo.system.plugin.model.PropertyType;
import org.apache.geronimo.system.repository.Maven2Repository;
import org.apache.geronimo.system.serverinfo.BasicServerInfo;
import org.apache.geronimo.system.serverinfo.ServerInfo;
import org.apache.geronimo.system.threads.ThreadPool;
import org.codehaus.plexus.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GBean
public class PluginInstallerGBean
implements PluginInstaller {
    private static final Logger log = LoggerFactory.getLogger(PluginInstallerGBean.class);
    private static int counter;
    private final String installedPluginsList;
    private final Set<Artifact> installedArtifacts = new HashSet<Artifact>();
    private final ConfigurationManager configManager;
    private final GeronimoSourceRepository localSourceRepository;
    private final WritableListableRepository writeableRepo;
    private final ConfigurationStore configStore;
    private final ServerInfo serverInfo;
    private final Map<Object, DownloadResults> asyncKeys;
    private final ThreadPool threadPool;
    private final Collection<? extends ServerInstanceData> serverInstanceDatas;
    private final ClassLoader classLoader;
    private final Map<String, ServerInstance> servers = new HashMap<String, ServerInstance>();
    private final Collection<PersistentConfigurationList> persistentConfigurationLists;
    private final PluginRepositoryList pluginRepositoryList;
    private static final Pattern MAVEN_1_PATTERN_PART;

    public PluginInstallerGBean(@ParamAttribute(name="installedPluginsList") String installedPluginsList, @ParamReference(name="ConfigManager", namingType="ConfigurationManager") ConfigurationManager configManager, @ParamReference(name="Repository", namingType="Repository") WritableListableRepository repository, @ParamReference(name="ConfigStore", namingType="ConfigurationStore") ConfigurationStore configStore, @ParamReference(name="ServerInstances", namingType="ServerInstanceData") Collection<ServerInstanceData> serverInstanceDatas, @ParamReference(name="ServerInfo") ServerInfo serverInfo, @ParamReference(name="ThreadPool") ThreadPool threadPool, @ParamReference(name="ArtifactManager") ArtifactManager artifactManager, @ParamReference(name="PersistentConfigurationLists", namingType="AttributeStore") Collection<PersistentConfigurationList> persistentConfigurationLists, @ParamReference(name="PluginRepositoryList") PluginRepositoryList pluginRepositoryList, @ParamSpecial(type=SpecialAttributeType.classLoader) ClassLoader classLoader) throws IOException {
        this(installedPluginsList, configManager, repository, configStore, serverInstanceDatas, serverInfo, threadPool, artifactManager, persistentConfigurationLists, pluginRepositoryList, classLoader, true);
    }

    private PluginInstallerGBean(String installedPluginsList, ConfigurationManager configManager, WritableListableRepository repository, ConfigurationStore configStore, Collection<? extends ServerInstanceData> serverInstanceDatas, ServerInfo serverInfo, ThreadPool threadPool, ArtifactManager artifactManager, Collection<PersistentConfigurationList> persistentConfigurationLists, PluginRepositoryList pluginRepositoryList, ClassLoader classLoader, boolean live) throws IOException {
        this.writeableRepo = repository;
        this.configStore = configStore;
        this.serverInfo = serverInfo;
        this.threadPool = threadPool;
        this.asyncKeys = Collections.synchronizedMap(new HashMap());
        this.serverInstanceDatas = serverInstanceDatas;
        if (artifactManager == null) {
            artifactManager = new DefaultArtifactManager();
        }
        PluginInstallerGBean.setUpServerInstances(serverInstanceDatas, serverInfo, artifactManager, this.servers, this.writeableRepo, live);
        this.persistentConfigurationLists = persistentConfigurationLists == null ? Collections.emptyList() : persistentConfigurationLists;
        this.classLoader = classLoader;
        if (configManager == null) {
            throw new IllegalArgumentException("No default server instance set up");
        }
        this.configManager = configManager;
        this.localSourceRepository = new GeronimoSourceRepository(configManager.getRepositories(), configManager.getArtifactResolver());
        this.pluginRepositoryList = pluginRepositoryList;
        this.installedPluginsList = installedPluginsList;
        this.loadHistory();
    }

    public PluginInstallerGBean(String targetRepositoryPath, String targetServerPath, String installedPluginsList, Collection<? extends ServerInstanceData> serverInstanceDatas, PluginRepositoryList pluginRepositoryList, Kernel kernel, ClassLoader classLoader) throws Exception {
        DefaultArtifactManager artifactManager = new DefaultArtifactManager();
        FileUtils.forceMkdir((File)new File(targetServerPath));
        this.serverInfo = new BasicServerInfo(targetServerPath, false);
        File targetRepositoryFile = this.serverInfo.resolve(targetRepositoryPath);
        FileUtils.forceMkdir((File)targetRepositoryFile);
        this.writeableRepo = new Maven2Repository(targetRepositoryFile);
        this.configStore = new RepositoryConfigurationStore(this.writeableRepo);
        this.threadPool = null;
        this.asyncKeys = Collections.synchronizedMap(new HashMap());
        this.serverInstanceDatas = serverInstanceDatas;
        this.persistentConfigurationLists = Collections.emptyList();
        this.classLoader = classLoader;
        PluginInstallerGBean.setUpServerInstances(serverInstanceDatas, this.serverInfo, (ArtifactManager)artifactManager, this.servers, this.writeableRepo, false);
        this.configManager = PluginInstallerGBean.buildConfigurationManager((ArtifactManager)artifactManager, this.writeableRepo, kernel, this.configStore, classLoader, this.servers);
        this.localSourceRepository = new GeronimoSourceRepository(this.configManager.getRepositories(), this.configManager.getArtifactResolver());
        this.pluginRepositoryList = pluginRepositoryList;
        this.installedPluginsList = installedPluginsList;
        this.loadHistory();
    }

    public PluginInstallerGBean pluginInstallerCopy(String serverName, Kernel kernel) throws Exception {
        BasicServerInfo newServerInfo = new BasicServerInfo(this.serverInfo.getCurrentBaseDirectory(), serverName);
        DefaultArtifactManager artifactManager = new DefaultArtifactManager();
        ConfigurationManager configManager = PluginInstallerGBean.buildConfigurationManager((ArtifactManager)artifactManager, this.writeableRepo, kernel, this.configStore, this.classLoader, this.servers);
        return new PluginInstallerGBean(this.installedPluginsList, configManager, this.writeableRepo, this.configStore, this.serverInstanceDatas, (ServerInfo)newServerInfo, this.threadPool, (ArtifactManager)artifactManager, this.persistentConfigurationLists, this.pluginRepositoryList, this.classLoader, false);
    }

    private static void setUpServerInstances(Collection<? extends ServerInstanceData> serverInstanceDatas, final ServerInfo serverInfo, final ArtifactManager artifactManager, final Map<String, ServerInstance> servers, final WritableListableRepository writeableRepo, final boolean live) throws IOException {
        ArrayList<? extends ServerInstanceData> datas = new ArrayList<ServerInstanceData>(serverInstanceDatas);
        boolean shrank = true;
        while (shrank) {
            shrank = false;
            Iterator it = datas.iterator();
            while (it.hasNext()) {
                ServerInstanceData instance = (ServerInstanceData)it.next();
                String dependsOn = instance.getAttributeManagerFrom();
                if (dependsOn != null && !servers.containsKey(dependsOn)) continue;
                PluginInstallerGBean.addServerInstance(instance, artifactManager, writeableRepo, serverInfo, servers, live);
                it.remove();
                shrank = true;
            }
        }
        if (!datas.isEmpty()) {
            throw new IllegalStateException("Cannot resolve ServerInstanceDatas: " + datas);
        }
        if (serverInstanceDatas instanceof ReferenceCollection) {
            ((ReferenceCollection)serverInstanceDatas).addReferenceCollectionListener(new ReferenceCollectionListener(){

                public void memberAdded(ReferenceCollectionEvent event) {
                    ServerInstanceData instance = (ServerInstanceData)event.getMember();
                    try {
                        PluginInstallerGBean.addServerInstance(instance, artifactManager, writeableRepo, serverInfo, servers, live);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }

                public void memberRemoved(ReferenceCollectionEvent event) {
                    ServerInstanceData instance = (ServerInstanceData)event.getMember();
                    servers.remove(instance.getName());
                }
            });
        }
    }

    private static void addServerInstance(ServerInstanceData serverInstance, ArtifactManager artifactManager, WritableListableRepository targetRepo, ServerInfo serverInfo, Map<String, ServerInstance> servers, boolean live) throws IOException {
        File targetConfigDirectory = serverInfo.resolveServer(serverInstance.getConfigFile()).getParentFile();
        FileUtils.forceMkdir((File)targetConfigDirectory);
        ServerInstance instance = serverInstance.getServerInstance(artifactManager, (ListableRepository)targetRepo, serverInfo, servers, live);
        servers.put(instance.getServerName(), instance);
    }

    private static ConfigurationManager buildConfigurationManager(ArtifactManager artifactManager, WritableListableRepository targetRepo, Kernel kernel, ConfigurationStore targetStore, ClassLoader classloader, Map<String, ServerInstance> servers) throws IOException {
        for (ServerInstance instance : servers.values()) {
            if (!"default".equals(instance.getServerName())) continue;
            KernelConfigurationManager configurationManager = new KernelConfigurationManager(kernel, Collections.singleton(targetStore), (ManageableAttributeStore)instance.getAttributeStore(), (PersistentConfigurationList)instance.getAttributeStore(), artifactManager, (ArtifactResolver)instance.getArtifactResolver(), Collections.singleton(targetRepo), null, classloader);
            configurationManager.setOnline(false);
            return configurationManager;
        }
        throw new IllegalStateException("No default server instance found: " + servers.keySet());
    }

    PluginInstallerGBean(ConfigurationManager configManager, WritableListableRepository repository, ConfigurationStore configStore, String installedPluginsList, ServerInfo serverInfo, ThreadPool threadPool, Collection<ServerInstance> servers, PluginRepositoryList pluginRepositoryList) {
        this.configManager = configManager;
        this.localSourceRepository = new GeronimoSourceRepository(configManager.getRepositories(), configManager.getArtifactResolver());
        this.writeableRepo = repository;
        this.configStore = configStore;
        this.serverInfo = serverInfo;
        this.threadPool = threadPool;
        this.asyncKeys = Collections.synchronizedMap(new HashMap());
        this.serverInstanceDatas = null;
        this.persistentConfigurationLists = Collections.emptyList();
        this.classLoader = null;
        for (ServerInstance instance : servers) {
            this.servers.put(instance.getServerName(), instance);
        }
        if (servers instanceof ReferenceCollection) {
            ((ReferenceCollection)servers).addReferenceCollectionListener(new ReferenceCollectionListener(){

                public void memberAdded(ReferenceCollectionEvent event) {
                    ServerInstance instance = (ServerInstance)event.getMember();
                    PluginInstallerGBean.this.servers.put(instance.getServerName(), instance);
                }

                public void memberRemoved(ReferenceCollectionEvent event) {
                    ServerInstance instance = (ServerInstance)event.getMember();
                    PluginInstallerGBean.this.servers.remove(instance.getServerName());
                }
            });
        }
        this.pluginRepositoryList = pluginRepositoryList;
        this.installedPluginsList = installedPluginsList;
        this.loadHistory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadHistory() {
        if (this.installedPluginsList != null) {
            File historyFile = this.serverInfo.resolveServer(this.installedPluginsList);
            Properties properties = new Properties();
            try {
                FileInputStream in = new FileInputStream(historyFile);
                try {
                    properties.load(in);
                    for (Object key : properties.keySet()) {
                        Artifact artifact = Artifact.create((String)((String)key));
                        this.installedArtifacts.add(artifact);
                    }
                }
                finally {
                    ((InputStream)in).close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveHistory() {
        if (this.installedPluginsList != null) {
            Properties properties = new Properties();
            for (Artifact artifact : this.installedArtifacts) {
                properties.setProperty(artifact.toString(), "");
            }
            try {
                File historyFile = this.serverInfo.resolveServer(this.installedPluginsList);
                File parentFile = historyFile.getParentFile();
                if (!parentFile.exists()) {
                    FileUtils.forceMkdir((File)parentFile);
                }
                FileOutputStream out = new FileOutputStream(historyFile);
                try {
                    properties.save(out, "All the plugins that have ever been installed on this server");
                }
                finally {
                    ((OutputStream)out).close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DownloadResults installPluginList(String targetRepositoryPath, String relativeTargetServerPath, PluginListType pluginList) throws Exception {
        DownloadResults downloadPoller = new DownloadResults();
        File targetServerPath = this.serverInfo.resolveServer(relativeTargetServerPath);
        if (targetServerPath.exists()) {
            FileUtils.forceDelete((File)targetServerPath);
        }
        String targetServerPathName = targetServerPath.getAbsolutePath();
        BasicKernel kernel = new BasicKernel("assembly");
        try {
            PluginInstallerGBean installer = new PluginInstallerGBean(targetRepositoryPath, targetServerPathName, this.installedPluginsList, this.serverInstanceDatas, this.pluginRepositoryList, (Kernel)kernel, this.classLoader);
            installer.install(pluginList, this.localSourceRepository, true, null, null, (DownloadPoller)downloadPoller);
        }
        finally {
            kernel.shutdown();
        }
        return downloadPoller;
    }

    @Override
    public void mergeOverrides(String server, AttributesType overrides) throws InvalidGBeanException, IOException {
        ServerInstance serverInstance = this.servers.get(server);
        if (serverInstance == null) {
            throw new NullPointerException("No such server: " + server + ", known servers: " + this.servers.keySet());
        }
        PluginAttributeStore attributeStore = serverInstance.getAttributeStore();
        for (ModuleType module : overrides.getModule()) {
            Artifact artifact = Artifact.create((String)module.getName());
            attributeStore.setModuleGBeans(artifact, module.getGbean(), module.isLoad(), module.getCondition());
            attributeStore.save();
        }
        if (overrides.getConfiguration().size() > 0) {
            throw new UnsupportedOperationException("Use modules, not configurations");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Artifact> getInstalledPlugins() {
        SortedSet artifacts = this.writeableRepo.list();
        HashMap<String, Artifact> plugins = new HashMap<String, Artifact>();
        for (Artifact configId : artifacts) {
            File dir = this.writeableRepo.getLocation(configId);
            if (dir.isDirectory()) {
                File xml;
                File meta = new File(dir, "META-INF");
                if (!meta.isDirectory() || !meta.canRead() || !(xml = new File(meta, "geronimo-plugin.xml")).isFile() || !xml.canRead() || xml.length() == 0L) continue;
                this.readNameAndID(xml, plugins);
                continue;
            }
            if (!dir.isFile() || !dir.canRead()) {
                log.error("Cannot read artifact dir {}", (Object)dir.getAbsolutePath());
                throw new IllegalStateException("Cannot read artifact dir " + dir.getAbsolutePath());
            }
            try {
                JarFile jar = new JarFile(dir);
                try {
                    ZipEntry entry = jar.getEntry("META-INF/geronimo-plugin.xml");
                    if (entry == null) continue;
                    InputStream in = jar.getInputStream(entry);
                    this.readNameAndID(in, plugins);
                    in.close();
                }
                finally {
                    jar.close();
                }
            }
            catch (IOException e) {
                log.error("Unable to read JAR file {}", (Object)dir.getAbsolutePath(), (Object)e);
            }
        }
        return plugins;
    }

    @Override
    public PluginType getPluginMetadata(Artifact moduleId) {
        PluginType type = this.localSourceRepository.extractPluginMetadata(moduleId);
        if (null == type) {
            try {
                type = this.createDefaultMetadata(moduleId);
            }
            catch (InvalidConfigException e) {
                log.warn("Unable to generate metadata for " + moduleId, (Throwable)e);
            }
            catch (Exception e) {
                log.warn("Error generating metadata for " + moduleId, (Throwable)e);
            }
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePluginMetadata(PluginType metadata) {
        block23: {
            PluginArtifactType instance = (PluginArtifactType)metadata.getPluginArtifact().get(0);
            Artifact artifact = PluginInstallerGBean.toArtifact(instance.getModuleId());
            File dir = this.writeableRepo.getLocation(artifact);
            if (dir == null) {
                log.error("{} is not installed", (Object)artifact);
                throw new IllegalArgumentException(artifact + " is not installed.");
            }
            if (!dir.isDirectory()) {
                try {
                    File temp = new File(dir.getParentFile(), dir.getName() + ".temp");
                    JarFile input = new JarFile(dir);
                    Manifest manifest = input.getManifest();
                    JarOutputStream out = manifest == null ? new JarOutputStream(new BufferedOutputStream(new FileOutputStream(temp))) : new JarOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(temp)), manifest);
                    Enumeration<JarEntry> en = input.entries();
                    byte[] buf = new byte[4096];
                    while (en.hasMoreElements()) {
                        int count;
                        JarEntry entry = en.nextElement();
                        if (entry.getName().equals("META-INF/geronimo-plugin.xml")) {
                            entry = new JarEntry(entry.getName());
                            out.putNextEntry(entry);
                            PluginXmlUtil.writePluginMetadata(metadata, out);
                            continue;
                        }
                        if (entry.getName().equals("META-INF/MANIFEST.MF")) continue;
                        out.putNextEntry(entry);
                        InputStream in = input.getInputStream(entry);
                        while ((count = in.read(buf)) > -1) {
                            out.write(buf, 0, count);
                        }
                        in.close();
                        out.closeEntry();
                    }
                    out.flush();
                    out.close();
                    input.close();
                    if (!dir.delete()) {
                        log.error("Unable to delete old plugin at {}", (Object)dir.getAbsolutePath());
                        throw new IOException("Unable to delete old plugin at " + dir.getAbsolutePath());
                    }
                    if (!temp.renameTo(dir)) {
                        log.error("Unable to move new plugin {} to {}", (Object)temp.getAbsolutePath(), (Object)dir.getAbsolutePath());
                        throw new IOException("Unable to move new plugin " + temp.getAbsolutePath() + " to " + dir.getAbsolutePath());
                    }
                    break block23;
                }
                catch (Exception e) {
                    log.error("Unable to update plugin metadata", (Throwable)e);
                    throw new RuntimeException("Unable to update plugin metadata", e);
                }
            }
            File meta = new File(dir, "META-INF");
            if (!meta.isDirectory() || !meta.canRead()) {
                log.error("{} is not a plugin", (Object)artifact);
                throw new IllegalArgumentException(artifact + " is not a plugin.");
            }
            File xml = new File(meta, "geronimo-plugin.xml");
            FileOutputStream fos = null;
            try {
                if (!xml.isFile() && !xml.createNewFile()) {
                    log.error("Cannot create plugin metadata file for {}", (Object)artifact);
                    throw new RuntimeException("Cannot create plugin metadata file for " + artifact);
                }
                fos = new FileOutputStream(xml);
                PluginXmlUtil.writePluginMetadata(metadata, fos);
            }
            catch (Exception e) {
                log.error("Unable to save plugin metadata for " + artifact, (Throwable)e);
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException ignored) {}
                }
            }
        }
    }

    @Override
    public PluginListType listPlugins(URL mavenRepository) throws IOException, FailedLoginException {
        try {
            SourceRepository repo = this.pluginRepositoryList.getSourceRepository(mavenRepository.toString());
            if (repo != null) {
                return repo.getPluginList();
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return null;
    }

    private SourceRepository getDefaultSourceRepository(String defaultRepository, boolean restrictToDefaultRepository) {
        if (restrictToDefaultRepository && defaultRepository == null) {
            throw new IllegalArgumentException("You must supply a default repository if you want to restrict to it");
        }
        SourceRepository defaultSourceRepository = defaultRepository == null ? null : this.pluginRepositoryList.getSourceRepository(defaultRepository);
        return defaultSourceRepository;
    }

    @Override
    public DownloadResults install(PluginListType pluginsToInstall, String defaultRepository, boolean restrictToDefaultRepository, String username, String password) {
        DownloadResults results = new DownloadResults();
        this.install(pluginsToInstall, defaultRepository, restrictToDefaultRepository, username, password, (DownloadPoller)results);
        return results;
    }

    @Override
    public void install(PluginListType pluginsToInstall, String defaultRepository, boolean restrictToDefaultRepository, String username, String password, DownloadPoller poller) {
        SourceRepository defaultSourceRepository = this.getDefaultSourceRepository(defaultRepository, restrictToDefaultRepository);
        this.install(pluginsToInstall, defaultSourceRepository, restrictToDefaultRepository, username, password, poller);
    }

    public void install(PluginListType pluginsToInstall, SourceRepository defaultRepository, boolean restrictToDefaultRepository, String username, String password, DownloadPoller poller) {
        this.install(pluginsToInstall, defaultRepository, restrictToDefaultRepository, username, password, poller, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void install(PluginListType pluginsToInstall, SourceRepository defaultRepository, boolean restrictToDefaultRepository, String username, String password, DownloadPoller poller, boolean validatePlugins) {
        ArrayList<Artifact> downloadedArtifacts = new ArrayList<Artifact>();
        try {
            PluginArtifactType instance;
            HashMap<Artifact, PluginType> metaMap = new HashMap<Artifact, PluginType>();
            ArrayList<PluginType> toInstall = new ArrayList<PluginType>();
            for (PluginType metadata : pluginsToInstall.getPlugin()) {
                try {
                    if (validatePlugins) {
                        if (!this.validatePlugin(metadata)) {
                            throw new MissingDependencyException("Already installed", PluginInstallerGBean.toArtifact(((PluginArtifactType)metadata.getPluginArtifact().get(0)).getModuleId()), (Stack)null);
                        }
                        this.verifyPrerequisites(metadata);
                    }
                    if ((instance = (PluginArtifactType)metadata.getPluginArtifact().get(0)).getModuleId() != null && metadata.isPluginGroup() != null && !metadata.isPluginGroup().booleanValue()) {
                        metaMap.put(PluginInstallerGBean.toArtifact(instance.getModuleId()), metadata);
                    }
                    toInstall.add(metadata);
                }
                catch (MissingDependencyException e) {
                    poller.addSkippedConfigID(e);
                }
            }
            for (PluginType metadata : toInstall) {
                instance = (PluginArtifactType)metadata.getPluginArtifact().get(0);
                ArrayList<Artifact> obsoletes = new ArrayList<Artifact>();
                for (ArtifactType obs : instance.getObsoletes()) {
                    Artifact[] list;
                    Artifact obsolete = PluginInstallerGBean.toArtifact(obs);
                    for (Artifact artifact : list = this.configManager.getArtifactResolver().queryArtifacts(obsolete)) {
                        if (!this.configManager.isLoaded(artifact)) continue;
                        if (this.configManager.isRunning(artifact)) {
                            this.configManager.stopConfiguration(artifact);
                        }
                        this.configManager.unloadConfiguration(artifact);
                        obsoletes.add(artifact);
                    }
                }
                HashSet<Artifact> working = new HashSet<Artifact>();
                Stack<Artifact> parentStack = new Stack<Artifact>();
                if (instance.getModuleId() != null) {
                    Artifact entry = PluginInstallerGBean.toArtifact(instance.getModuleId());
                    List<SourceRepository> repos = this.getRepos(pluginsToInstall, defaultRepository, restrictToDefaultRepository, instance);
                    this.downloadArtifact(entry, metaMap, repos, username, password, new ResultsFileWriteMonitor(poller, log), working, parentStack, false, this.servers, true);
                    downloadedArtifacts.add(entry);
                } else {
                    List deps = instance.getDependency();
                    for (DependencyType dep : deps) {
                        Artifact entry = PluginInstallerGBean.toArtifact((ArtifactType)dep);
                        List<SourceRepository> repos = this.getRepos(pluginsToInstall, defaultRepository, restrictToDefaultRepository, instance);
                        this.downloadArtifact(entry, metaMap, repos, username, password, new ResultsFileWriteMonitor(poller, log), working, parentStack, false, this.servers, dep.isStart());
                        downloadedArtifacts.add(entry);
                    }
                }
                for (Artifact artifact : obsoletes) {
                    this.configManager.uninstallConfiguration(artifact);
                }
            }
            if (this.configManager.isOnline()) {
                poller.setCurrentFilePercent(-1);
                for (PersistentConfigurationList persistentConfigurationList : this.persistentConfigurationLists) {
                    List artifacts = persistentConfigurationList.restore();
                    for (Artifact artifact : artifacts) {
                        if (this.configManager.isRunning(artifact)) continue;
                        poller.setCurrentMessage("Starting " + artifact);
                        if (!this.configManager.isLoaded(artifact)) {
                            try {
                                this.configManager.loadConfiguration(artifact);
                            }
                            catch (Exception e) {
                                log.error("Unable to load configuration. ", (Throwable)e);
                                this.configManager.uninstallConfiguration(artifact);
                            }
                        }
                        if (!this.configManager.isLoaded(artifact)) continue;
                        this.configManager.startConfiguration(artifact);
                    }
                }
            }
            for (ServerInstance serverInstance : this.servers.values()) {
                serverInstance.getAttributeStore().save();
            }
        }
        catch (Exception e) {
            log.error("Unable to install plugin", (Throwable)e);
            poller.setFailure(e);
            for (Artifact artifact : downloadedArtifacts) {
                try {
                    this.configManager.uninstallConfiguration(artifact);
                }
                catch (Exception e2) {
                    log.warn(e2.toString(), (Throwable)e2);
                }
            }
        }
        finally {
            poller.setFinished();
        }
        this.saveHistory();
    }

    private List<SourceRepository> getRepos(PluginListType pluginsToInstall, SourceRepository defaultRepository, boolean restrictToDefaultRepository, PluginArtifactType instance) {
        ArrayList<SourceRepository> repos = new ArrayList<SourceRepository>();
        if (defaultRepository != null) {
            repos.add(defaultRepository);
        }
        if (!restrictToDefaultRepository) {
            if (!instance.getSourceRepository().isEmpty()) {
                this.addRepos(repos, instance.getSourceRepository());
            }
            this.addRepos(repos, pluginsToInstall.getDefaultRepository());
        }
        return repos;
    }

    private void addRepos(List<SourceRepository> repos, List<String> repoLocations) {
        for (String repoLocation : repoLocations) {
            try {
                SourceRepository repo = this.pluginRepositoryList.getSourceRepository(repoLocation);
                repos.add(repo);
            }
            catch (IllegalStateException e) {
                log.warn("Invalid repository: " + repoLocation, (Throwable)e);
            }
        }
    }

    @Override
    public Object startInstall(final PluginListType pluginsToInstall, final String defaultRepository, final boolean restrictToDefaultRepository, final String username, final String password) {
        Object key = PluginInstallerGBean.getNextKey();
        final DownloadResults results = new DownloadResults();
        Runnable work = new Runnable(){

            public void run() {
                PluginInstallerGBean.this.install(pluginsToInstall, defaultRepository, restrictToDefaultRepository, username, password, (DownloadPoller)results);
            }
        };
        this.asyncKeys.put(key, results);
        try {
            this.threadPool.execute("Configuration Installer", work);
        }
        catch (InterruptedException e) {
            log.error("Unable to start work", (Throwable)e);
            throw new RuntimeException("Unable to start work", e);
        }
        return key;
    }

    @Override
    public Object startInstall(final File carFile, final String defaultRepository, final boolean restrictToDefaultRepository, final String username, final String password) {
        Object key = PluginInstallerGBean.getNextKey();
        final DownloadResults results = new DownloadResults();
        Runnable work = new Runnable(){

            public void run() {
                PluginInstallerGBean.this.install(carFile, defaultRepository, restrictToDefaultRepository, username, password, (DownloadPoller)results);
            }
        };
        this.asyncKeys.put(key, results);
        try {
            this.threadPool.execute("Configuration Installer", work);
        }
        catch (InterruptedException e) {
            log.error("Unable to start work", (Throwable)e);
            throw new RuntimeException("Unable to start work", e);
        }
        return key;
    }

    @Override
    public DownloadResults checkOnInstall(Object key) {
        return this.checkOnInstall(key, true);
    }

    @Override
    public DownloadResults checkOnInstall(Object key, boolean remove) {
        DownloadResults results = this.asyncKeys.get(key);
        if (results != null && (results = results.duplicate()).isFinished() && remove) {
            this.asyncKeys.remove(key);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void install(File carFile, String defaultRepository, boolean restrictToDefaultRepository, String username, String password, DownloadPoller poller) {
        try {
            PluginType data = GeronimoSourceRepository.extractPluginMetadata(carFile);
            if (data == null) {
                log.error("Invalid Configuration Archive {} no plugin metadata found", (Object)carFile.getAbsolutePath());
                throw new IllegalArgumentException("Invalid Configuration Archive " + carFile.getAbsolutePath() + " no plugin metadata found");
            }
            if (!this.validatePlugin(data)) {
                throw new ConfigurationAlreadyExistsException("Configuration " + PluginInstallerGBean.toArtifact(((PluginArtifactType)data.getPluginArtifact().get(0)).getModuleId()) + " is already installed.");
            }
            this.verifyPrerequisites(data);
            PluginArtifactType instance = (PluginArtifactType)data.getPluginArtifact().get(0);
            if (instance.getModuleId() != null) {
                Artifact pluginArtifact = PluginInstallerGBean.toArtifact(instance.getModuleId());
                ResultsFileWriteMonitor monitor = new ResultsFileWriteMonitor(poller, log);
                this.writeableRepo.copyToRepository(carFile, pluginArtifact, (FileWriteMonitor)monitor);
                this.installConfigXMLData(pluginArtifact, instance, this.servers, true);
                if (instance.getCopyFile() != null) {
                    this.extractPluginFiles(pluginArtifact, instance, monitor);
                }
            }
            PluginListType pluginList = new PluginListType();
            pluginList.getPlugin().add(data);
            pluginList.getDefaultRepository().addAll(instance.getSourceRepository());
            SourceRepository defaultSourceRepository = this.getDefaultSourceRepository(defaultRepository, restrictToDefaultRepository);
            this.install(pluginList, defaultSourceRepository, restrictToDefaultRepository, username, password, poller, false);
        }
        catch (Exception e) {
            poller.setFailure(e);
        }
        finally {
            poller.setFinished();
        }
    }

    @Override
    public boolean validatePlugin(PluginType plugin) throws MissingDependencyException {
        if (plugin.getPluginArtifact().size() != 1) {
            throw new MissingDependencyException("A plugin configuration must include one plugin artifact, not " + plugin.getPluginArtifact().size(), null, (Stack)null);
        }
        PluginArtifactType metadata = (PluginArtifactType)plugin.getPluginArtifact().get(0);
        if (metadata.getModuleId() != null) {
            Artifact artifact = PluginInstallerGBean.toArtifact(metadata.getModuleId());
            if (plugin.isPluginGroup() != null && plugin.isPluginGroup().booleanValue()) {
                if (this.installedArtifacts.contains(artifact)) {
                    log.debug("Configuration {} is already installed", (Object)artifact);
                    return false;
                }
            } else if (this.configManager.isInstalled(artifact)) {
                boolean upgrade = false;
                for (ArtifactType obsolete : metadata.getObsoletes()) {
                    Artifact test = PluginInstallerGBean.toArtifact(obsolete);
                    if (!test.matches(artifact)) continue;
                    upgrade = true;
                    break;
                }
                if (!upgrade && this.installedArtifacts.contains(artifact)) {
                    log.debug("Configuration {} is already installed", (Object)artifact);
                    return false;
                }
            }
        }
        if (metadata.getGeronimoVersion().size() > 0 && !this.checkGeronimoVersions(metadata.getGeronimoVersion())) {
            log.debug("Plugin " + PluginInstallerGBean.toArtifact(metadata.getModuleId()) + " is not installable on Geronimo " + this.serverInfo.getVersion());
            throw new MissingDependencyException("Plugin is not installable on Geronimo " + this.serverInfo.getVersion(), PluginInstallerGBean.toArtifact(metadata.getModuleId()), (Stack)null);
        }
        if (metadata.getJvmVersion().size() > 0 && !this.checkJVMVersions(metadata.getJvmVersion())) {
            log.debug("Plugin " + PluginInstallerGBean.toArtifact(metadata.getModuleId()) + " is not installable on JVM " + System.getProperty("java.version"));
            throw new MissingDependencyException("Plugin is not installable on JVM " + System.getProperty("java.version"), PluginInstallerGBean.toArtifact(metadata.getModuleId()), (Stack)null);
        }
        return true;
    }

    @Override
    public Dependency[] checkPrerequisites(PluginType plugin) {
        List<Dependency> missingPrereqs = this.getMissingPrerequisites(plugin);
        return missingPrereqs.toArray(new Dependency[missingPrereqs.size()]);
    }

    private List<Dependency> getMissingPrerequisites(PluginType plugin) {
        if (plugin.getPluginArtifact().size() != 1) {
            throw new IllegalArgumentException("A plugin configuration must include one plugin artifact, not " + plugin.getPluginArtifact().size());
        }
        PluginArtifactType metadata = (PluginArtifactType)plugin.getPluginArtifact().get(0);
        List prereqs = metadata.getPrerequisite();
        ArrayList<Dependency> missingPrereqs = new ArrayList<Dependency>();
        for (PrerequisiteType prereq : prereqs) {
            Artifact artifact = PluginInstallerGBean.toArtifact(prereq.getId());
            try {
                if (this.getServerInstance("default", this.servers).getArtifactResolver().queryArtifacts(artifact).length != 0) continue;
                missingPrereqs.add(new Dependency(artifact, ImportType.ALL));
            }
            catch (NoServerInstanceException e) {
                throw new RuntimeException("Invalid setup, no default server instance registered");
            }
        }
        return missingPrereqs;
    }

    private void verifyPrerequisites(PluginType plugin) throws MissingDependencyException {
        List<Dependency> missingPrereqs = this.getMissingPrerequisites(plugin);
        if (!missingPrereqs.isEmpty()) {
            PluginArtifactType metadata = (PluginArtifactType)plugin.getPluginArtifact().get(0);
            Artifact moduleId = PluginInstallerGBean.toArtifact(metadata.getModuleId());
            StringBuffer buf = new StringBuffer();
            buf.append(moduleId.toString()).append(" requires ");
            Iterator<Dependency> iter = missingPrereqs.iterator();
            while (iter.hasNext()) {
                buf.append(iter.next().getArtifact().toString());
                if (!iter.hasNext()) continue;
                buf.append(", ");
            }
            buf.append(" to be installed");
            throw new MissingDependencyException(buf.toString(), null, (Artifact)null);
        }
    }

    @Override
    public Artifact installLibrary(File libFile, String groupId) throws IOException {
        Matcher matcher = MAVEN_1_PATTERN_PART.matcher("");
        matcher.reset(libFile.getName());
        if (matcher.matches()) {
            String artifactId = matcher.group(1);
            String version = matcher.group(2);
            String type = matcher.group(3);
            Artifact artifact = new Artifact(groupId != null ? groupId : "default", artifactId, version, type);
            this.writeableRepo.copyToRepository(libFile, artifact, null);
            return artifact;
        }
        throw new IllegalArgumentException("Filename " + libFile.getName() + " is not in the form <artifact>-<version>.<type>, for e.g. mylib-1.0.jar.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadArtifact(Artifact configID, Map<Artifact, PluginType> metadata, List<SourceRepository> repos, String username, String password, ResultsFileWriteMonitor monitor, Set<Artifact> soFar, Stack<Artifact> parentStack, boolean dependency, Map<String, ServerInstance> servers, boolean loadOverride) throws IOException, FailedLoginException, MissingDependencyException, NoServerInstanceException {
        if (soFar.contains(configID)) {
            return;
        }
        soFar.add(configID);
        Artifact[] matches = this.configManager.getArtifactResolver().queryArtifacts(configID);
        PluginArtifactType instance = null;
        if (matches.length == 0) {
            SourceRepository repository;
            monitor.getResults().setCurrentMessage("Downloading " + configID);
            monitor.getResults().setCurrentFilePercent(-1);
            OpenResult result = null;
            Iterator<SourceRepository> i$ = repos.iterator();
            while (i$.hasNext() && (result = (repository = i$.next()).open(configID, monitor)) == null) {
            }
            if (result == null) {
                throw new IllegalArgumentException("Could not find " + configID + " in any repo: " + repos);
            }
            if (this.configManager.getArtifactResolver().queryArtifacts(result.getArtifact()).length > 0) {
                String msg = "Not downloading " + configID + ". Query for " + configID + " resulted in " + result.getArtifact() + " which is already available in server's repository.";
                monitor.getResults().setCurrentMessage(msg);
                log.info(msg);
                result.close();
                return;
            }
            try {
                String actual;
                HashType hash;
                File tempFile = result.getFile();
                if (tempFile == null) {
                    log.error("Null filehandle was returned for " + configID);
                    throw new IllegalArgumentException("Null filehandle was returned for " + configID);
                }
                PluginType pluginData = metadata.get(configID);
                HashType hashType = hash = pluginData == null ? null : ((PluginArtifactType)pluginData.getPluginArtifact().get(0)).getHash();
                if (hash != null && !(actual = ConfigurationStoreUtil.getActualChecksum((File)tempFile, (String)hash.getType())).equals(hash.getValue())) {
                    log.error("File download incorrect (expected {} hash {} but got {})", (Object[])new String[]{hash.getType(), hash.getValue(), actual});
                    throw new IOException("File download incorrect (expected " + hash.getType() + " hash " + hash.getValue() + " but got " + actual + ")");
                }
                try {
                    PluginType realPluginData = GeronimoSourceRepository.extractPluginMetadata(tempFile);
                    if (realPluginData != null) {
                        pluginData = realPluginData;
                    }
                }
                catch (Exception e) {
                    log.error("Unable to read plugin metadata: {}", (Object)e.getMessage());
                    throw (IOException)new IOException("Unable to read plugin metadata: " + e.getMessage()).initCause(e);
                }
                if (pluginData != null) {
                    if (!this.validatePlugin(pluginData)) {
                        monitor.getResults().addSkippedConfigID(new MissingDependencyException("already installed", configID, (Stack)null));
                        return;
                    }
                    instance = (PluginArtifactType)pluginData.getPluginArtifact().get(0);
                }
                monitor.getResults().setCurrentMessage("Copying " + result.getArtifact() + " to the repository");
                result.install((WriteableRepository)this.writeableRepo, monitor);
                if (dependency) {
                    monitor.getResults().addDependencyInstalled(configID);
                    configID = result.getArtifact();
                } else {
                    configID = result.getArtifact();
                    monitor.getResults().addInstalledConfigID(configID);
                }
                if (pluginData != null) {
                    log.debug("Installed plugin with moduleId={} and name={}", (Object)((PluginArtifactType)pluginData.getPluginArtifact().get(0)).getModuleId(), (Object)pluginData.getName());
                }
                log.debug("Installed artifact={}", (Object)configID);
            }
            finally {
                result.close();
            }
        } else if (dependency) {
            monitor.getResults().addDependencyPresent(configID);
        } else {
            monitor.getResults().addInstalledConfigID(configID);
        }
        try {
            PluginType currentPlugin;
            if (!configID.isResolved()) {
                for (int i = matches.length - 1; i >= 0; --i) {
                    Artifact match = matches[i];
                    if (this.configStore.containsConfiguration(match) && this.configManager.isRunning(match)) {
                        log.debug("Found required configuration={} and it is running", (Object)match);
                        return;
                    }
                    log.debug("Either required configuration={} is not installed or it is not running", (Object)match);
                }
                configID = matches[matches.length - 1];
            }
            ConfigurationData data = null;
            if (this.configStore.containsConfiguration(configID)) {
                if (this.configManager.isRunning(configID)) {
                    return;
                }
                log.debug("Loading configuration={}", (Object)configID);
                data = this.configStore.loadConfiguration(configID);
            }
            parentStack.push(configID);
            if (instance == null && (currentPlugin = this.getPluginMetadata(configID)) != null) {
                instance = (PluginArtifactType)currentPlugin.getPluginArtifact().get(0);
            }
            if (instance == null) {
                Dependency[] dependencies;
                for (Dependency dep : dependencies = data == null ? PluginInstallerGBean.getDependencies((Repository)this.writeableRepo, configID) : PluginInstallerGBean.getDependencies(data)) {
                    Artifact artifact = dep.getArtifact();
                    log.debug("Attempting to download dependency={} for configuration={}", (Object)artifact, (Object)configID);
                    this.downloadArtifact(artifact, metadata, repos, username, password, monitor, soFar, parentStack, true, servers, loadOverride);
                }
            } else {
                List deps = instance.getDependency();
                for (DependencyType dep : deps) {
                    Artifact artifact = PluginInstallerGBean.toArtifact((ArtifactType)dep);
                    log.debug("Attempting to download dependency={} for configuration={}", (Object)artifact, (Object)configID);
                    this.downloadArtifact(artifact, metadata, repos, username, password, monitor, soFar, parentStack, true, servers, loadOverride & dep.isStart());
                }
            }
            parentStack.pop();
        }
        catch (NoSuchConfigException e) {
            log.error("Installed configuration into repository but ConfigStore does not see it: {}", (Object)e.getMessage());
            throw new IllegalStateException("Installed configuration into repository but ConfigStore does not see it: " + e.getMessage(), e);
        }
        catch (InvalidConfigException e) {
            log.error("Installed configuration into repository but ConfigStore cannot load it: {}", (Object)e.getMessage());
            throw new IllegalStateException("Installed configuration into repository but ConfigStore cannot load it: " + e.getMessage(), e);
        }
        for (ServerInstance serverInstance : servers.values()) {
            if (!serverInstance.getAttributeStore().isModuleInstalled(configID)) continue;
            this.installedArtifacts.add(configID);
            return;
        }
        if (instance != null) {
            this.installedArtifacts.add(configID);
            try {
                this.installConfigXMLData(configID, instance, servers, loadOverride);
            }
            catch (InvalidGBeanException e) {
                log.error("Invalid gbean configuration", (Throwable)e);
                throw new IllegalStateException("Invalid GBean configuration: " + e.getMessage(), e);
            }
            this.extractPluginFiles(configID, instance, monitor);
        }
    }

    private void extractPluginFiles(Artifact configID, PluginArtifactType instance, ResultsFileWriteMonitor monitor) throws IOException {
        for (CopyFileType data : instance.getCopyFile()) {
            monitor.getResults().setCurrentFilePercent(-1);
            monitor.getResults().setCurrentFile(data.getValue());
            monitor.getResults().setCurrentMessage("Copying " + data.getValue() + " from plugin to Geronimo installation");
            this.copyFile(data, configID);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void copyFile(CopyFileType data, Artifact configID) throws IOException {
        TreeSet<URL> set;
        String sourceFile = data.getValue().trim();
        try {
            set = this.configStore.resolve(configID, null, sourceFile);
        }
        catch (NoSuchConfigException e) {
            log.error("Unable to identify module {} to copy files from", (Object)configID);
            throw new IllegalStateException("Unable to identify module " + configID + " to copy files from", e);
        }
        if (set.size() == 0) {
            log.error("Installed '{}' configuration into repository but cannot locate file to copy {}", (Object)configID, (Object)sourceFile);
            return;
        }
        if (((URL)set.iterator().next()).getPath().endsWith("/")) {
            String pattern = sourceFile;
            pattern = pattern.length() == 0 || pattern.endsWith("/") ? pattern + "**" : pattern + "/**";
            try {
                set = new TreeSet<URL>(new Comparator<URL>(){

                    @Override
                    public int compare(URL o1, URL o2) {
                        return o1.getPath().compareTo(o2.getPath());
                    }
                });
                set.addAll(this.configStore.resolve(configID, null, pattern));
            }
            catch (NoSuchConfigException e) {
                log.error("Unable to list directory {} to copy files from", (Object)pattern);
                throw new IllegalStateException("Unable to list directory " + pattern + " to copy files from", e);
            }
        }
        boolean relativeToServer = "server".equals(data.getRelativeTo());
        String destDir = data.getDestDir();
        File targetDir = relativeToServer ? this.serverInfo.resolveServer(destDir) : this.serverInfo.resolve(destDir);
        PluginInstallerGBean.createDirectory(targetDir);
        URI targetURI = targetDir.toURI();
        if (!targetDir.isDirectory()) {
            log.error("Plugin install cannot write file {} to {} because {} is not a directory", (Object[])new String[]{data.getValue(), destDir, targetDir.getAbsolutePath()});
            return;
        }
        if (!targetDir.canWrite()) {
            log.error("Plugin install cannot write file {} to {} because {} is not writable", (Object[])new String[]{data.getValue(), destDir, targetDir.getAbsolutePath()});
            return;
        }
        int start = -1;
        Iterator i$ = set.iterator();
        while (true) {
            File target;
            String path;
            URL url;
            block19: {
                if (!i$.hasNext()) {
                    return;
                }
                url = (URL)i$.next();
                path = url.getPath();
                if (start == -1) {
                    if (sourceFile.length() == 0 || sourceFile.endsWith("/")) {
                        if ("jar".equals(url.getProtocol())) {
                            start = path.lastIndexOf("!/") + 2 + sourceFile.length();
                            break block19;
                        } else {
                            start = path.length();
                            continue;
                        }
                    }
                    String remove = sourceFile;
                    int pos = sourceFile.lastIndexOf(47);
                    if (pos > -1) {
                        remove = sourceFile.substring(pos + 1, sourceFile.length());
                    }
                    start = path.lastIndexOf(remove);
                }
            }
            if (!(target = new File(targetURI.resolve(path = path.substring(start)))).exists()) {
                if (path.endsWith("/")) {
                    if (target.mkdirs()) continue;
                    log.error("Plugin install cannot create directory {}", (Object)target.getAbsolutePath());
                    continue;
                }
                if (!target.createNewFile()) {
                    log.error("Plugin install cannot create new file {}", (Object)target.getAbsolutePath());
                    continue;
                }
            }
            if (target.isDirectory()) continue;
            if (!target.canWrite()) {
                log.error("Plugin install cannot write to file {}", (Object)target.getAbsolutePath());
                continue;
            }
            this.copyFile(url.openStream(), new FileOutputStream(target));
        }
    }

    private static void createDirectory(File dir) throws IOException {
        boolean success;
        if (dir != null && !dir.exists() && !(success = dir.mkdirs())) {
            throw new IOException("Cannot create directory " + dir.getAbsolutePath());
        }
    }

    private void copyFile(InputStream in, FileOutputStream out) throws IOException {
        int count;
        byte[] buf = new byte[4096];
        while ((count = in.read(buf)) > -1) {
            out.write(buf, 0, count);
        }
        in.close();
        out.flush();
        out.close();
    }

    private static Dependency[] getDependencies(Repository repo, Artifact artifact) {
        LinkedHashSet set = repo.getDependencies(artifact);
        Dependency[] results = new Dependency[set.size()];
        int index = 0;
        for (Artifact dep : set) {
            results[index] = new Dependency(dep, ImportType.CLASSES);
            ++index;
        }
        return results;
    }

    private static Dependency[] getDependencies(ConfigurationData data) {
        ArrayList dependencies = new ArrayList(data.getEnvironment().getDependencies());
        Collection children = data.getChildConfigurations().values();
        for (ConfigurationData child : children) {
            dependencies.addAll(child.getEnvironment().getDependencies());
        }
        return dependencies.toArray(new Dependency[dependencies.size()]);
    }

    private void readNameAndID(File xml, Map<String, Artifact> plugins) {
        try {
            SAXParserFactory factory = XmlUtil.newSAXParserFactory();
            SAXParser parser = factory.newSAXParser();
            PluginNameIDHandler handler = new PluginNameIDHandler();
            parser.parse(xml, (DefaultHandler)handler);
            if (handler.isComplete()) {
                plugins.put(handler.getName(), Artifact.create((String)handler.getID()));
            }
        }
        catch (Exception e) {
            log.warn("Invalid XML at " + xml.getAbsolutePath(), (Throwable)e);
        }
    }

    private void readNameAndID(InputStream xml, Map plugins) {
        try {
            SAXParserFactory factory = XmlUtil.newSAXParserFactory();
            SAXParser parser = factory.newSAXParser();
            PluginNameIDHandler handler = new PluginNameIDHandler();
            parser.parse(xml, (DefaultHandler)handler);
            if (handler.isComplete()) {
                plugins.put(handler.getName(), Artifact.create((String)handler.getID()));
            }
        }
        catch (Exception e) {
            log.warn("Invalid XML", (Throwable)e);
        }
    }

    private PluginType createDefaultMetadata(Artifact moduleId) throws InvalidConfigException, IOException, NoSuchConfigException {
        if (this.configManager != null ? !this.configManager.isConfiguration(moduleId) : !this.configStore.containsConfiguration(moduleId)) {
            return null;
        }
        ConfigurationData data = this.configStore.loadConfiguration(moduleId);
        PluginType meta = new PluginType();
        PluginArtifactType instance = new PluginArtifactType();
        meta.getPluginArtifact().add(instance);
        meta.setName(PluginInstallerGBean.toArtifactType(moduleId).getArtifactId());
        instance.setModuleId(PluginInstallerGBean.toArtifactType(moduleId));
        meta.setCategory("Unknown");
        instance.getGeronimoVersion().add(this.serverInfo.getVersion());
        instance.getObsoletes().add(PluginInstallerGBean.toArtifactType(new Artifact(moduleId.getGroupId(), moduleId.getArtifactId(), (Version)null, moduleId.getType())));
        List deps = instance.getDependency();
        PluginInstallerGBean.addGeronimoDependencies(data, deps, true);
        return meta;
    }

    private boolean checkJVMVersions(List<String> jvmVersions) {
        if (jvmVersions.size() == 0) {
            return true;
        }
        String version = System.getProperty("java.version");
        boolean match = false;
        for (String jvmVersion : jvmVersions) {
            if (jvmVersion == null || jvmVersion.equals("")) {
                log.error("jvm-version should not be empty.");
                throw new IllegalStateException("jvm-version should not be empty.");
            }
            if (!version.startsWith(jvmVersion)) continue;
            match = true;
            break;
        }
        return match;
    }

    private boolean checkGeronimoVersions(List<String> gerVersions) throws IllegalStateException {
        String gerVersion;
        if (gerVersions == null || gerVersions.size() == 0) {
            return true;
        }
        boolean match = false;
        Iterator<String> i$ = gerVersions.iterator();
        while (i$.hasNext() && !(match = this.checkGeronimoVersion(gerVersion = i$.next()))) {
        }
        return match;
    }

    private boolean checkGeronimoVersion(String gerVersion) throws IllegalStateException {
        String version = this.serverInfo.getVersion();
        if (gerVersion == null || gerVersion.equals("")) {
            log.error("geronimo-version cannot be empty.");
            throw new IllegalStateException("geronimo-version cannot be empty.");
        }
        return gerVersion.equals(version);
    }

    public static void addGeronimoDependencies(ConfigurationData data, List<DependencyType> deps, boolean includeVersion) {
        PluginInstallerGBean.processDependencyList(data.getEnvironment().getDependencies(), deps, includeVersion);
        Map children = data.getChildConfigurations();
        for (ConfigurationData child : children.values()) {
            PluginInstallerGBean.processDependencyList(child.getEnvironment().getDependencies(), deps, includeVersion);
        }
    }

    private static void processDependencyList(List<Dependency> real, List<DependencyType> deps, boolean includeVersion) {
        for (Dependency dep : real) {
            DependencyType dependency = PluginInstallerGBean.toDependencyType(dep, includeVersion);
            if (deps.contains(dependency)) continue;
            deps.add(dependency);
        }
    }

    public static DependencyType toDependencyType(Dependency dep, boolean includeVersion) {
        Artifact id = dep.getArtifact();
        DependencyType dependency = new DependencyType();
        dependency.setGroupId(id.getGroupId());
        dependency.setArtifactId(id.getArtifactId());
        if (includeVersion) {
            dependency.setVersion(id.getVersion() == null ? null : id.getVersion().toString());
        }
        dependency.setType(id.getType());
        return dependency;
    }

    public static Artifact toArtifact(ArtifactType moduleId) {
        String groupId = moduleId.getGroupId();
        String artifactId = moduleId.getArtifactId();
        String version = moduleId.getVersion();
        String type = moduleId.getType();
        return new Artifact(groupId, artifactId, version, type);
    }

    public static ArtifactType toArtifactType(Artifact id) {
        ArtifactType artifact = new ArtifactType();
        artifact.setGroupId(id.getGroupId());
        artifact.setArtifactId(id.getArtifactId());
        artifact.setVersion(id.getVersion() == null ? null : id.getVersion().toString());
        artifact.setType(id.getType());
        return artifact;
    }

    public static PluginType copy(PluginType metadata, PluginArtifactType instance) {
        PluginType copy = new PluginType();
        copy.setAuthor(metadata.getAuthor());
        copy.setCategory(metadata.getCategory());
        copy.setPluginGroup(Boolean.valueOf(metadata.isPluginGroup() == null ? false : metadata.isPluginGroup()));
        copy.setDescription(metadata.getDescription());
        copy.setName(metadata.getName());
        copy.setUrl(metadata.getUrl());
        copy.getLicense().addAll(metadata.getLicense());
        if (instance != null) {
            copy.getPluginArtifact().add(instance);
        }
        return copy;
    }

    public static PluginType toKey(PluginType metadata) {
        PluginKey copy = new PluginKey();
        copy.setAuthor(metadata.getAuthor());
        copy.setCategory(metadata.getCategory());
        copy.setPluginGroup(metadata.isPluginGroup() == null ? false : metadata.isPluginGroup());
        copy.setDescription(metadata.getDescription());
        copy.setName(metadata.getName());
        copy.setUrl(metadata.getUrl());
        copy.getLicense().addAll(metadata.getLicense());
        return copy;
    }

    @Override
    public PluginListType createPluginListForRepositories(String repo) throws NoSuchStoreException {
        PluginListType pluginList = this.localSourceRepository.getPluginList();
        if (repo != null) {
            pluginList.getDefaultRepository().add(repo);
        }
        return pluginList;
    }

    private void installConfigXMLData(Artifact configID, PluginArtifactType pluginData, Map<String, ServerInstance> servers, boolean loadOverride) throws InvalidGBeanException, IOException, NoServerInstanceException {
        ServerInstance serverInstance;
        String serverName;
        Map<String, Properties> propertiesMap;
        if (this.configManager.isConfiguration(configID)) {
            if (pluginData != null && !pluginData.getConfigXmlContent().isEmpty()) {
                for (ConfigXmlContentType configXmlContent : pluginData.getConfigXmlContent()) {
                    String serverName2 = configXmlContent.getServer();
                    ServerInstance serverInstance2 = this.getServerInstance(serverName2, servers);
                    serverInstance2.getAttributeStore().setModuleGBeans(configID, configXmlContent.getGbean(), loadOverride && configXmlContent.isLoad(), configXmlContent.getCondition());
                }
            } else {
                ServerInstance serverInstance3 = this.getServerInstance("default", servers);
                serverInstance3.getAttributeStore().setModuleGBeans(configID, null, loadOverride, null);
            }
        }
        if (pluginData == null) {
            return;
        }
        if (!pluginData.getConfigSubstitution().isEmpty()) {
            propertiesMap = this.toPropertiesMap(pluginData.getConfigSubstitution());
            for (Map.Entry<String, Properties> entry : propertiesMap.entrySet()) {
                serverName = entry.getKey();
                serverInstance = this.getServerInstance(serverName, servers);
                serverInstance.getAttributeStore().addConfigSubstitutions(entry.getValue());
            }
        }
        if (!pluginData.getArtifactAlias().isEmpty()) {
            propertiesMap = this.toPropertiesMap(pluginData.getArtifactAlias());
            for (Map.Entry<String, Properties> entry : propertiesMap.entrySet()) {
                serverName = entry.getKey();
                serverInstance = this.getServerInstance(serverName, servers);
                serverInstance.getArtifactResolver().addAliases(entry.getValue());
            }
        }
    }

    private ServerInstance getServerInstance(String serverName, Map<String, ServerInstance> servers) throws NoServerInstanceException {
        ServerInstance serverInstance = servers.get(serverName);
        if (serverInstance == null) {
            throw new NoServerInstanceException("No server instance configuration set up for name " + serverName);
        }
        return serverInstance;
    }

    private Map<String, Properties> toPropertiesMap(List<PropertyType> propertyTypes) {
        HashMap<String, Properties> propertiesMap = new HashMap<String, Properties>();
        for (PropertyType propertyType : propertyTypes) {
            String serverName = propertyType.getServer();
            Properties properties = (Properties)propertiesMap.get(serverName);
            if (properties == null) {
                properties = new Properties();
                propertiesMap.put(serverName, properties);
            }
            properties.setProperty(propertyType.getKey(), propertyType.getValue());
        }
        return propertiesMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getNextKey() {
        Class<PluginInstallerGBean> clazz = PluginInstallerGBean.class;
        synchronized (PluginInstallerGBean.class) {
            int value = ++counter;
            // ** MonitorExit[var1] (shouldn't be in output)
            return value;
        }
    }

    static {
        MAVEN_1_PATTERN_PART = Pattern.compile("(.+)-([0-9].+)\\.([^0-9]+)");
    }

    private static class LoggingPoller
    implements DownloadPoller {
        private final DownloadPoller downloadPoller;
        private final Logger log;

        private LoggingPoller(DownloadPoller downloadPoller, Logger log) {
            this.downloadPoller = downloadPoller;
            this.log = log;
        }

        public void addRemovedConfigID(Artifact obsolete) {
            this.log.debug("Removed artifact: {}", (Object)obsolete);
            this.downloadPoller.addRemovedConfigID(obsolete);
        }

        public void addInstalledConfigID(Artifact target) {
            this.log.debug("Installed artifact: {}", (Object)target);
            this.downloadPoller.addInstalledConfigID(target);
        }

        public void addRestartedConfigID(Artifact target) {
            this.log.debug("Restarted artifact: {}", (Object)target);
            this.downloadPoller.addRestartedConfigID(target);
        }

        public void addSkippedConfigID(MissingDependencyException e) {
            this.log.debug("Skipped artifact due to: ", (Throwable)e);
            this.downloadPoller.addSkippedConfigID(e);
        }

        public void addDependencyPresent(Artifact dep) {
            this.log.debug("Artifact already installed: {}", (Object)dep);
            this.downloadPoller.addDependencyPresent(dep);
        }

        public void addDependencyInstalled(Artifact dep) {
            this.log.debug("Installed dependency {}", (Object)dep);
            this.downloadPoller.addDependencyInstalled(dep);
        }

        public void setCurrentFile(String currentFile) {
            this.log.debug("Current file: {}", (Object)currentFile);
            this.downloadPoller.setCurrentFile(currentFile);
        }

        public void setCurrentMessage(String currentMessage) {
            this.log.debug(currentMessage);
            this.downloadPoller.setCurrentMessage(currentMessage);
        }

        public void setCurrentFilePercent(int currentFileProgress) {
            this.downloadPoller.setCurrentFilePercent(currentFileProgress);
        }

        public void addDownloadBytes(long bytes) {
            this.downloadPoller.addDownloadBytes(bytes);
        }

        public void setFailure(Exception failure) {
            this.log.debug("Failure: {}", (Throwable)failure);
            this.downloadPoller.setFailure(failure);
        }

        public void setFinished() {
            this.log.debug("Finished");
            this.downloadPoller.setFinished();
        }
    }

    private static class ResultsFileWriteMonitor
    implements FileWriteMonitor {
        private final DownloadPoller results;
        private int totalBytes;
        private String file;

        public ResultsFileWriteMonitor(DownloadPoller results, Logger log) {
            this.results = new LoggingPoller(results, log);
        }

        public void setTotalBytes(int totalBytes) {
            this.totalBytes = totalBytes;
        }

        public int getTotalBytes() {
            return this.totalBytes;
        }

        public void writeStarted(String fileDescription, int fileSize) {
            this.totalBytes = fileSize;
            this.file = fileDescription;
            this.results.setCurrentFile(fileDescription);
            this.results.setCurrentFilePercent(this.totalBytes > 0 ? 0 : -1);
            this.results.setCurrentMessage("Downloading " + this.file);
        }

        public void writeProgress(int bytes) {
            if (this.totalBytes > 0) {
                double percent = (double)bytes / (double)this.totalBytes;
                this.results.setCurrentFilePercent((int)(percent * 100.0));
            } else {
                this.results.setCurrentMessage(bytes / 1024 + " kB of " + this.file);
            }
        }

        public void writeComplete(int bytes) {
            this.results.setCurrentFilePercent(100);
            this.results.setCurrentMessage("Finished downloading " + this.file + " (" + bytes / 1024 + " kB)");
            this.results.addDownloadBytes(bytes);
        }

        public DownloadPoller getResults() {
            return this.results;
        }
    }

    private static class PluginNameIDHandler
    extends DefaultHandler {
        private String id = "";
        private String name = "";
        private String element = null;

        private PluginNameIDHandler() {
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.element != null) {
                if (this.element.equals("module-id")) {
                    this.id = this.id + new String(ch, start, length);
                } else if (this.element.equals("name")) {
                    this.name = this.name + new String(ch, start, length);
                }
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.element = null;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals("module-id") || qName.equals("name")) {
                this.element = qName;
            }
        }

        public void endDocument() throws SAXException {
            this.id = this.id.trim();
            this.name = this.name.trim();
        }

        public String getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public boolean isComplete() {
            return !this.id.equals("") && !this.name.equals("");
        }
    }

    private static class PluginKey
    extends PluginType {
        private static final long serialVersionUID = -3864898789387102435L;

        private PluginKey() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            PluginKey that = (PluginKey)((Object)o);
            if (this.author != null ? !this.author.equals(that.author) : that.author != null) {
                return false;
            }
            if (this.category != null ? !this.category.equals(that.category) : that.category != null) {
                return false;
            }
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
                return false;
            }
            if (this.pluginGroup != null ? this.pluginGroup != that.pluginGroup : that.pluginGroup != null) {
                return false;
            }
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
                return false;
            }
            if (this.url != null ? !this.url.equals(that.url) : that.url != null) {
                return false;
            }
            if (this.license == null != (that.license == null)) {
                return false;
            }
            if (this.license != null) {
                if (this.license.size() != that.license.size()) {
                    return false;
                }
                int i = 0;
                for (LicenseType licenseType : this.license) {
                    LicenseType otherLicense = (LicenseType)that.license.get(i++);
                    if (licenseType.isOsiApproved() != otherLicense.isOsiApproved()) {
                        return false;
                    }
                    if (!(licenseType.getValue() != null ? !licenseType.getValue().equals(otherLicense.getValue()) : otherLicense.getValue() != null)) continue;
                    return false;
                }
            }
            return true;
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.category != null ? this.category.hashCode() : 0);
            result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
            result = 31 * result + (this.author != null ? this.author.hashCode() : 0);
            return result;
        }
    }
}

