/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gjndi.binding;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.Name;
import javax.naming.NamingException;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamSpecial;
import org.apache.geronimo.gbean.annotation.SpecialAttributeType;
import org.apache.geronimo.gjndi.KernelContextGBean;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.repository.Artifact;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GBean(j2eeType="Context")
public class GBeanFormatBinding
extends KernelContextGBean {
    protected static final Logger log = LoggerFactory.getLogger(GBeanFormatBinding.class);
    private static final Pattern PATTERN = Pattern.compile("(\\{)(\\w+)(})");
    protected final String format;
    protected final Pattern namePattern;

    public GBeanFormatBinding(@ParamAttribute(name="format") String format, @ParamAttribute(name="namePattern") String namePattern, @ParamAttribute(name="nameInNamespace") String nameInNamespace, @ParamAttribute(name="abstractNameQuery") AbstractNameQuery abstractNameQuery, @ParamSpecial(type=SpecialAttributeType.kernel) Kernel kernel) throws NamingException {
        super(nameInNamespace, abstractNameQuery, kernel);
        this.format = format;
        this.namePattern = namePattern != null && namePattern.length() > 0 ? Pattern.compile(namePattern) : null;
    }

    @Override
    protected Name createBindingName(AbstractName abstractName, Object value) throws NamingException {
        Matcher matcher;
        String name = abstractName.getNameProperty("name");
        if (this.namePattern != null && !(matcher = this.namePattern.matcher(name)).matches()) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>(abstractName.getName());
        Artifact artifact = abstractName.getArtifact();
        map.put("groupId", artifact.getGroupId());
        map.put("artifactId", artifact.getArtifactId());
        map.put("version", artifact.getVersion().toString());
        map.put("type", artifact.getType());
        String fullName = GBeanFormatBinding.format(this.format, map);
        return this.getNameParser().parse(fullName);
    }

    static String format(String input, Map<String, String> map) {
        Matcher matcher = PATTERN.matcher(input);
        StringBuffer buf = new StringBuffer();
        while (matcher.find()) {
            String key = matcher.group(2);
            String value = map.get(key);
            matcher.appendReplacement(buf, value);
        }
        matcher.appendTail(buf);
        return buf.toString();
    }
}

