/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gjndi.binding;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.Name;
import javax.naming.NamingException;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gjndi.KernelContextGBean;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.repository.Artifact;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GBeanFormatBinding
extends KernelContextGBean {
    protected static final Logger log = LoggerFactory.getLogger(GBeanFormatBinding.class);
    private static final Pattern PATTERN = Pattern.compile("(\\{)(\\w+)(})");
    protected final String format;
    protected final Pattern namePattern;
    public static final GBeanInfo GBEAN_INFO;

    public GBeanFormatBinding(String format, String namePattern, String nameInNamespace, AbstractNameQuery abstractNameQuery, Kernel kernel) throws NamingException {
        super(nameInNamespace, abstractNameQuery, kernel);
        this.format = format;
        this.namePattern = namePattern != null && namePattern.length() > 0 ? Pattern.compile(namePattern) : null;
    }

    @Override
    protected Name createBindingName(AbstractName abstractName, Object value) throws NamingException {
        Matcher matcher;
        String name = abstractName.getNameProperty("name");
        if (this.namePattern != null && !(matcher = this.namePattern.matcher(name)).matches()) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>(abstractName.getName());
        Artifact artifact = abstractName.getArtifact();
        map.put("groupId", artifact.getGroupId());
        map.put("artifactId", artifact.getArtifactId());
        map.put("version", artifact.getVersion().toString());
        map.put("type", artifact.getType());
        String fullName = GBeanFormatBinding.format(this.format, map);
        return this.getNameParser().parse(fullName);
    }

    static String format(String input, Map<String, String> map) {
        Matcher matcher = PATTERN.matcher(input);
        StringBuffer buf = new StringBuffer();
        while (matcher.find()) {
            String key = matcher.group(2);
            String value = map.get(key);
            matcher.appendReplacement(buf, value);
        }
        matcher.appendTail(buf);
        return buf.toString();
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder builder = GBeanInfoBuilder.createStatic(GBeanFormatBinding.class, (GBeanInfo)KernelContextGBean.GBEAN_INFO, (String)"Context");
        builder.addAttribute("format", String.class, true);
        builder.addAttribute("namePattern", String.class, true);
        builder.setConstructor(new String[]{"format", "namePattern", "nameInNamespace", "abstractNameQuery", "kernel"});
        GBEAN_INFO = builder.getBeanInfo();
    }
}

