/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.config;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.geronimo.kernel.repository.Artifact;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LifecycleResults
implements Serializable {
    private static final long serialVersionUID = 4660197333193740244L;
    private final Set<Artifact> loaded = new LinkedHashSet<Artifact>();
    private final Set<Artifact> unloaded = new LinkedHashSet<Artifact>();
    private final Set<Artifact> started = new LinkedHashSet<Artifact>();
    private final Set<Artifact> stopped = new LinkedHashSet<Artifact>();
    private final Map<Artifact, Throwable> failed = new LinkedHashMap<Artifact, Throwable>();

    public boolean wasLoaded(Artifact configurationId) {
        return this.loaded.contains(configurationId);
    }

    public Set<Artifact> getLoaded() {
        return Collections.unmodifiableSet(this.loaded);
    }

    public void addLoaded(Artifact configurationId) {
        this.loaded.add(configurationId);
    }

    public void setLoaded(Set<Artifact> loaded) {
        this.loaded.clear();
        this.loaded.addAll(loaded);
    }

    public boolean wasUnloaded(Artifact configurationId) {
        return this.unloaded.contains(configurationId);
    }

    public Set<Artifact> getUnloaded() {
        return Collections.unmodifiableSet(this.unloaded);
    }

    public void addUnloaded(Artifact configurationId) {
        this.unloaded.add(configurationId);
    }

    public void setUnloaded(Set<Artifact> unloaded) {
        this.unloaded.clear();
        this.unloaded.addAll(unloaded);
    }

    public boolean wasStarted(Artifact configurationId) {
        return this.started.contains(configurationId);
    }

    public Set<Artifact> getStarted() {
        return Collections.unmodifiableSet(this.started);
    }

    public void addStarted(Artifact configurationId) {
        this.started.add(configurationId);
    }

    public void setStarted(Set<Artifact> started) {
        this.started.clear();
        this.started.addAll(started);
    }

    public boolean wasStopped(Artifact configurationId) {
        return this.stopped.contains(configurationId);
    }

    public Set<Artifact> getStopped() {
        return Collections.unmodifiableSet(this.stopped);
    }

    public void addStopped(Artifact configurationId) {
        this.stopped.add(configurationId);
    }

    public void setStopped(Set<Artifact> stopped) {
        this.stopped.clear();
        this.stopped.addAll(stopped);
    }

    public boolean wasFailed(Artifact configurationId) {
        for (Artifact failID : this.failed.keySet()) {
            if (!configurationId.matches(failID)) continue;
            return true;
        }
        return false;
    }

    public Throwable getFailedCause(Artifact configurationId) {
        return this.failed.get(configurationId);
    }

    public Map<Artifact, Throwable> getFailed() {
        return Collections.unmodifiableMap(this.failed);
    }

    public void addFailed(Artifact configurationId, Throwable cause) {
        this.failed.put(configurationId, cause);
    }

    public void setFailed(Map<Artifact, Throwable> failed) {
        this.failed.clear();
        this.failed.putAll(failed);
    }
}

