/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gbean;

import java.beans.Introspector;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.sf.cglib.reflect.FastClass;
import net.sf.cglib.reflect.FastMethod;
import org.apache.geronimo.gbean.DynamicGBean;
import org.apache.geronimo.gbean.GOperationSignature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicGBeanDelegate
implements DynamicGBean {
    private static final Map<Class, Class> TYPE_LOOKUP = new HashMap<Class, Class>();
    protected final Map getters = new HashMap();
    protected final Map setters = new HashMap();
    protected final Map operations = new HashMap();
    private Class targetClass;

    public void addAll(Object target) {
        this.targetClass = target.getClass();
        Method[] methods = this.targetClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (this.isGetter(method)) {
                this.addGetter(target, method);
                continue;
            }
            if (this.isSetter(method)) {
                this.addSetter(target, method);
                continue;
            }
            this.addOperation(target, method);
        }
    }

    public void addGetter(Object target, Method method) {
        String name = method.getName();
        if (name.startsWith("get")) {
            this.addGetter(name.substring(3), target, method);
        } else if (name.startsWith("is")) {
            this.addGetter(name.substring(2), target, method);
        } else {
            throw new IllegalArgumentException("Method name must start with 'get' or 'is' " + method);
        }
    }

    public void addGetter(String name, Object target, Method method) {
        if (method.getParameterTypes().length != 0 || method.getReturnType() == Void.TYPE) {
            throw new IllegalArgumentException("Method must take no parameters and return a value " + method);
        }
        this.getters.put(name, new Operation(target, method));
        this.getters.put(Introspector.decapitalize(name), new Operation(target, method));
    }

    public void addSetter(Object target, Method method) {
        if (!method.getName().startsWith("set")) {
            throw new IllegalArgumentException("Method name must start with 'set' " + method);
        }
        this.addSetter(method.getName().substring(3), target, method);
    }

    public void addSetter(String name, Object target, Method method) {
        if (method.getParameterTypes().length != 1 || method.getReturnType() != Void.TYPE) {
            throw new IllegalArgumentException("Method must take one parameter and not return anything " + method);
        }
        Class<?> type = method.getParameterTypes()[0];
        Operation operation = new Operation(target, method);
        this.addSetter(name, type, operation);
        this.addSetter(Introspector.decapitalize(name), type, operation);
    }

    private void addSetter(String name, Class type, Operation operation) {
        HashMap<Class, Operation> operations = (HashMap<Class, Operation>)this.setters.get(name);
        if (operations == null) {
            operations = new HashMap<Class, Operation>();
            this.setters.put(name, operations);
        }
        operations.put(type, operation);
    }

    public void addOperation(Object target, Method method) {
        Class<?>[] parameters = method.getParameterTypes();
        String[] types = new String[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            types[i] = parameters[i].getName();
        }
        GOperationSignature key = new GOperationSignature(method.getName(), types);
        this.operations.put(key, new Operation(target, method));
    }

    private boolean isGetter(Method method) {
        String name = method.getName();
        return (name.startsWith("get") || name.startsWith("is")) && method.getParameterTypes().length == 0 && method.getReturnType() != Void.TYPE;
    }

    private boolean isSetter(Method method) {
        return method.getName().startsWith("set") && method.getParameterTypes().length == 1 && method.getReturnType() == Void.TYPE;
    }

    @Override
    public Object getAttribute(String name) throws Exception {
        Operation operation = (Operation)this.getters.get(name);
        if (operation == null) {
            throw new IllegalArgumentException(this.targetClass.getName() + ": no getter for " + name);
        }
        return operation.invoke(null);
    }

    @Override
    public void setAttribute(String name, Object value) throws Exception {
        Class<?> valueType;
        Map operations = (Map)this.setters.get(name);
        if (operations == null) {
            throw new IllegalArgumentException(this.targetClass.getName() + ": no setters for " + name);
        }
        Operation operation = null;
        if (operations.size() == 1) {
            operation = (Operation)operations.values().iterator().next();
        } else if (value == null) {
            operation = (Operation)operations.values().iterator().next();
        } else if (value != null && (operation = (Operation)operations.get(valueType = value.getClass())) == null) {
            operation = this.findOperation(operations, valueType);
            if (operation == null && TYPE_LOOKUP.containsKey(valueType)) {
                operation = this.findOperation(operations, TYPE_LOOKUP.get(valueType));
            }
            if (operation == null) {
                throw new IllegalArgumentException(this.targetClass.getName() + ": no setter for " + name + " of type " + valueType);
            }
        }
        operation.invoke(new Object[]{value});
    }

    private Operation findOperation(Map<Class, Operation> operations, Class type) {
        for (Map.Entry<Class, Operation> entry : operations.entrySet()) {
            if (!entry.getKey().isAssignableFrom(type)) continue;
            return entry.getValue();
        }
        return null;
    }

    @Override
    public Object invoke(String name, Object[] arguments, String[] types) throws Exception {
        GOperationSignature signature = new GOperationSignature(name, types);
        Operation operation = (Operation)this.operations.get(signature);
        if (operation == null) {
            throw new IllegalArgumentException(this.targetClass.getName() + ": no operation " + signature);
        }
        return operation.invoke(arguments);
    }

    public String[] getProperties() {
        Set one = this.getters.keySet();
        Set two = this.setters.keySet();
        ArrayList<String> out = new ArrayList<String>();
        for (String name : one) {
            if (!Character.isLowerCase(name.charAt(0)) || !two.contains(name)) continue;
            out.add(name);
        }
        return out.toArray(new String[out.size()]);
    }

    public Class getPropertyType(String name) {
        Operation oper = (Operation)this.getters.get(name);
        return oper.method.getReturnType();
    }

    static {
        TYPE_LOOKUP.put(Byte.class, Byte.TYPE);
        TYPE_LOOKUP.put(Integer.class, Integer.TYPE);
        TYPE_LOOKUP.put(Short.class, Short.TYPE);
        TYPE_LOOKUP.put(Long.class, Long.TYPE);
        TYPE_LOOKUP.put(Float.class, Float.TYPE);
        TYPE_LOOKUP.put(Double.class, Double.TYPE);
        TYPE_LOOKUP.put(Boolean.class, Boolean.TYPE);
        TYPE_LOOKUP.put(Character.class, Character.TYPE);
    }

    protected static class Operation {
        private final Object target;
        private final FastMethod method;

        public Operation(Object target, Method method) {
            assert (target != null);
            assert (method != null);
            this.target = target;
            this.method = FastClass.create(target.getClass()).getMethod(method);
        }

        public Object invoke(Object[] arguments) throws Exception {
            try {
                return this.method.invoke(this.target, arguments);
            }
            catch (InvocationTargetException e) {
                Throwable targetException = e.getTargetException();
                if (targetException instanceof Exception) {
                    throw (Exception)targetException;
                }
                if (targetException instanceof Error) {
                    throw (Error)targetException;
                }
                throw e;
            }
        }
    }
}

