/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;

public class DelegatingDriver
implements Driver {
    private static final List<Driver> DRIVERS = new CopyOnWriteArrayList<Driver>();

    public static void registerDriver(Driver instance) {
        DRIVERS.add(instance);
    }

    public static void unregisterDriver(Driver instance) {
        DRIVERS.remove(instance);
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        for (Driver driver : DRIVERS) {
            Connection conn = driver.connect(url, info);
            if (conn == null) continue;
            return conn;
        }
        return null;
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        for (Driver driver : DRIVERS) {
            if (!driver.acceptsURL(url)) continue;
            return true;
        }
        return false;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    static {
        try {
            DriverManager.registerDriver(new DelegatingDriver());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

