/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.util.osgi;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.geronimo.deployment.util.osgi.ExportPackagesSelector;
import org.apache.geronimo.deployment.util.osgi.OSGiBuildContext;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.Dependency;
import org.apache.geronimo.system.configuration.DependencyManager;
import org.apache.xbean.osgi.bundle.util.BundleDescription;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HighVersionFirstExportPackagesSelector
implements ExportPackagesSelector {
    private static final Logger logger = LoggerFactory.getLogger(HighVersionFirstExportPackagesSelector.class);

    @Override
    public Map<Long, Set<BundleDescription.ExportPackage>> select(OSGiBuildContext context) {
        HashMap<Long, Set<BundleDescription.ExportPackage>> bundleIdExportPackages = new HashMap<Long, Set<BundleDescription.ExportPackage>>();
        HashMap<String, Version> packageNameVersionMap = new HashMap<String, Version>();
        DependencyManager dependencyManager = context.getDependencyManager();
        for (Dependency dependency : context.getEnvironment().getDependencies()) {
            Artifact resolvedArtifact = context.resolveArtifact(dependency.getArtifact());
            if (resolvedArtifact == null) {
                logger.warn("Dependency " + dependency.getArtifact() + " could not be resolved, its export packages are ignored");
                continue;
            }
            Bundle dependentBundle = dependencyManager.getBundle(resolvedArtifact);
            if (dependentBundle == null) {
                logger.warn("Fail to resolve the bundle corresponding to the artifact " + dependency.getArtifact() + ", its export packages are ignored");
                continue;
            }
            Set<BundleDescription.ExportPackage> exportPackages = context.getEffectExportPackages(dependentBundle.getBundleId());
            if (exportPackages.size() > 0) {
                bundleIdExportPackages.put(dependentBundle.getBundleId(), exportPackages);
                this.recordHighestPackageVersion(packageNameVersionMap, exportPackages);
            }
            for (Long parentDependentBundleId : context.getFullDependentBundleIds(dependentBundle)) {
                Set<BundleDescription.ExportPackage> parentExportPackages;
                if (bundleIdExportPackages.containsKey(parentDependentBundleId) || (parentExportPackages = context.getEffectExportPackages(parentDependentBundleId)).size() <= 0) continue;
                bundleIdExportPackages.put(parentDependentBundleId, parentExportPackages);
                this.recordHighestPackageVersion(packageNameVersionMap, parentExportPackages);
            }
        }
        Set<BundleDescription.ExportPackage> systemExportPackages = context.getEffectExportPackages(0L);
        bundleIdExportPackages.put(0L, systemExportPackages);
        this.recordHighestPackageVersion(packageNameVersionMap, systemExportPackages);
        Iterator entryIt = bundleIdExportPackages.entrySet().iterator();
        while (entryIt.hasNext()) {
            Map.Entry entry = entryIt.next();
            Iterator it = ((Set)entry.getValue()).iterator();
            while (it.hasNext()) {
                BundleDescription.ExportPackage exportPackage = (BundleDescription.ExportPackage)it.next();
                Version highestVersion = (Version)packageNameVersionMap.get(exportPackage.getName());
                if (highestVersion == exportPackage.getVersion()) continue;
                it.remove();
            }
            if (((Set)entry.getValue()).size() != 0) continue;
            entryIt.remove();
        }
        packageNameVersionMap.clear();
        return bundleIdExportPackages;
    }

    private void recordHighestPackageVersion(Map<String, Version> packageNameVersionMap, Set<BundleDescription.ExportPackage> exportPackages) {
        for (BundleDescription.ExportPackage exportPackage : exportPackages) {
            Version existedVersion = packageNameVersionMap.get(exportPackage.getName());
            if (existedVersion != null && exportPackage.getVersion().compareTo(existedVersion) <= 0) continue;
            packageNameVersionMap.put(exportPackage.getName(), exportPackage.getVersion());
        }
    }
}

