/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.DeploymentContext;
import org.apache.geronimo.deployment.ResourceContext;
import org.apache.geronimo.kernel.util.IOUtils;
import org.apache.geronimo.kernel.util.JarUtils;

class CopyResourceContext
implements ResourceContext {
    private final DeploymentContext deploymentContext;
    private final byte[] buffer = new byte[4096];
    private File baseDir;

    public CopyResourceContext(DeploymentContext deploymentContext, File baseDir) throws DeploymentException {
        this.deploymentContext = deploymentContext;
        if (baseDir.isFile()) {
            deploymentContext.addToClassPath("");
        }
        this.baseDir = baseDir;
    }

    @Override
    public void addIncludeAsPackedJar(URI targetPath, JarFile jarFile) throws IOException {
        if (targetPath.getPath().endsWith("/")) {
            throw new IllegalStateException("target path must not end with a '/' character: " + targetPath);
        }
        File targetFile = this.getTargetFile(targetPath);
        JarUtils.copyToPackedJar((JarFile)jarFile, (File)targetFile);
        if (!targetFile.isFile()) {
            throw new IllegalStateException("target file should be a file: " + targetFile);
        }
        this.deploymentContext.addToClassPath(targetPath.toString());
    }

    @Override
    public void addInclude(URI targetPath, ZipFile zipFile, ZipEntry zipEntry) throws IOException {
        File targetFile = this.getTargetFile(targetPath);
        this.addFile(targetFile, zipFile, zipEntry);
        this.deploymentContext.addToClassPath(targetPath.toString());
    }

    @Override
    public void addInclude(URI targetPath, URL source) throws IOException {
        if (targetPath.getPath().endsWith("/")) {
            throw new IllegalStateException("target path must not end with a '/' character: " + targetPath);
        }
        File targetFile = this.getTargetFile(targetPath);
        this.addFile(targetFile, source);
        if (!targetFile.isFile()) {
            throw new IllegalStateException("target file should be a file: " + targetFile);
        }
        this.deploymentContext.addToClassPath(targetPath.toString());
    }

    @Override
    public void addInclude(URI targetPath, File source) throws IOException {
        if (targetPath.getPath().endsWith("/")) {
            throw new IllegalStateException("target path must not end with a '/' character: " + targetPath);
        }
        File targetFile = this.getTargetFile(targetPath);
        this.addFile(targetFile, source);
        if (!targetFile.isFile()) {
            throw new IllegalStateException("target file should be a file: " + targetFile);
        }
        this.deploymentContext.addToClassPath(targetPath.toString());
    }

    @Override
    public void addFile(URI targetPath, ZipFile zipFile, ZipEntry zipEntry) throws IOException {
        this.addFile(this.getTargetFile(targetPath), zipFile, zipEntry);
    }

    @Override
    public void addFile(URI targetPath, URL source) throws IOException {
        this.addFile(this.getTargetFile(targetPath), source);
    }

    @Override
    public void addFile(URI targetPath, File source) throws IOException {
        this.addFile(this.getTargetFile(targetPath), source);
    }

    @Override
    public void addFile(URI targetPath, String source) throws IOException {
        this.addFile(this.getTargetFile(targetPath), new ByteArrayInputStream(source.getBytes()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFile(URI targetPath, byte[] contents) throws IOException {
        File file = this.getTargetFile(targetPath);
        if (!file.getParentFile().mkdirs()) {
            throw new IOException("Could not create parent directory for entry: " + targetPath + " at " + file.getParentFile());
        }
        FileOutputStream out = new FileOutputStream(file);
        try {
            out.write(contents);
        }
        finally {
            IOUtils.close((Closeable)out);
        }
    }

    @Override
    public File getTargetFile(URI targetPath) {
        if (targetPath == null) {
            throw new NullPointerException("targetPath is null");
        }
        if (targetPath.isAbsolute()) {
            throw new IllegalArgumentException("targetPath is absolute");
        }
        if (targetPath.isOpaque()) {
            throw new IllegalArgumentException("targetPath is opaque");
        }
        return new File(this.baseDir, targetPath.toString());
    }

    @Override
    public URL getTargetURL(URI targetPath) {
        File file = this.getTargetFile(targetPath);
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Malformed URL", e);
        }
    }

    @Override
    public void flush() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFile(File targetFile, ZipFile zipFile, ZipEntry zipEntry) throws IOException {
        if (zipEntry.isDirectory()) {
            targetFile.mkdirs();
        } else {
            InputStream is = zipFile.getInputStream(zipEntry);
            try {
                this.addFile(targetFile, is);
            }
            finally {
                IOUtils.close((Closeable)is);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFile(File targetFile, URL source) throws IOException {
        InputStream in = null;
        try {
            in = source.openStream();
            this.addFile(targetFile, in);
        }
        finally {
            IOUtils.close((Closeable)in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFile(File targetFile, File source) throws IOException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(source);
            this.addFile(targetFile, in);
        }
        catch (Throwable throwable) {
            IOUtils.close(in);
            throw throwable;
        }
        IOUtils.close((Closeable)in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFile(File targetFile, InputStream source) throws IOException {
        targetFile.getParentFile().mkdirs();
        FileOutputStream out = null;
        try {
            int count;
            out = new FileOutputStream(targetFile);
            while ((count = source.read(this.buffer)) > 0) {
                ((OutputStream)out).write(this.buffer, 0, count);
            }
        }
        catch (Throwable throwable) {
            IOUtils.close(out);
            throw throwable;
        }
        IOUtils.close((Closeable)out);
    }
}

