/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.xml;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.geronimo.deployment.xml.ParserFactory;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.kernel.util.XmlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public class ParserFactoryImpl
implements ParserFactory {
    private static final Logger log = LoggerFactory.getLogger(ParserFactoryImpl.class);
    private final DocumentBuilderFactory factory;
    private EntityResolver entityResolver;
    public static final GBeanInfo GBEAN_INFO;

    public ParserFactoryImpl(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
        this.factory = XmlUtil.newDocumentBuilderFactory();
        this.factory.setNamespaceAware(true);
        this.factory.setValidating(true);
        this.factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        this.factory.setAttribute("http://apache.org/xml/features/validation/schema", Boolean.TRUE);
    }

    public DocumentBuilder getParser() throws ParserConfigurationException {
        DocumentBuilder builder = this.factory.newDocumentBuilder();
        builder.setEntityResolver(this.entityResolver);
        builder.setErrorHandler(new ErrorHandler(){

            public void error(SAXParseException exception) {
                log.warn("SAX parse error (ignored)", (Throwable)exception);
            }

            public void fatalError(SAXParseException exception) {
                log.warn("Fatal SAX parse error (ignored)", (Throwable)exception);
            }

            public void warning(SAXParseException exception) {
                log.warn("SAX parse warning", (Throwable)exception);
            }
        });
        return builder;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic((String)"Factory for constructing suitable configured xml parsers", ParserFactoryImpl.class);
        infoFactory.addOperation("getParser");
        infoFactory.addReference("EntityResolver", EntityResolver.class, "GBean");
        infoFactory.setConstructor(new String[]{"EntityResolver"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

