/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment;

import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.kernel.repository.Version;

public class ModuleIDBuilder {
    private Version defaultVersion = new Version(Long.toString(System.currentTimeMillis()));
    private String defaultGroup = "default";

    public void setDefaultGroup(String defaultGroup) {
        this.defaultGroup = defaultGroup;
    }

    public void setDefaultVersion(Version defaultVersion) {
        this.defaultVersion = defaultVersion;
    }

    public Artifact resolve(Artifact argument, String defaultType) {
        if (argument.isResolved()) {
            return argument;
        }
        if (argument.getArtifactId() == null || argument.getArtifactId().equals("")) {
            throw new IllegalArgumentException("Incoming Artifact must have an ArtifactID (not " + argument + ")");
        }
        return new Artifact(argument.getGroupId() == null || argument.getGroupId().equals("") ? this.defaultGroup : argument.getGroupId(), argument.getArtifactId(), argument.getVersion() == null ? this.defaultVersion : argument.getVersion(), argument.getType() == null || argument.getType().equals("") ? defaultType : argument.getType());
    }

    public Artifact createDefaultArtifact(String defaultArtifact, String defaultType) {
        return new Artifact(this.defaultGroup, defaultArtifact, this.defaultVersion, defaultType);
    }

    public void resolve(Environment environment, String defaultArtifactId, String defaultType) {
        if (environment.getConfigId() == null) {
            environment.setConfigId(this.resolve(new Artifact(null, defaultArtifactId, (Version)null, defaultType), defaultType));
        } else if (!environment.getConfigId().isResolved()) {
            environment.setConfigId(this.resolve(environment.getConfigId(), defaultType));
        }
    }
}

